/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdm.util;

import java.lang.reflect.Array;

public class ToStringBuilder {
    private static final String DEFAULT_OPERATION_PREFIX = "Invoking operation ";
    private static final String DEFAULT_ARRAY_OBJECTS_SEPARATOR = "; ";
    private static ToStringBuilder instance;
    private String operationPrefix = "Invoking operation ";
    private String arrayObjectsSeparator = "; ";

    protected ToStringBuilder() {
    }

    public static synchronized ToStringBuilder getInstance() {
        if (instance == null) {
            instance = new ToStringBuilder();
        }
        return instance;
    }

    public String toString(Object obj) {
        if (obj == null) {
            return "null";
        }
        Class<?> clazz = obj.getClass();
        if (clazz.isArray()) {
            return this.arrayToString(obj);
        }
        return this.objectToString(obj);
    }

    public String operationToString(String operationSignature) {
        return this.operationToString(operationSignature, null);
    }

    public String operationToString(String operationSignature, Object[] operationArguments) {
        return this.operationToString(operationSignature, operationArguments, null);
    }

    public String operationToString(String operationSignature, Object[] operationArguments, Object operationResult) {
        return this.getOperationPrefix() + operationSignature + "(" + (operationArguments == null ? "" : this.toString(operationArguments)) + ")" + (operationResult == null ? "" : " : " + this.toString(operationResult));
    }

    public String voidOperationToString(String operationSignature) {
        return this.voidOperationToString(operationSignature, null);
    }

    public String voidOperationToString(String operationSignature, Object[] operationArguments) {
        return this.getOperationPrefix() + operationSignature + "(" + (operationArguments == null ? "" : this.toString(operationArguments)) + ") : void";
    }

    protected String arrayToString(Object array) {
        if (array == null) {
            return "null";
        }
        int length = Array.getLength(array);
        StringBuffer sbStringRepresentation = new StringBuffer();
        sbStringRepresentation.append("[ ");
        int i = 0;
        while (i < length) {
            Object arrItem = Array.get(array, i);
            sbStringRepresentation.append(this.toString(arrItem));
            sbStringRepresentation.append(this.getArrayObjectsSeparator());
            ++i;
        }
        sbStringRepresentation.append("]");
        return sbStringRepresentation.toString();
    }

    protected String objectToString(Object obj) {
        if (obj == null) {
            return "null";
        }
        return obj.getClass().getName() + " \"" + obj.toString() + "\"";
    }

    public String getOperationPrefix() {
        return this.operationPrefix == null ? "" : this.operationPrefix;
    }

    public void setOperationPrefix(String operationPrefix) {
        this.operationPrefix = operationPrefix;
    }

    public String getArrayObjectsSeparator() {
        return this.arrayObjectsSeparator == null ? "" : this.arrayObjectsSeparator;
    }

    public void setArrayObjectsSeparator(String arrayObjectsSeparator) {
        this.arrayObjectsSeparator = arrayObjectsSeparator;
    }
}

