/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdm.diag;

import com.sap.sdm.diag.DiagException;
import com.sap.sdm.diag.FileNotFoundException;
import com.sap.sdm.diag.InfoProviderIF;
import com.sap.sdm.diag.JavaException;
import com.sap.sdm.diag.MissingInfoException;
import com.sap.sdm.util.FileList;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public abstract class AbstractInfoProvider
extends Properties
implements InfoProviderIF,
FilenameFilter {
    public void set(String var, String val) {
        this.setProperty(var, val);
    }

    public String get(String var) {
        try {
            return this.getE(var);
        }
        catch (MissingInfoException e) {
            return null;
        }
    }

    public String get(String var, String p0) {
        try {
            return this.getE(var, p0);
        }
        catch (MissingInfoException e) {
            return null;
        }
    }

    public String get(String var, String p0, String p1) {
        try {
            return this.getE(var, p0, p1);
        }
        catch (MissingInfoException e) {
            return null;
        }
    }

    public String get(String var, String[] params) {
        try {
            return this.getE(var, params);
        }
        catch (MissingInfoException e) {
            return null;
        }
    }

    public abstract String getE(String var1) throws MissingInfoException;

    public abstract String getE(String var1, String[] var2) throws MissingInfoException;

    public String getE(String var, String p0) throws MissingInfoException {
        String[] params = new String[]{p0};
        return this.getE(var, params);
    }

    public String getE(String var, String p0, String p1) throws MissingInfoException {
        String[] params = new String[]{p0, p1};
        return this.getE(var, params);
    }

    public boolean accept(File dir, String name) {
        return name.endsWith(".properties");
    }

    public void load(String pathName) throws DiagException {
        File[] files = FileList.getFileList(this, pathName);
        int i = 0;
        while (i < files.length) {
            try {
                FileInputStream stream = new FileInputStream(files[i]);
                this.load(stream);
            }
            catch (java.io.FileNotFoundException fnfE) {
                throw new FileNotFoundException(files[i].getAbsolutePath());
            }
            catch (IOException ioE) {
                throw new JavaException(ioE);
            }
            ++i;
        }
    }

    public void loadFromResource(Class clazz, String resourceName) throws DiagException {
        try {
            InputStream inStream = clazz.getResourceAsStream(resourceName);
            this.load(inStream);
        }
        catch (IOException ioE) {
            throw new JavaException(ioE);
        }
    }
}

