/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.model.ui.navigator.filter;

import com.tssap.selena.internal.model.ui.navigator.ModelTreeViewer;
import com.tssap.selena.internal.model.ui.navigator.NavigatorPlugin;
import com.tssap.selena.internal.model.ui.navigator.filter.NavigatorFilter;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public class UserFilterAction
extends Action
implements IPropertyChangeListener {
    private NavigatorFilter myFilter;
    private ModelTreeViewer myNavigator;
    private boolean myIsVisible;

    public UserFilterAction(ModelTreeViewer navigator, NavigatorFilter filter, Boolean defaultValue, boolean isVisible) {
        super(filter.getDisplayName());
        this.myIsVisible = isVisible;
        this.myFilter = filter;
        this.myNavigator = navigator;
        if (defaultValue != null) {
            this.setDefaultValue(defaultValue);
        }
        this.restoreState();
        this.doRun();
    }

    public boolean isVisible() {
        return this.myIsVisible;
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (this.getPreferenceKey().equals(event.getProperty())) {
            System.err.println("property changed: " + event.getProperty());
            if (this.restoreState()) {
                System.err.println("update filter");
                this.doRun();
            }
        }
    }

    protected NavigatorFilter getNavigatorFilter() {
        return this.myFilter;
    }

    private boolean restoreState() {
        IPreferenceStore store = NavigatorPlugin.getDefault().getPreferenceStore();
        boolean newState = store.getBoolean(this.getPreferenceKey());
        boolean result = this.isChecked() != newState;
        this.setChecked(newState);
        return result;
    }

    private void saveState() {
        IPreferenceStore store = NavigatorPlugin.getDefault().getPreferenceStore();
        store.setValue(this.getPreferenceKey(), this.isChecked());
    }

    public void run() {
        System.out.println("Action " + this.myFilter.getDisplayName() + " invoked : checked: " + this.isChecked());
        this.saveState();
        this.doRun();
    }

    private void doRun() {
        if (this.isChecked()) {
            this.myNavigator.addFilter(this.myFilter);
        } else {
            this.myNavigator.removeFilter(this.myFilter);
        }
        this.myNavigator.refresh();
    }

    private void setDefaultValue(boolean defValue) {
        IPreferenceStore store = NavigatorPlugin.getDefault().getPreferenceStore();
        store.setDefault(this.getPreferenceKey(), defValue);
    }

    private String getPreferenceKey() {
        return "UserFilterAction.filter." + this.myFilter.getDisplayName();
    }
}

