/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.model.ui.navigator.filter;

import com.tssap.selena.internal.model.ui.navigator.ModelTreeViewer;
import com.tssap.selena.internal.model.ui.navigator.NavigatorPlugin;
import com.tssap.selena.internal.model.ui.navigator.filter.NavigatorFilter;
import com.tssap.selena.internal.model.ui.navigator.filter.PropertyBasedNavigatorFilter;
import com.tssap.selena.internal.model.ui.navigator.filter.UserFilterAction;
import com.tssap.selena.model.ui.navigator.INavigatorFilterDelegate;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;

public class NavigatorFilterManager {
    public static final String EXT_POINT_NAVIGATOR_FILTERS = "navigatorFilters";
    public static final String ATTR_CLASS = "class";
    public static final String ATTR_ENABLED_BY_DEFAULT = "enabled";
    public static final String ATTR_VISIBLE = "visible";
    private HashSet myFilterActions;
    private static HashSet ourFiltersSet;
    private ModelTreeViewer myNavigator;

    public NavigatorFilterManager(ModelTreeViewer navigator) {
        NavigatorFilterManager.loadFiltersSet();
        this.myNavigator = navigator;
        this.initActions();
    }

    private void initActions() {
        if (this.myFilterActions == null) {
            this.myFilterActions = new HashSet();
            Iterator filters = ourFiltersSet.iterator();
            while (filters.hasNext()) {
                FilterInfo curFilterInfo = (FilterInfo)filters.next();
                NavigatorFilter curFilter = curFilterInfo.getFilter();
                Boolean initialState = curFilterInfo.getInitialState();
                UserFilterAction curFilterAction = new UserFilterAction(this.getNavigator(), curFilter, initialState, curFilterInfo.isVisible());
                this.myFilterActions.add(curFilterAction);
            }
        }
    }

    public UserFilterAction[] getFilterActions() {
        HashSet result = new HashSet(this.myFilterActions);
        return result.toArray(new UserFilterAction[result.size()]);
    }

    public NavigatorFilter[] getActiveFilters() {
        HashSet<NavigatorFilter> result = new HashSet<NavigatorFilter>(this.myFilterActions.size());
        Iterator filterActions = this.myFilterActions.iterator();
        while (filterActions.hasNext()) {
            UserFilterAction curAction = (UserFilterAction)((Object)filterActions.next());
            if (!curAction.isChecked()) continue;
            result.add(curAction.getNavigatorFilter());
        }
        return ((AbstractCollection)result).toArray(new NavigatorFilter[result.size()]);
    }

    private ModelTreeViewer getNavigator() {
        return this.myNavigator;
    }

    public static Collection getFiltersSet() {
        NavigatorFilterManager.loadFiltersSet();
        return ourFiltersSet;
    }

    public static void loadFiltersSet() {
        if (ourFiltersSet == null) {
            ourFiltersSet = new HashSet();
            IExtensionPoint point = NavigatorPlugin.getDefault().getDescriptor().getExtensionPoint(EXT_POINT_NAVIGATOR_FILTERS);
            IExtension[] extensions = point.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] elements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < elements.length) {
                    block12: {
                        IConfigurationElement element = elements[j];
                        INavigatorFilterDelegate filterDelegate = null;
                        try {
                            if (element.getAttribute(ATTR_CLASS) == null) {
                                PropertyBasedNavigatorFilter propertyBasedFilter = new PropertyBasedNavigatorFilter();
                                propertyBasedFilter.setInitializationData(element, ATTR_CLASS, null);
                                filterDelegate = propertyBasedFilter;
                            } else {
                                filterDelegate = (INavigatorFilterDelegate)element.createExecutableExtension(ATTR_CLASS);
                                if (filterDelegate.getDisplayName() == null) {
                                    throw new NullPointerException("getDisplayName() == null");
                                }
                            }
                        }
                        catch (Exception e) {
                            System.err.println("Can not instantiate Navigator filter :" + element.getAttribute(ATTR_CLASS) + " \n exception occured: " + e);
                            break block12;
                        }
                        catch (NoClassDefFoundError e) {
                            System.err.println("Can not instantiate Navigator filter :" + element.getAttribute(ATTR_CLASS) + " \n exception occured: " + e);
                            break block12;
                        }
                        Boolean initialState = null;
                        if (element.getAttribute(ATTR_ENABLED_BY_DEFAULT) != null) {
                            initialState = element.getAttribute(ATTR_ENABLED_BY_DEFAULT).equalsIgnoreCase("true") ? Boolean.TRUE : Boolean.FALSE;
                        }
                        String visibleAttr = element.getAttributeAsIs(ATTR_VISIBLE);
                        boolean visible = true;
                        if (visibleAttr != null) {
                            visible = Boolean.valueOf(visibleAttr);
                        }
                        if (filterDelegate != null) {
                            ourFiltersSet.add(new FilterInfo(new NavigatorFilter(filterDelegate), initialState, visible));
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    public static class FilterInfo {
        private Boolean myInitialState;
        private NavigatorFilter myFilter;
        private boolean myIsVisible;

        public FilterInfo(NavigatorFilter filter, Boolean initialState, boolean visible) {
            this.myFilter = filter;
            this.myInitialState = initialState;
            this.myIsVisible = visible;
        }

        public NavigatorFilter getFilter() {
            return this.myFilter;
        }

        public Boolean getInitialState() {
            return this.myInitialState;
        }

        public boolean isVisible() {
            return this.myIsVisible;
        }
    }
}

