/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.model.ui.navigator.filter;

import com.tssap.selena.internal.model.ui.navigator.filter.Messages;
import com.tssap.selena.internal.model.ui.navigator.filter.NavigatorFilterManager;
import com.tssap.selena.internal.model.ui.navigator.filter.UserFilterAction;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.SelectionDialog;

public class CustomFiltersDialog
extends SelectionDialog {
    private UserFilterAction[] myFilterActions;
    private HashSet myInitiallyCheckedActions;
    private CheckboxTableViewer myCheckBoxList;

    public CustomFiltersDialog(Shell shell, NavigatorFilterManager filterManager) {
        super(shell);
        Assert.isNotNull((Object)filterManager);
        ArrayList<UserFilterAction> filterActionsList = new ArrayList<UserFilterAction>();
        UserFilterAction[] filterActions = filterManager.getFilterActions();
        if (filterActions != null) {
            int i = 0;
            while (i < filterActions.length) {
                if (filterActions[i].isVisible()) {
                    filterActionsList.add(filterActions[i]);
                }
                ++i;
            }
        }
        this.myFilterActions = filterActionsList.toArray(new UserFilterAction[0]);
        this.myInitiallyCheckedActions = CustomFiltersDialog.loadInitialSelection(this.myFilterActions);
    }

    protected void configureShell(Shell shell) {
        this.setTitle(Messages.getString("CustomFiltersDialog.UML_navigator_filters_1"));
        super.configureShell(shell);
    }

    protected Control createDialogArea(Composite parent) {
        Control result = super.createDialogArea(parent);
        this.createCheckBoxList((Composite)result);
        return result;
    }

    protected void cancelPressed() {
        if (this.myFilterActions != null) {
            int i = 0;
            while (i < this.myFilterActions.length) {
                UserFilterAction curFilter = this.myFilterActions[i];
                if (curFilter.isChecked() != this.myInitiallyCheckedActions.contains((Object)curFilter)) {
                    curFilter.setChecked(!curFilter.isChecked());
                    curFilter.run();
                }
                ++i;
            }
        }
        this.myInitiallyCheckedActions.clear();
        super.cancelPressed();
    }

    private void createCheckBoxList(Composite parent) {
        Label info = new Label(parent, 16384);
        info.setText(Messages.getString("CustomFiltersDialog.Select_the_filters__2"));
        this.myCheckBoxList = CheckboxTableViewer.newCheckList((Composite)parent, (int)2048);
        GridData data = new GridData(1808);
        data.heightHint = this.convertHeightInCharsToPixels(10);
        this.myCheckBoxList.getTable().setLayoutData((Object)data);
        this.myCheckBoxList.setLabelProvider((IBaseLabelProvider)this.createLabelProvider());
        this.myCheckBoxList.setContentProvider((IContentProvider)this.createContentProvider());
        this.myCheckBoxList.setInput((Object)this.myFilterActions);
        this.setInitialSelections((Object[])((AbstractCollection)this.myInitiallyCheckedActions).toArray(new UserFilterAction[this.myInitiallyCheckedActions.size()]));
        if (this.getInitialSelections() != null && !this.getInitialSelections().isEmpty()) {
            this.checkInitialSelections();
        }
        info = new Label(parent, 16384);
        info.setText(Messages.getString("CustomFiltersDialog.Filter_descriptrion__3"));
        final Text description = new Text(parent, 19018);
        data = new GridData(1808);
        data.heightHint = this.convertHeightInCharsToPixels(3);
        description.setLayoutData((Object)data);
        this.myCheckBoxList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object selectedElement;
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection && (selectedElement = ((IStructuredSelection)selection).getFirstElement()) instanceof UserFilterAction) {
                    description.setText(((UserFilterAction)((Object)selectedElement)).getText());
                }
            }
        });
        ICheckStateListener checkStateListener = new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                UserFilterAction changedAction = (UserFilterAction)((Object)event.getElement());
                changedAction.setChecked(event.getChecked());
                changedAction.run();
            }
        };
        this.myCheckBoxList.addCheckStateListener(checkStateListener);
    }

    private static HashSet loadInitialSelection(UserFilterAction[] allActions) {
        HashSet<UserFilterAction> result = new HashSet<UserFilterAction>();
        int i = 0;
        while (i < allActions.length) {
            UserFilterAction curFilterAction = allActions[i];
            if (curFilterAction.isChecked()) {
                result.add(curFilterAction);
            }
            ++i;
        }
        return result;
    }

    private void addSelectionButtons(Composite composite) {
        Composite buttonComposite = new Composite(composite, 131072);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        buttonComposite.setLayout((Layout)layout);
        GridData data = new GridData(640);
        data.grabExcessHorizontalSpace = true;
        composite.setData((Object)data);
        String label = Messages.getString("CustomFiltersDialog.Select_all_4");
        Button selectButton = this.createButton(buttonComposite, 18, label, false);
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CustomFiltersDialog.this.myCheckBoxList.setAllChecked(true);
            }
        };
        selectButton.addSelectionListener((SelectionListener)listener);
        label = Messages.getString("CustomFiltersDialog.Deselect_all_5");
        Button deselectButton = this.createButton(buttonComposite, 19, label, false);
        listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CustomFiltersDialog.this.myCheckBoxList.setAllChecked(false);
            }
        };
        deselectButton.addSelectionListener((SelectionListener)listener);
    }

    private void checkInitialSelections() {
        Iterator itemsToCheck = this.getInitialSelections().iterator();
        while (itemsToCheck.hasNext()) {
            this.myCheckBoxList.setChecked(itemsToCheck.next(), true);
        }
    }

    private ILabelProvider createLabelProvider() {
        return new LabelProvider(){

            public Image getImage(Object element) {
                return null;
            }

            public String getText(Object element) {
                if (element instanceof UserFilterAction) {
                    UserFilterAction filterAction = (UserFilterAction)((Object)element);
                    return filterAction.getText();
                }
                return null;
            }
        };
    }

    private IStructuredContentProvider createContentProvider() {
        return new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof Object[]) {
                    return (Object[])inputElement;
                }
                return new Object[0];
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        };
    }
}

