/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.model.ui.navigator.filter;

import com.tssap.selena.internal.model.ui.navigator.NavigatorPlugin;
import com.tssap.selena.internal.model.ui.navigator.filter.Messages;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.ui.navigator.INavigatorFilterDelegate;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;

public class ConfigurableByMetaclassFilter
implements INavigatorFilterDelegate {
    public static final String EXTENSION_POINT = "configurableFilter";
    public static final String ATTR = "metaclass";
    private static HashSet ourApprovedMetaclasses = null;

    public ConfigurableByMetaclassFilter() {
        ConfigurableByMetaclassFilter.initApprovedMetaclasses();
    }

    public boolean isChildExcluded(Object parentElement, Object element) {
        if (element instanceof Element) {
            String metaclass = ((Element)element).getPropertyValue("$metaclass");
            return metaclass == null || !ourApprovedMetaclasses.contains(metaclass);
        }
        return false;
    }

    public String getDisplayName() {
        return Messages.getString("ConfigurableByMetaclassFilter.display_name");
    }

    private static void initApprovedMetaclasses() {
        if (ourApprovedMetaclasses == null) {
            ourApprovedMetaclasses = new HashSet(100);
            ConfigurableByMetaclassFilter.readApprovedMetaclasses();
        }
    }

    private static void readApprovedMetaclasses() {
        IExtensionPoint exP = NavigatorPlugin.getDefault().getDescriptor().getExtensionPoint(EXTENSION_POINT);
        IConfigurationElement[] allElements = exP.getConfigurationElements();
        Iterator<IConfigurationElement> configs = Arrays.asList(allElements).iterator();
        while (configs.hasNext()) {
            IConfigurationElement next = configs.next();
            String metaclass = next.getAttribute(ATTR);
            if (metaclass == null || "".equals(metaclass)) continue;
            ourApprovedMetaclasses.add(metaclass);
        }
    }
}

