/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.model.ui.navigator.actions;

import com.tssap.selena.internal.model.ui.navigator.ModelTreeViewer;
import com.tssap.selena.internal.model.ui.navigator.NavigatorPlugin;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;

public abstract class PreferencesAwareNavigatorAction
extends Action
implements IPropertyChangeListener {
    private ModelTreeViewer myNavigator;
    private String myPreferencesKey;

    public PreferencesAwareNavigatorAction(ModelTreeViewer navigator, String preferencesKey) {
        this.myPreferencesKey = preferencesKey;
        this.myNavigator = navigator;
        this.myNavigator.getControl().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                PreferencesAwareNavigatorAction.getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)PreferencesAwareNavigatorAction.this);
            }
        });
        PreferencesAwareNavigatorAction.getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        this.init();
    }

    protected abstract void doRun();

    protected void init() {
        if (this.restoreState()) {
            this.doRun();
        }
    }

    public final void run() {
        this.setState(this.isChecked());
        this.doRun();
    }

    public final void propertyChange(PropertyChangeEvent event) {
        if (this.myPreferencesKey.equals(event.getProperty()) && this.restoreState()) {
            this.doRun();
        }
    }

    private void setState(boolean newState) {
        PreferencesAwareNavigatorAction.getPreferenceStore().setValue(this.myPreferencesKey, newState);
    }

    protected final boolean restoreState() {
        boolean newState = PreferencesAwareNavigatorAction.getPreferenceStore().getBoolean(this.myPreferencesKey);
        boolean result = this.isChecked() != newState;
        this.setChecked(newState);
        return result;
    }

    protected ModelTreeViewer getNavigator() {
        return this.myNavigator;
    }

    protected static IPreferenceStore getPreferenceStore() {
        return NavigatorPlugin.getDefault().getPreferenceStore();
    }

    protected static ImageDescriptor getImageDescriptor(String relativePath) {
        URL url = NavigatorPlugin.getDefault().getDescriptor().getInstallURL();
        try {
            url = new URL(url.toString() + relativePath);
            return ImageDescriptor.createFromURL((URL)url);
        }
        catch (MalformedURLException mue) {
            mue.printStackTrace();
            return null;
        }
    }
}

