/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.model.ui.navigator.actions;

import com.tssap.selena.internal.model.ui.navigator.NavigatorInplaceSupport;
import com.tssap.selena.internal.model.ui.navigator.NavigatorViewPart;
import com.tssap.selena.model.ui.DefaultElementWrapper;
import com.tssap.selena.model.ui.IElementWrapper;
import com.tssap.selena.model.ui.actions.AbstractSelectionAwareAction;
import com.tssap.selena.model.ui.actions.RenameActionHelper;
import com.tssap.selena.model.ui.actions.UnaryWrapperCondition;
import java.util.Iterator;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IWorkbenchPart;

public class InplaceRenameElementAction
extends AbstractSelectionAwareAction {
    private IWorkbenchPart myWorkbenchPart;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        super.setActivePart(action, targetPart);
        this.myWorkbenchPart = targetPart;
    }

    public void run(IAction action) {
        NavigatorViewPart viewPart = this.getNavigatorViewPart();
        if (viewPart == null) {
            return;
        }
        Iterator selectedWrappers = this.selectedWrappersIterator();
        if (!selectedWrappers.hasNext()) {
            return;
        }
        IElementWrapper wrapper = (IElementWrapper)selectedWrappers.next();
        NavigatorInplaceSupport inplaceSupport = this.getNavigatorViewPart().getNavigator().getInplaceSupport();
        if (inplaceSupport != null) {
            inplaceSupport.fireInplace(wrapper.getOriginalElement());
        }
    }

    protected boolean customIsChecked() {
        return false;
    }

    protected boolean customIsEnabled() {
        if (this.getNavigatorViewPart() == null) {
            return false;
        }
        if (this.getSelection() == null || this.getSelection().size() != 1) {
            return false;
        }
        return this.checkConditionForAllSelected(new UnaryWrapperCondition(){

            public boolean check(DefaultElementWrapper wrapper) {
                return wrapper != null && wrapper.getOriginalElement() != null && RenameActionHelper.getElementCondition().check(wrapper.getOriginalElement());
            }
        });
    }

    private NavigatorViewPart getNavigatorViewPart() {
        if (this.myWorkbenchPart instanceof NavigatorViewPart) {
            return (NavigatorViewPart)this.myWorkbenchPart;
        }
        return null;
    }
}

