/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.model.ui.navigator;

import com.tssap.selena.internal.model.ui.navigator.ModelContentProvider;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.ModelAccessEvent;
import com.tssap.selena.model.elements.ModelAccessListener;
import com.tssap.selena.model.elements.ModelChangeEvent;
import com.tssap.selena.model.elements.ModelChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;

public class UpdateManager
implements ModelChangeListener {
    private ModelContentProvider myUpdateListener;
    private HashMap myMonitoredModels = new HashMap();
    private Refresher myRefresher;

    public UpdateManager(ModelContentProvider contentProvider) {
        this.myUpdateListener = contentProvider;
        this.myRefresher = new Refresher();
    }

    public void modelChanged(ModelChangeEvent changeEvent) {
        this.myUpdateListener.modelChanged(changeEvent);
    }

    public void dispose() {
        this.myRefresher.dispose();
        Iterator it = this.myMonitoredModels.values().iterator();
        while (it.hasNext()) {
            ((Model)it.next()).removeModelDeltaListener((ModelChangeListener)this);
        }
    }

    private class Refresher
    implements ModelAccessListener {
        public Refresher() {
            ModelAccess.addModelAccessListener((ModelAccessListener)this);
            ArrayList<Model> originalModels = new ArrayList<Model>();
            Enumeration models = ModelAccess.models();
            while (models.hasMoreElements()) {
                Model nextModel = (Model)models.nextElement();
                originalModels.add(nextModel);
                nextModel.addModelDeltaListener((ModelChangeListener)UpdateManager.this);
                UpdateManager.this.myMonitoredModels.put(nextModel.getUniqueName(), nextModel);
            }
            UpdateManager.this.myUpdateListener.modelsSetChanged(originalModels, Collections.EMPTY_LIST);
        }

        public void modelCreated(ModelAccessEvent event) {
            Model addedModel = event.getModel();
            addedModel.addModelDeltaListener((ModelChangeListener)UpdateManager.this);
            UpdateManager.this.myMonitoredModels.put(addedModel.getUniqueName(), addedModel);
            UpdateManager.this.myUpdateListener.modelsSetChanged(Collections.singletonList(addedModel), Collections.EMPTY_LIST);
        }

        public void modelRemoved(ModelAccessEvent event) {
            Model removedModel = event.getModel();
            UpdateManager.this.myMonitoredModels.remove(removedModel.getUniqueName());
            UpdateManager.this.myUpdateListener.modelsSetChanged(Collections.EMPTY_LIST, Collections.singletonList(removedModel));
        }

        public void dispose() {
            ModelAccess.removeModelAccessListener((ModelAccessListener)this);
        }
    }
}

