/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.model.ui.navigator;

import com.tssap.selena.internal.model.ui.navigator.NavigatorPlugin;
import com.tssap.selena.internal.model.ui.navigator.Participant;
import com.tssap.selena.internal.model.ui.navigator.StructureAware;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.enum.ElementEnumeration;
import java.util.ArrayList;

class Role
implements StructureAware {
    private Entity myLink;
    private String myRole;
    private String myMetaclass;
    private static final String GENERIC_ROLE = "GenericRole";

    public Role(Entity link, String role) {
        this.myLink = link;
        this.myRole = role;
        int semicolonIndex = this.myRole.indexOf(":");
        if (semicolonIndex == -1) {
            this.myMetaclass = GENERIC_ROLE;
        } else {
            this.myMetaclass = this.myRole.substring(0, semicolonIndex);
            this.myRole = this.myRole.substring(semicolonIndex + 1);
        }
    }

    public Element getElement() {
        return this.getLink();
    }

    public String getRole() {
        return this.myRole;
    }

    public Entity getLink() {
        return this.myLink;
    }

    public Object[] getChildren() {
        ArrayList<Participant> children = new ArrayList<Participant>();
        ElementEnumeration participants = this.myLink.participants(this.myRole);
        while (participants.hasMoreElements()) {
            children.add(new Participant(this, participants.next()));
        }
        return children.toArray();
    }

    public boolean hasChildren() {
        return true;
    }

    public Object getParent() {
        return this.getLink();
    }

    public String getDisplayName() {
        return this.myRole;
    }

    public String getMetaclass() {
        return this.myMetaclass;
    }

    public boolean equals(Object another) {
        if (another instanceof Role) {
            Role that = (Role)another;
            return this.myLink == that.myLink && this.myRole.equals(that.myRole);
        }
        return false;
    }

    public int hashCode() {
        return this.myLink.hashCode() + 31 * this.myRole.hashCode();
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    static {
        NavigatorPlugin.getDefault().getIconRegistry().put(GENERIC_ROLE, "icons/role.gif", null);
    }
}

