/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.model.ui.navigator;

import com.tssap.selena.internal.model.ui.ModelUIPlugin;
import com.tssap.selena.internal.model.ui.navigator.ContentConverter;
import com.tssap.selena.internal.model.ui.navigator.DiagramDoubleClickOpener;
import com.tssap.selena.internal.model.ui.navigator.ModelTreeViewer;
import com.tssap.selena.internal.model.ui.navigator.NavigatorInplaceListener;
import com.tssap.selena.internal.model.ui.navigator.NavigatorPlugin;
import com.tssap.selena.internal.model.ui.navigator.SelectionConverter;
import com.tssap.selena.internal.model.ui.navigator.TreeViewerRoot;
import com.tssap.selena.internal.model.ui.navigator.actions.CollapseRoleAction;
import com.tssap.selena.internal.model.ui.navigator.actions.ExpandDiagramNodesAction;
import com.tssap.selena.internal.model.ui.navigator.filter.NavigatorFilterManager;
import com.tssap.selena.internal.model.ui.navigator.filter.ShowFiltersDialogAction;
import com.tssap.selena.license.CommonLicense;
import com.tssap.selena.license.UnaryOperation;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.ui.IElementWrapper;
import com.tssap.selena.model.ui.actions.ITextActionsViewPart;
import com.tssap.selena.model.ui.actions.RetargetActionGroup;
import com.tssap.selena.model.ui.actions.TextActionHandlerExt;
import com.tssap.selena.model.ui.actions.common.SharedRedoAction;
import com.tssap.selena.model.ui.actions.common.SharedUndoAction;
import com.tssap.selena.ui.internal.ChromePlugin;
import com.tssap.selena.ui.internal.ContextMenuContributor;
import com.tssap.selena.ui.internal.SortingMenuManager;
import com.tssap.selena.ui.internal.StandardMenuGroups;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.part.DrillDownAdapter;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.eclipse.ui.part.ViewPart;

public class NavigatorViewPart
extends ViewPart
implements IMenuListener,
ISetSelectionTarget,
ITextActionsViewPart {
    public static final String PART_ID = "com.tssap.selena.model.ui.navigator.view";
    public static final String HELP_ID = "com.togethersoft.togetherxj.nonuml.uml_navigator_help";
    private boolean featureAvailable = true;
    private NavigatorFilterManager myFilterManager;
    private RetargetActionGroup myRetargetActions;
    private ModelTreeViewer myNavigator;
    private Menu myContextMenu;
    private DrillDownAdapter myDrill;
    private CollapseRoleAction myCollapseRoleAction;
    private ExpandDiagramNodesAction myExpandDiagramNodesAction;
    private ShowFiltersDialogAction myShowFiltersDialogAction;
    static /* synthetic */ Class class$com$tssap$selena$model$elements$Element;

    public void selectReveal(ISelection selection) {
        if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
            Object firstElement = ((IStructuredSelection)selection).getFirstElement();
            if (firstElement instanceof Element) {
                this.getNavigator().selectAndReveal((Element)firstElement);
            } else if (firstElement instanceof IElementWrapper) {
                this.getNavigator().selectAndReveal((IElementWrapper)firstElement);
            }
        }
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        UnaryOperation function = new UnaryOperation(){

            public String execute(String value) {
                byte[] b = value.getBytes();
                int i = 0;
                while (i < value.length()) {
                    b[i] = (byte)(b[i] ^ i & 0xFF);
                    ++i;
                }
                return new String(b);
            }
        };
        if (!CommonLicense.isFeatureAvailable((String)"TSSAP", (String)"XJ", (UnaryOperation)function)) {
            this.featureAvailable = false;
        }
    }

    public void createPartControl(Composite parent) {
        if (!this.featureAvailable) {
            CommonLicense.createLimitedPane((Composite)parent, (String)"XJ");
            return;
        }
        SharedUndoAction.getSharedInstance().installAsGlobalActionHandler((IViewPart)this);
        SharedRedoAction.getSharedInstance().installAsGlobalActionHandler((IViewPart)this);
        WorkbenchHelp.setHelp((Control)parent, (String)HELP_ID);
        this.myNavigator = NavigatorPlugin.getDefault().getModelNavigator(parent);
        this.myFilterManager = new NavigatorFilterManager(this.getNavigator());
        this.myNavigator.setInput(this.getInitialInput());
        SelectionConverter converter = new SelectionConverter((ISelectionProvider)this.myNavigator);
        this.getSite().setSelectionProvider((ISelectionProvider)converter);
        this.myRetargetActions = new RetargetActionGroup((ITextActionsViewPart)this);
        this.myRetargetActions.fillActionBars(this.getViewSite().getActionBars());
        ModelUIPlugin.getDefault().getKeyboardNotifier().hookGlobalActions((IViewPart)this);
        SortingMenuManager menuManager = new SortingMenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener((IMenuListener)this);
        this.myContextMenu = menuManager.createContextMenu((Control)this.myNavigator.getTree());
        this.myNavigator.getTree().setMenu(this.myContextMenu);
        this.getSite().registerContextMenu(menuManager.getId(), (MenuManager)menuManager, (ISelectionProvider)converter);
        this.myDrill = new DrillDownAdapter(this.myNavigator){

            public boolean canExpand(IAdaptable element) {
                return super.canExpand((Object)element) && NavigatorViewPart.this.getNavigator().getFilteredChildren(element).length > 0;
            }
        };
        this.myDrill.addNavigationActions(this.getViewSite().getActionBars().getToolBarManager());
        this.myNavigator.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent evt) {
                ISelection selection = evt.getSelection();
                if (!(selection instanceof IStructuredSelection)) {
                    return;
                }
                IStructuredSelection ssel = (IStructuredSelection)selection;
                if (ssel.size() != 1) {
                    return;
                }
                Object selectedElement = ssel.getFirstElement();
                Element modelElement = ContentConverter.getCorrespondingElement(selectedElement);
                if (modelElement instanceof Entity) {
                    ModelUIPlugin.getDefault().openEditor(modelElement, NavigatorViewPart.this.getSite().getPage());
                }
            }
        });
        this.myNavigator.addDoubleClickListener(new DiagramDoubleClickOpener());
        this.myNavigator.getControl().addKeyListener((KeyListener)new KeyboardListener());
        this.myNavigator.getControl().addMouseListener((MouseListener)new NavigatorInplaceListener(this));
        IToolBarManager toolBar = this.getViewSite().getActionBars().getToolBarManager();
        this.fillMainToolBar(toolBar);
        this.getViewSite().getActionBars().getMenuManager().add((IAction)this.getShowFiltersDialogAction());
    }

    private void fillMainToolBar(IToolBarManager tbManager) {
        tbManager.add((IAction)this.getCollapseRoleAction());
        tbManager.add((IAction)this.getExpandDiagramNodesAction());
        tbManager.update(false);
    }

    public Object getInitialInput() {
        IAdaptable pageInput = this.getSite().getPage().getInput();
        Element elementAdapter = (Element)pageInput.getAdapter(class$com$tssap$selena$model$elements$Element == null ? (class$com$tssap$selena$model$elements$Element = NavigatorViewPart.class$("com.tssap.selena.model.elements.Element")) : class$com$tssap$selena$model$elements$Element);
        if (elementAdapter != null) {
            return elementAdapter;
        }
        return TreeViewerRoot.ROOT;
    }

    public void setFocus() {
        if (this.featureAvailable && !this.myNavigator.getControl().isDisposed()) {
            this.myNavigator.getControl().setFocus();
        }
    }

    public TextActionHandlerExt getTextActionHandler() {
        return this.myRetargetActions.getTextActionHandler();
    }

    public void dispose() {
        if (this.myContextMenu != null) {
            this.myContextMenu.dispose();
        }
        if (this.myRetargetActions != null) {
            this.myRetargetActions.dispose();
        }
        super.dispose();
    }

    public void menuAboutToShow(IMenuManager menu) {
        NavigatorViewPart.createStandardGroups(menu);
        ISelection selection = this.getSite().getSelectionProvider().getSelection();
        ContextMenuContributor[] contributors = ChromePlugin.getInstance().getContextMenuContributors();
        int ci = 0;
        while (ci < contributors.length) {
            contributors[ci].addMenu(menu, selection);
            ++ci;
        }
    }

    private static void createStandardGroups(IMenuManager menu) {
        StandardMenuGroups.addStandardGroups((IMenuManager)menu);
    }

    public ModelTreeViewer getNavigator() {
        return this.myNavigator;
    }

    public CollapseRoleAction getCollapseRoleAction() {
        if (this.myCollapseRoleAction == null) {
            this.myCollapseRoleAction = new CollapseRoleAction(this.myNavigator);
        }
        return this.myCollapseRoleAction;
    }

    public ExpandDiagramNodesAction getExpandDiagramNodesAction() {
        if (this.myExpandDiagramNodesAction == null) {
            this.myExpandDiagramNodesAction = new ExpandDiagramNodesAction(this.myNavigator);
        }
        return this.myExpandDiagramNodesAction;
    }

    public Action getShowFiltersDialogAction() {
        if (this.myShowFiltersDialogAction == null) {
            this.myShowFiltersDialogAction = new ShowFiltersDialogAction(this, this.myFilterManager);
        }
        return this.myShowFiltersDialogAction;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class KeyboardListener
    extends KeyAdapter {
        private KeyboardListener() {
        }

        public void keyReleased(KeyEvent e) {
            ModelUIPlugin.getDefault().getKeyboardNotifier().keyPressed(e, (IViewPart)NavigatorViewPart.this);
        }
    }
}

