/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.model.ui.navigator;

import com.tssap.selena.internal.model.ui.navigator.IconRegistry;
import com.tssap.selena.internal.model.ui.navigator.ModelContentProvider;
import com.tssap.selena.internal.model.ui.navigator.ModelEntrySorter;
import com.tssap.selena.internal.model.ui.navigator.ModelLabelProvider;
import com.tssap.selena.internal.model.ui.navigator.ModelTreeViewer;
import com.tssap.selena.internal.model.ui.navigator.filter.NavigatorFilterManager;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class NavigatorPlugin
extends AbstractUIPlugin {
    private static NavigatorPlugin plugin;
    private IconRegistry myIconRegistry;

    public NavigatorPlugin(IPluginDescriptor descriptor) {
        super(descriptor);
        plugin = this;
    }

    public void startup() throws CoreException {
        super.startup();
        NavigatorFilterManager.loadFiltersSet();
        this.getPreferenceStore().setDefault("ModelNavigator.option.diagram_nodes_expandability", true);
    }

    public boolean isFilterEnabled(String name) {
        return this.getPreferenceStore().getBoolean("UserFilterAction.filter." + name);
    }

    public static NavigatorPlugin getDefault() {
        return plugin;
    }

    public ModelTreeViewer getModelNavigator(Composite parent) {
        final ModelTreeViewer treeViewer = new ModelTreeViewer(parent);
        treeViewer.setContentProvider((IContentProvider)new ModelContentProvider());
        treeViewer.setLabelProvider((IBaseLabelProvider)new ModelLabelProvider());
        treeViewer.setSorter(new ModelEntrySorter());
        treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ISelection selection = event.getSelection();
                if (!(selection instanceof IStructuredSelection)) {
                    return;
                }
                IStructuredSelection ssel = (IStructuredSelection)selection;
                if (ssel.size() != 1) {
                    return;
                }
                Object selectedElement = ssel.getFirstElement();
                if (treeViewer.getExpandedState(selectedElement)) {
                    treeViewer.collapseToLevel(selectedElement, 1);
                } else {
                    treeViewer.expandToLevel(selectedElement, 1);
                }
            }
        });
        return treeViewer;
    }

    public IconRegistry getIconRegistry() {
        if (this.myIconRegistry == null) {
            this.myIconRegistry = new IconRegistry(NavigatorPlugin.getDefault().getDescriptor());
        }
        return this.myIconRegistry;
    }
}

