/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.model.ui.navigator;

import com.tssap.selena.internal.model.ui.navigator.ModelTreeViewer;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.ui.actions.RenameActionHelper;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.actions.TextActionHandler;

public class NavigatorInplaceSupport {
    private ModelTreeViewer myNavigator;
    private TreeEditor mySharedTreeEditor;
    private Text myTextControl;
    private Composite myTextControlParent;
    private TextActionHandler myTextActionHandler;
    private ISelectionChangedListener myAfterSelectionChangesCloser;
    private Element myCurrentInplacedEntity;

    public NavigatorInplaceSupport(ModelTreeViewer navigator) {
        this.myNavigator = navigator;
        this.mySharedTreeEditor = new TreeEditor(this.myNavigator.getTree());
        this.myAfterSelectionChangesCloser = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (((Object)((Object)NavigatorInplaceSupport.this.myNavigator)).equals(event.getSource()) && NavigatorInplaceSupport.this.myCurrentInplacedEntity != null) {
                    NavigatorInplaceSupport.this.saveChangesAndDispose();
                }
            }
        };
        this.myNavigator.addSelectionChangedListener(this.myAfterSelectionChangesCloser);
    }

    public void fireInplace(Element resource) {
        if (!RenameActionHelper.getElementCondition().check(resource)) {
            return;
        }
        this.myTextControlParent = this.createParent(resource);
        if (this.myTextControlParent == null) {
            return;
        }
        this.myCurrentInplacedEntity = resource;
        this.myTextControlParent.setVisible(false);
        this.myTextControlParent.addListener(9, new Listener(){

            public void handleEvent(Event e) {
                Point textSize = NavigatorInplaceSupport.this.myTextControl.getSize();
                Point parentSize = NavigatorInplaceSupport.this.myTextControlParent.getSize();
                e.gc.drawRectangle(0, 0, Math.min(textSize.x + 4, parentSize.x - 1), parentSize.y - 1);
            }
        });
        this.myTextControl = new Text(this.myTextControlParent, 0);
        this.myTextControlParent.setBackground(this.myTextControl.getBackground());
        this.myTextControl.addListener(24, new Listener(){

            public void handleEvent(Event e) {
                Point textSize = NavigatorInplaceSupport.this.myTextControl.computeSize(-1, -1);
                textSize.x += textSize.y;
                Point parentSize = NavigatorInplaceSupport.this.myTextControlParent.getSize();
                NavigatorInplaceSupport.this.myTextControl.setBounds(2, 1, Math.min(textSize.x, parentSize.x - 4), parentSize.y - 2);
                NavigatorInplaceSupport.this.myTextControlParent.redraw();
            }
        });
        this.myTextControl.addListener(31, new Listener(){

            public void handleEvent(Event event) {
                switch (event.detail) {
                    case 2: {
                        NavigatorInplaceSupport.this.disposeTextWidget();
                        event.doit = false;
                        break;
                    }
                    case 4: {
                        NavigatorInplaceSupport.this.saveChangesAndDispose();
                        event.doit = false;
                    }
                }
            }
        });
        this.myTextControl.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent fe) {
                NavigatorInplaceSupport.this.saveChangesAndDispose();
            }
        });
        if (this.myTextActionHandler != null) {
            this.myTextActionHandler.addText(this.myTextControl);
        }
        this.myTextControl.setText(resource.getPropertyValue("$name"));
        this.myTextControlParent.setVisible(true);
        Point textSize = this.myTextControl.computeSize(-1, -1);
        textSize.x += textSize.y;
        Point parentSize = this.myTextControlParent.getSize();
        this.myTextControl.setBounds(2, 1, Math.min(textSize.x, parentSize.x - 4), parentSize.y - 2);
        this.myTextControlParent.redraw();
        this.myTextControl.selectAll();
        this.myTextControl.setFocus();
    }

    private Tree getTree() {
        Tree result = this.myNavigator.getTree();
        if (result.isDisposed()) {
            return null;
        }
        return result;
    }

    private Composite createParent(Element resource) {
        this.myNavigator.selectAndReveal(resource);
        Tree tree = this.getTree();
        TreeItem[] itemForEditing = tree.getSelection();
        if (itemForEditing == null || itemForEditing.length == 0) {
            return null;
        }
        Composite result = new Composite((Composite)tree, 0);
        this.mySharedTreeEditor.horizontalAlignment = 16384;
        this.mySharedTreeEditor.grabHorizontal = true;
        this.mySharedTreeEditor.setEditor((Control)result, itemForEditing[0]);
        return result;
    }

    private void saveChangesAndDispose() {
        final String oldName = this.myCurrentInplacedEntity.getPropertyValue("$name");
        final String newName = this.myTextControl.getText();
        final Element lastInplacedEntity = this.myCurrentInplacedEntity;
        this.disposeTextWidget();
        Runnable renameCommand = new Runnable(){

            public void run() {
                if (oldName != null && oldName.equals(newName)) {
                    return;
                }
                RenameActionHelper.rename((Element)lastInplacedEntity, (String)newName);
            }
        };
        ModelAccess.runCommandLater((Runnable)renameCommand);
    }

    private void disposeTextWidget() {
        if (this.myTextActionHandler != null && this.myTextControl != null) {
            this.myTextActionHandler.removeText(this.myTextControl);
        }
        if (this.myTextControlParent != null) {
            this.mySharedTreeEditor.setEditor(null, null);
            Runnable disposeCommand = new Runnable(){

                public void run() {
                    NavigatorInplaceSupport.this.myTextControlParent.dispose();
                    NavigatorInplaceSupport.this.myTextControlParent = null;
                    NavigatorInplaceSupport.this.myTextControl = null;
                }
            };
            if ("motif".equals(SWT.getPlatform())) {
                Display.getCurrent().asyncExec(disposeCommand);
            } else {
                disposeCommand.run();
            }
        }
        if (this.myCurrentInplacedEntity != null) {
            this.myCurrentInplacedEntity = null;
        }
    }
}

