/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.model.ui.navigator;

import com.tssap.selena.internal.model.ui.navigator.ContentConverter;
import com.tssap.selena.internal.model.ui.navigator.ModelTreeViewer;
import com.tssap.selena.internal.model.ui.navigator.NavigatorViewPart;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.ui.IElementWrapper;
import com.tssap.selena.model.ui.actions.SelectionUtil;
import com.tssap.selena.model.util.various.CancelableCommand;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class NavigatorInplaceListener
implements MouseListener {
    private ModelTreeViewer myNavigator;
    private CancelableCommand myInplaceCommand;
    private NavigatorViewPart myNavigatorViewPart;
    private static final int CTRL_ALT_SHIFT = 458752;

    public NavigatorInplaceListener(NavigatorViewPart viewPart) {
        this.myNavigatorViewPart = viewPart;
        this.myNavigator = this.myNavigatorViewPart.getNavigator();
    }

    public void mouseDown(MouseEvent e) {
        if (e.getSource() instanceof Tree && e.button == 1 && (e.stateMask & 0x70000) == 0) {
            Point point = new Point(e.x, e.y);
            TreeItem clickedItem = ((Tree)e.getSource()).getItem(point);
            if (clickedItem == null || !clickedItem.getBounds().contains(point)) {
                return;
            }
            Element itemElement = ContentConverter.getCorrespondingElement(clickedItem.getData());
            if (this.isItemSelected(itemElement)) {
                this.fireInplaceLater(itemElement);
            }
        }
    }

    public void mouseDoubleClick(MouseEvent e) {
        if (this.myInplaceCommand != null) {
            this.myInplaceCommand.cancel();
        }
    }

    public void mouseUp(MouseEvent e) {
    }

    private boolean isItemSelected(Element element) {
        if (element == null) {
            return false;
        }
        ISelection selection = this.myNavigatorViewPart.getSite().getSelectionProvider().getSelection();
        List selectedWrappers = SelectionUtil.selection2DefaultWrapperList((ISelection)selection);
        Iterator it = selectedWrappers.iterator();
        while (it.hasNext()) {
            IElementWrapper next = (IElementWrapper)it.next();
            if (!element.equals(next.getOriginalElement())) continue;
            return true;
        }
        return false;
    }

    private void fireInplaceLater(Element inplaceTarget) {
        if (this.myInplaceCommand == null) {
            this.myInplaceCommand = this.createInplaceCommand(inplaceTarget);
            ModelAccess.runCommandLater((Runnable)this.myInplaceCommand);
        }
    }

    private CancelableCommand createInplaceCommand(final Element inplaceTarget) {
        Runnable callBack = new Runnable(){

            public void run() {
                NavigatorInplaceListener.this.myInplaceCommand = null;
            }
        };
        Runnable command = new Runnable(){

            public void run() {
                if (NavigatorInplaceListener.checkNavigator(NavigatorInplaceListener.this.myNavigator)) {
                    NavigatorInplaceListener.this.myNavigator.getInplaceSupport().fireInplace(inplaceTarget);
                }
            }
        };
        return new CancelableCommand(command, callBack);
    }

    private static boolean checkNavigator(ModelTreeViewer navigator) {
        return navigator != null && !navigator.getControl().isDisposed();
    }
}

