/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.model.ui.navigator;

import com.tssap.selena.internal.model.ui.navigator.ModelContentProvider;
import com.tssap.selena.internal.model.ui.navigator.NavigatorInplaceSupport;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.PropertyMap;
import com.tssap.selena.model.elements.Reference;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.ui.IElementWrapper;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class ModelTreeViewer
extends TreeViewer {
    private boolean myCollapseRoleNodes;
    private boolean myDiagramExpandability;
    private NavigatorInplaceSupport myInplaceSupport = new NavigatorInplaceSupport(this);

    public ModelTreeViewer(Composite parent) {
        super(parent);
    }

    public NavigatorInplaceSupport getInplaceSupport() {
        if (this.getTree().isDisposed()) {
            return null;
        }
        return this.myInplaceSupport;
    }

    public TreeItem findTreeItem(Object element) {
        Widget result = this.findItem(element);
        if (result instanceof TreeItem) {
            return (TreeItem)result;
        }
        return null;
    }

    public PropertyMap findCounterpart(PropertyMap viewerNode, UniqueName childUin) {
        Widget widget = this.findItem(viewerNode);
        if (widget == null || widget.isDisposed()) {
            return null;
        }
        Item[] subItems = this.getChildren(widget);
        if (subItems == null || subItems.length == 0) {
            return null;
        }
        int i = 0;
        while (i < subItems.length) {
            Element data;
            Item child = subItems[i];
            if (child.getData() instanceof Element && (data = (Element)child.getData()).getUniqueName().equals(childUin)) {
                return data;
            }
            ++i;
        }
        return ((Element)viewerNode).getModel().findElement(childUin);
    }

    public boolean isCollapsingRoleNodes() {
        return this.myCollapseRoleNodes;
    }

    public void setCollapsingRoleNodes(boolean toCollapse) {
        this.myCollapseRoleNodes = toCollapse;
        this.refresh();
    }

    public boolean isDiagramNodeExpandable() {
        return this.myDiagramExpandability;
    }

    public void setDiagramExpandability(boolean toExpand) {
        this.myDiagramExpandability = toExpand;
        if (this.getContentProvider() instanceof ModelContentProvider) {
            ((ModelContentProvider)this.getContentProvider()).diagramExpandabilityChanged();
        }
        this.refresh();
    }

    protected Object[] getFilteredChildren(Object parent) {
        return super.getFilteredChildren(parent);
    }

    protected void doUpdateItem(Item item, Object element) {
        ILabelProvider provider = (ILabelProvider)this.getLabelProvider();
        item.setText(provider.getText(element));
        Image image = provider.getImage(element);
        item.setImage(image);
    }

    public void selectAndReveal(IElementWrapper wrapper) {
        Entity toSelect = null;
        if (this.isDiagramNodeExpandable() && wrapper.getOriginalElement() instanceof Reference && this.revealEx(wrapper.getOriginalElement())) {
            toSelect = wrapper.getOriginalElement();
        }
        if (toSelect == null && this.revealEx(wrapper.getResolvedElement())) {
            toSelect = wrapper.getResolvedElement();
        }
        if (toSelect != null) {
            this.setSelection((ISelection)new StructuredSelection(toSelect), true);
        }
    }

    public void selectAndReveal(Element element) {
        this.reveal(element);
        this.setSelection((ISelection)new StructuredSelection((Object)element), true);
    }

    public boolean revealEx(Object element) {
        Widget w = this.internalExpand(element, true);
        if (w instanceof Item) {
            this.showItem((Item)w);
            return true;
        }
        return false;
    }
}

