/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.model.ui.navigator;

import com.tssap.selena.internal.model.ui.navigator.CollapsedRole;
import com.tssap.selena.internal.model.ui.navigator.ContentConverter;
import com.tssap.selena.internal.model.ui.navigator.ModelTreeViewer;
import com.tssap.selena.internal.model.ui.navigator.Role;
import com.tssap.selena.internal.model.ui.navigator.StructureAware;
import com.tssap.selena.internal.model.ui.navigator.TreeViewerRoot;
import com.tssap.selena.internal.model.ui.navigator.UpdateManager;
import com.tssap.selena.internal.model.ui.navigator.references.NavigatorView;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.ModelChangeEvent;
import com.tssap.selena.model.elements.ModelChangeListener;
import com.tssap.selena.model.elements.ModelDeltaNode;
import com.tssap.selena.model.elements.PropertyMap;
import com.tssap.selena.model.elements.Reference;
import com.tssap.selena.model.elements.ReferenceCollection;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.ElementEnumeration;
import com.tssap.selena.model.enum.EntityEnumeration;
import com.tssap.selena.model.enum.ReferenceCollectionEnumeration;
import com.tssap.selena.model.enum.ReferenceEnumeration;
import com.tssap.selena.model.enum.StringEnumeration;
import com.tssap.selena.model.util.Assert;
import com.tssap.selena.model.view.View;
import com.tssap.selena.model.view.ViewAccess;
import com.tssap.selena.model.view.ViewManager;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;

public class ModelContentProvider
implements ITreeContentProvider,
ModelChangeListener {
    private static final String INVOKE_INPLACE = "#invoke_inplace";
    private ModelTreeViewer myViewer;
    private UpdateManager myUpdateManager;
    private UniqueName myMonitoredModelUin;
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private HashMap myCreatedViews = new HashMap();
    private ManuallyAddedEntityInfo myLastManuallyAdded;

    public void diagramExpandabilityChanged() {
        if (this.myViewer.isDiagramNodeExpandable()) {
            Assert.isLegal((boolean)this.myCreatedViews.isEmpty());
        } else {
            this.disposeAllViews();
            Assert.isLegal((boolean)this.myCreatedViews.isEmpty());
        }
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof StructureAware) {
            return ((StructureAware)parentElement).getChildren();
        }
        ArrayList<Object> children = new ArrayList<Object>();
        if (parentElement instanceof Reference) {
            ReferenceEnumeration references = ((Reference)parentElement).references();
            while (references.hasMoreElements()) {
                children.add(references.next());
            }
            if (((Reference)parentElement).getEntity() instanceof ReferenceCollection) {
                ReferenceCollection rc = (ReferenceCollection)((Reference)parentElement).getEntity();
                ReferenceEnumeration references2 = rc.references();
                while (references2.hasMoreElements()) {
                    children.add(references2.next());
                }
            }
            this.addRoles(children, ((Reference)parentElement).getEntity());
        } else if (parentElement instanceof ReferenceCollection) {
            if (this.myViewer.isDiagramNodeExpandable()) {
                this.createView((ReferenceCollection)parentElement);
                ReferenceEnumeration references = ((ReferenceCollection)parentElement).references();
                while (references.hasMoreElements()) {
                    children.add(references.next());
                }
            }
        } else {
            Entity entity = (Entity)parentElement;
            EntityEnumeration childNodes = entity.childEntities();
            while (childNodes.hasMoreElements()) {
                children.add(childNodes.next());
            }
            ReferenceCollectionEnumeration childDiagrams = entity.childReferenceCollections();
            while (childDiagrams.hasMoreElements()) {
                ReferenceCollection diagram = childDiagrams.next();
                children.add(diagram);
            }
            this.addRoles(children, entity);
        }
        return children.toArray();
    }

    private void addRoles(List children, Entity entity) {
        if (entity == null) {
            return;
        }
        if (this.myViewer.isCollapsingRoleNodes()) {
            StringEnumeration roles = entity.participantRoles();
            while (roles.hasMoreElements()) {
                String role = roles.next();
                ElementEnumeration participants = entity.participants(role);
                while (participants.hasMoreElements()) {
                    children.add(new CollapsedRole(entity, role, participants.next()));
                }
            }
        } else {
            StringEnumeration roles = entity.participantRoles();
            while (roles.hasMoreElements()) {
                children.add(new Role(entity, roles.next()));
            }
        }
    }

    public Object getParent(Object element) {
        if (element instanceof StructureAware) {
            return ((StructureAware)element).getParent();
        }
        if (element instanceof Model && TreeViewerRoot.ROOT.equals(this.myViewer.getInput())) {
            return this.myViewer.getInput();
        }
        if (element instanceof Reference) {
            return ((Reference)element).getReferenceContainer();
        }
        return ((Entity)element).getParent();
    }

    public boolean hasChildren(Object parentElement) {
        if (parentElement == null) {
            return false;
        }
        if (parentElement instanceof StructureAware) {
            return ((StructureAware)parentElement).hasChildren();
        }
        if (parentElement instanceof Reference) {
            return true;
        }
        if (parentElement instanceof ReferenceCollection) {
            return this.myViewer.isDiagramNodeExpandable();
        }
        return true;
    }

    public void referencesChanged(Model changedModel, final ModelDeltaNode collectionDelta) {
        Assert.isLegal((boolean)this.myViewer.isDiagramNodeExpandable());
        if (collectionDelta == null || collectionDelta.isEmpty()) {
            return;
        }
        if (this.myViewer.getControl().isDisposed()) {
            return;
        }
        if (!this.isInterestedInDelta(changedModel.getUniqueName())) {
            return;
        }
        if (changedModel.isDeleted()) {
            return;
        }
        if (collectionDelta.isDeleted()) {
            return;
        }
        final ReferenceCollection collection = (ReferenceCollection)collectionDelta.getElement();
        if (collection == null || collection.isDeleted()) {
            return;
        }
        this.threadSafeRun(new Runnable(){

            public void run() {
                if (ModelContentProvider.this.myViewer.getControl().isDisposed()) {
                    return;
                }
                ModelContentProvider.this.processDelta((PropertyMap)collection, collectionDelta);
            }
        });
    }

    public void modelChanged(ModelChangeEvent changeEvent) {
        final Model model = changeEvent.getModel();
        if (this.myViewer.getControl().isDisposed()) {
            return;
        }
        if (!this.isInterestedInDelta(model.getUniqueName())) {
            return;
        }
        if (model.isDeleted()) {
            return;
        }
        final ModelDeltaNode rootDelta = changeEvent.getRootDelta();
        if (rootDelta == null || rootDelta.isDeleted() || rootDelta.isNew()) {
            return;
        }
        final ISelection selectionToRestore = ModelContentProvider.computeNewSelection(this.myViewer.getSelection(), rootDelta);
        this.threadSafeRun(new Runnable(){

            public void run() {
                block8: {
                    if (ModelContentProvider.this.myViewer.getControl().isDisposed()) {
                        ModelContentProvider.this.myLastManuallyAdded = null;
                        return;
                    }
                    ModelContentProvider.this.processDelta((PropertyMap)model, rootDelta);
                    if (ModelContentProvider.this.myLastManuallyAdded != null) {
                        block7: {
                            try {
                                Entity lastAddedEntity = ModelContentProvider.this.myLastManuallyAdded.getEntity();
                                ModelContentProvider.this.myViewer.expandToLevel(lastAddedEntity, 0);
                                ModelContentProvider.this.myViewer.selectAndReveal((Element)lastAddedEntity);
                                if (ModelContentProvider.this.myLastManuallyAdded.isInplaceNeeded()) {
                                    ModelContentProvider.this.myViewer.getInplaceSupport().fireInplace((Element)lastAddedEntity);
                                }
                                Object var3_2 = null;
                                if (!ModelContentProvider.this.myLastManuallyAdded.isInplaceNeeded()) break block7;
                            }
                            catch (Throwable throwable) {
                                Object var3_3 = null;
                                if (ModelContentProvider.this.myLastManuallyAdded.isInplaceNeeded()) {
                                    ModelContentProvider.this.myLastManuallyAdded.getEntity().setPropertyValue(ModelContentProvider.INVOKE_INPLACE, null);
                                }
                                ModelContentProvider.this.myLastManuallyAdded = null;
                                throw throwable;
                            }
                            ModelContentProvider.this.myLastManuallyAdded.getEntity().setPropertyValue(ModelContentProvider.INVOKE_INPLACE, null);
                        }
                        ModelContentProvider.this.myLastManuallyAdded = null;
                        {
                            break block8;
                        }
                    }
                    if (selectionToRestore != null) {
                        ModelContentProvider.this.myViewer.setSelection(selectionToRestore);
                    }
                }
            }
        });
    }

    private void processDelta(PropertyMap viewerNode, ModelDeltaNode deltaNode) {
        if (deltaNode.isChanged() || deltaNode.isTotallyChanged()) {
            this.myViewer.refresh(viewerNode);
            if (this.myLastManuallyAdded == null) {
                this.myLastManuallyAdded = ManuallyAddedEntityInfo.findManuallyAdded(deltaNode);
            }
            return;
        }
        ArrayList<PropertyMap> deleted = new ArrayList<PropertyMap>();
        HashMap<PropertyMap, ModelDeltaNode> changed = new HashMap<PropertyMap, ModelDeltaNode>();
        ArrayList<Object> added = new ArrayList<Object>();
        Enumeration enumeration = deltaNode.changedChildren();
        while (enumeration.hasMoreElements()) {
            ModelDeltaNode childNode = (ModelDeltaNode)enumeration.nextElement();
            PropertyMap counterpart = this.findCounterpart(viewerNode, childNode.getElementUniqueName());
            if (counterpart == null) {
                if (!childNode.isNew()) continue;
                added.add(childNode.getElement());
                continue;
            }
            if (childNode.isDeleted()) {
                deleted.add(counterpart);
                if (!this.myCreatedViews.containsKey(childNode.getElementUniqueName())) continue;
                this.disposeView((NavigatorView)this.myCreatedViews.get(childNode.getElementUniqueName()));
                this.myCreatedViews.remove(childNode.getElementUniqueName());
                continue;
            }
            if (childNode.isNew()) {
                added.add(counterpart);
                continue;
            }
            changed.put(counterpart, childNode);
        }
        this.myViewer.remove(deleted.toArray());
        if (this.myLastManuallyAdded == null) {
            this.myLastManuallyAdded = ManuallyAddedEntityInfo.findManuallyAdded(added);
        }
        this.myViewer.add(viewerNode, added.toArray());
        Iterator it = changed.keySet().iterator();
        while (it.hasNext()) {
            PropertyMap viewerChildNode = (PropertyMap)it.next();
            this.processDelta(viewerChildNode, (ModelDeltaNode)changed.get(viewerChildNode));
        }
    }

    private PropertyMap findCounterpart(PropertyMap viewerNode, UniqueName childUin) {
        return this.myViewer.findCounterpart(viewerNode, childUin);
    }

    public void modelsSetChanged(final List added, final List removed) {
        if (this.myViewer.getControl().isDisposed()) {
            return;
        }
        this.threadSafeRun(new Runnable(){

            public void run() {
                if (ModelContentProvider.this.myViewer.getControl().isDisposed()) {
                    return;
                }
                ModelContentProvider.this.processMetamodelDelta(added, removed);
            }
        });
    }

    private void processMetamodelDelta(List added, List removed) {
        if (TreeViewerRoot.ROOT.equals(this.myViewer.getInput())) {
            ArrayList removedModels = new ArrayList();
            Iterator it = removed.iterator();
            while (it.hasNext()) {
                Object next = it.next();
                removedModels.add(next);
            }
            this.myViewer.remove(removedModels.toArray());
            ArrayList addedModels = new ArrayList();
            Iterator it2 = added.iterator();
            while (it2.hasNext()) {
                Object next = it2.next();
                addedModels.add(next);
            }
            this.myViewer.add(this.myViewer.getInput(), addedModels.toArray());
        } else if (removed.contains(this.myMonitoredModelUin)) {
            this.myViewer.setInput(TreeViewerRoot.ROOT);
        }
    }

    public boolean isInterestedInDelta(UniqueName modelUin) {
        return TreeViewerRoot.ROOT.equals(this.myViewer.getInput()) || this.myMonitoredModelUin.equals(modelUin);
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void dispose() {
        this.myUpdateManager.dispose();
        this.disposeAllViews();
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (this.myViewer == null) {
            this.myViewer = (ModelTreeViewer)viewer;
        }
        if (newInput instanceof PropertyMap) {
            Element input = (Element)newInput;
            if (input != null) {
                Model newModel = input.getModel();
                this.myMonitoredModelUin = newModel.getUniqueName();
            } else {
                this.myMonitoredModelUin = null;
            }
        }
        if (oldInput == null && this.myUpdateManager == null) {
            this.myUpdateManager = new UpdateManager(this);
        }
    }

    private void threadSafeRun(Runnable command) {
        if (Thread.currentThread().equals(this.myViewer.getControl().getDisplay().getThread())) {
            command.run();
        } else {
            ModelAccess.runCommandLater((Runnable)command);
        }
    }

    private void createView(ReferenceCollection collection) {
        if (this.myCreatedViews.containsKey(collection.getUniqueName())) {
            return;
        }
        ViewManager viewManager = ViewAccess.getViewManager((UniqueName)collection.getModel().getUniqueName());
        View view = viewManager.createView(collection, "com.tssap.selena.model.navigator.rc");
        if (!(view instanceof NavigatorView)) {
            System.err.println("NavigatorView: creation fails for collection:" + collection);
            return;
        }
        ((NavigatorView)view).setContentProvider(this);
        this.myCreatedViews.put(collection.getUniqueName(), view);
    }

    private void disposeView(NavigatorView view) {
        Model model = view.getReferenceCollection().getModel();
        ViewManager viewManager = ViewAccess.getViewManager((UniqueName)model.getUniqueName());
        viewManager.disposeView((View)view);
        view.dispose();
    }

    private void disposeAllViews() {
        Iterator entries = this.myCreatedViews.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry curEntry = entries.next();
            NavigatorView curView = (NavigatorView)curEntry.getValue();
            this.disposeView(curView);
            entries.remove();
        }
    }

    private static ISelection computeNewSelection(ISelection curSelection, ModelDeltaNode delta) {
        if (curSelection == null || curSelection.isEmpty() || !(curSelection instanceof IStructuredSelection)) {
            return null;
        }
        HashMap<UniqueName, Element> uinToSelected = new HashMap<UniqueName, Element>(((IStructuredSelection)curSelection).size() * 3);
        HashSet additionalSelection = new HashSet(((IStructuredSelection)curSelection).size() * 3);
        Iterator it = ((IStructuredSelection)curSelection).iterator();
        while (it.hasNext()) {
            Object nextSelectedObject = it.next();
            Element nextSelectedElement = ContentConverter.getCorrespondingElement(nextSelectedObject);
            if (nextSelectedElement == null) continue;
            UniqueName originalUin = nextSelectedElement.getUniqueName();
            uinToSelected.put(originalUin, nextSelectedElement);
        }
        HashMap changedUins = ModelContentProvider.findChangedUins(delta);
        if (changedUins == null || changedUins.isEmpty()) {
            return null;
        }
        Iterator entries = changedUins.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry curEntry = entries.next();
            UniqueName curOriginalUin = (UniqueName)curEntry.getKey();
            if (uinToSelected.remove(curOriginalUin) == null) continue;
            additionalSelection.add(curEntry.getValue());
        }
        if (additionalSelection.isEmpty()) {
            return null;
        }
        additionalSelection.addAll(uinToSelected.values());
        return new StructuredSelection(((AbstractCollection)additionalSelection).toArray());
    }

    private static HashMap findChangedUins(ModelDeltaNode delta) {
        if (delta == null || delta.isEmpty()) {
            return null;
        }
        HashMap result = new HashMap(5);
        ModelContentProvider.collectChangedUins(delta, result);
        return result;
    }

    private static void collectChangedUins(ModelDeltaNode delta, HashMap collectedResults) {
        if (delta.isNew()) {
            Element changedElement;
            UniqueName originalUin = delta.getOriginalElementUniqueName();
            UniqueName curUin = delta.getElementUniqueName();
            if (originalUin != null && curUin != null && !originalUin.equals(curUin) && !collectedResults.containsKey(originalUin) && (changedElement = delta.getElement()) != null) {
                collectedResults.put(originalUin, changedElement);
            }
        }
        Enumeration subDeltas = delta.changedChildren();
        while (subDeltas.hasMoreElements()) {
            ModelDeltaNode next = (ModelDeltaNode)subDeltas.nextElement();
            ModelContentProvider.collectChangedUins(next, collectedResults);
        }
    }

    private static class ManuallyAddedEntityInfo {
        private Entity myEntity;
        private boolean myIsInplaceNeeded;

        public static ManuallyAddedEntityInfo findManuallyAdded(ArrayList allAdded) {
            int i = allAdded.size() - 1;
            while (i >= 0) {
                Element curAdded = (Element)allAdded.get(i);
                if (curAdded instanceof Entity && curAdded.hasProperty(ModelContentProvider.INVOKE_INPLACE)) {
                    return new ManuallyAddedEntityInfo((Entity)curAdded, curAdded.hasPropertyValue(ModelContentProvider.INVOKE_INPLACE, "com.tssap.selena.model.ui.navigator.view"));
                }
                --i;
            }
            return null;
        }

        public static ManuallyAddedEntityInfo findManuallyAdded(ModelDeltaNode deltaNode) {
            Element curAdded;
            if (deltaNode == null || deltaNode.isDeleted()) {
                return null;
            }
            if (deltaNode.isNew() && (curAdded = deltaNode.getElement()) instanceof Entity && curAdded.hasProperty(ModelContentProvider.INVOKE_INPLACE)) {
                return new ManuallyAddedEntityInfo((Entity)curAdded, curAdded.hasPropertyValue(ModelContentProvider.INVOKE_INPLACE, "com.tssap.selena.model.ui.navigator.view"));
            }
            ManuallyAddedEntityInfo result = null;
            Enumeration subDeltas = deltaNode.changedChildren();
            while (result == null && subDeltas.hasMoreElements()) {
                ModelDeltaNode next = (ModelDeltaNode)subDeltas.nextElement();
                result = ManuallyAddedEntityInfo.findManuallyAdded(next);
            }
            return result;
        }

        private ManuallyAddedEntityInfo(Entity entity, boolean inplaceNeeded) {
            this.myEntity = entity;
            this.myIsInplaceNeeded = inplaceNeeded;
        }

        public boolean isInplaceNeeded() {
            return this.myIsInplaceNeeded;
        }

        public Entity getEntity() {
            return this.myEntity;
        }
    }
}

