/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.model.ui.navigator;

import com.tssap.selena.internal.model.ui.navigator.CachingImageDescriptor;
import com.tssap.selena.internal.model.ui.navigator.NavigatorPlugin;
import com.tssap.selena.ui.internal.ChromePlugin;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;

public class IconRegistry {
    public static final String IMAGE_EXTENSION_POINT = "metaclasses";
    public static final String ICON_EXTENSION_NAME = "image";
    public static final String METACLASS_ATTRIBUTE = "metaclass";
    public static final String PROPERTY_NAME = "propertyName";
    public static final String PROPERTY_VALUE = "propertyValue";
    public static final String PLUGIN_ID_ATTRIBUTE = "plugin";
    public static final String FILE_ATTRIBUTE = "file";
    public static final String SORT_ORDER_ATTRIBUTE = "sortOrder";
    public static final String CUSTOM_LABEL_PROVIDER_ATTRIBUTE = "labelProviderClass";
    public static final String SHORTCUT_IMAGE = "icons/shortcut.gif";
    private HashMap myDescriptors = new HashMap();
    private HashMap myShortcutDescriptors = new HashMap();
    private HashMap mySortOrder = new HashMap();
    private HashMap myCustomLabelProviders = new HashMap();

    public IconRegistry(IPluginDescriptor descriptor) {
        IExtensionPoint extensionPoint = descriptor.getExtensionPoint(IMAGE_EXTENSION_POINT);
        if (extensionPoint == null) {
            return;
        }
        IConfigurationElement[] config = extensionPoint.getConfigurationElements();
        if (config == null) {
            return;
        }
        int i = 0;
        while (i < config.length) {
            String metaclass;
            if (ICON_EXTENSION_NAME.equals(config[i].getName()) && (metaclass = config[i].getAttribute(METACLASS_ATTRIBUTE)) != null) {
                String file;
                String sortOrderString = config[i].getAttribute(SORT_ORDER_ATTRIBUTE);
                if (sortOrderString != null) {
                    try {
                        this.mySortOrder.put(metaclass, Integer.decode(sortOrderString));
                    }
                    catch (NumberFormatException cannotParse) {
                        // empty catch block
                    }
                }
                if (config[i].getAttribute(CUSTOM_LABEL_PROVIDER_ATTRIBUTE) != null) {
                    ILabelProvider customProvider;
                    try {
                        Object provider = config[i].createExecutableExtension(CUSTOM_LABEL_PROVIDER_ATTRIBUTE);
                        customProvider = provider instanceof ILabelProvider ? (ILabelProvider)provider : null;
                    }
                    catch (CoreException e) {
                        customProvider = null;
                    }
                    catch (NoClassDefFoundError e) {
                        customProvider = null;
                    }
                    if (customProvider != null) {
                        this.myCustomLabelProviders.put(metaclass, customProvider);
                    }
                }
                if ((file = config[i].getAttribute(FILE_ATTRIBUTE)) != null) {
                    String pluginId = config[i].getAttribute(PLUGIN_ID_ATTRIBUTE);
                    URL pluginUrl = pluginId == null ? config[i].getDeclaringExtension().getDeclaringPluginDescriptor().getInstallURL() : Platform.getPlugin((String)pluginId).getDescriptor().getInstallURL();
                    this.put(metaclass, file, pluginUrl);
                }
            }
            ++i;
        }
    }

    public void put(String metaclass, String file, URL pluginUrl) {
        if (pluginUrl == null) {
            pluginUrl = NavigatorPlugin.getDefault().getDescriptor().getInstallURL();
        }
        try {
            URL iconUrl = new URL(pluginUrl, file);
            ImageDescriptor imageDescriptor = ImageDescriptor.createFromURL((URL)iconUrl);
            if (!this.myDescriptors.containsKey(metaclass)) {
                this.myDescriptors.put(metaclass, new CachingImageDescriptor(imageDescriptor));
                this.myShortcutDescriptors.put(metaclass, new CachingImageDescriptor((ImageDescriptor)new ShortcutImageDescriptor(imageDescriptor)));
                ChromePlugin.getInstance().getImageBundle().addImageDescriptor(metaclass, imageDescriptor);
            }
        }
        catch (MalformedURLException corruptEntry) {
            NavigatorPlugin.getDefault().getLog().log((IStatus)new Status(2, NavigatorPlugin.getDefault().getDescriptor().getUniqueIdentifier(), 0, "Could not register metaclass icon", (Throwable)corruptEntry));
        }
    }

    public Image getImage(String metaclass, boolean shortcut) {
        CachingImageDescriptor descriptor;
        HashMap descriptors = this.myDescriptors;
        if (shortcut) {
            descriptors = this.myShortcutDescriptors;
        }
        if ((descriptor = (CachingImageDescriptor)descriptors.get(metaclass)) == null) {
            return null;
        }
        return descriptor.getImage();
    }

    public Image getImage(String metaclass) {
        return this.getImage(metaclass, false);
    }

    public ILabelProvider getCustomLabelProvider(String metaclass) {
        return (ILabelProvider)this.myCustomLabelProviders.get(metaclass);
    }

    public int getCategory(String metaclass) {
        Integer sortOrder = (Integer)this.mySortOrder.get(metaclass);
        if (sortOrder == null) {
            return Integer.MAX_VALUE;
        }
        return sortOrder;
    }

    private static class ShortcutImageDescriptor
    extends CompositeImageDescriptor {
        private ImageDescriptor myBase;
        private static ImageData myShortcutData;

        public ShortcutImageDescriptor(ImageDescriptor base) {
            this.myBase = base;
        }

        protected void drawCompositeImage(int w, int h) {
            this.drawImage(this.myBase.getImageData(), 0, 0);
            this.drawImage(ShortcutImageDescriptor.getShortcutImageData(), 0, this.myBase.getImageData().height - ShortcutImageDescriptor.getShortcutImageData().height);
        }

        protected Point getSize() {
            return new Point(this.myBase.getImageData().width, this.myBase.getImageData().height);
        }

        protected static ImageData getShortcutImageData() {
            if (myShortcutData == null) {
                URL pluginURL = NavigatorPlugin.getDefault().getDescriptor().getInstallURL();
                URL url = null;
                try {
                    url = new URL(pluginURL, IconRegistry.SHORTCUT_IMAGE);
                    myShortcutData = ImageDescriptor.createFromURL((URL)url).getImageData();
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
            }
            return myShortcutData;
        }

        protected boolean isShortcut() {
            return true;
        }
    }
}

