/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.model.ui.navigator;

import com.tssap.selena.internal.model.ui.navigator.ContentConverter;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.ReferenceCollection;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.view.ViewAccess;
import com.tssap.selena.model.view.ViewManager;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.BusyIndicator;

public class DiagramDoubleClickOpener
implements IDoubleClickListener {
    private static final String GDE_VIEW_TYPE = "com.tssap.selena.model.diagram";

    public void doubleClick(DoubleClickEvent event) {
        ISelection selection = event.getSelection();
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection ssel = (IStructuredSelection)selection;
        if (ssel.size() != 1) {
            return;
        }
        Object selectedElement = ssel.getFirstElement();
        Element modelElement = ContentConverter.getCorrespondingElement(selectedElement);
        if (modelElement instanceof ReferenceCollection) {
            this.openDiagram((ReferenceCollection)modelElement);
        }
    }

    private void openDiagram(final ReferenceCollection diagram) {
        final ViewManager manager = ViewAccess.getViewManager((UniqueName)diagram.getModel().getUniqueName());
        if (manager != null && manager.canCreateView(diagram, GDE_VIEW_TYPE)) {
            BusyIndicator.showWhile(null, (Runnable)new Runnable(){

                public void run() {
                    manager.createView(diagram, DiagramDoubleClickOpener.GDE_VIEW_TYPE);
                }
            });
        }
    }
}

