/*
 * Decompiled with CFR 0.152.
 */
package com.sap.netweaver.ide.uts.model;

import com.sap.netweaver.ide.helpers.xml.ProtocolException;
import com.sap.netweaver.ide.helpers.xml.XMLElement;
import com.sap.netweaver.ide.helpers.xml.XMLHelper;
import com.sap.netweaver.ide.uts.model.ITSDataViewer;
import com.sap.netweaver.ide.uts.model.TSApplication;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TestSuite {
    private static final String ATTR_SELECTED = "selected";
    private static final String ATTR_NAME = "name";
    private static final String TAG_APPLICATION = "Application";
    private Document mm_document;
    private Map mm_applications = new HashMap();

    public TestSuite(Document document) {
        this.mm_document = document;
        this.load();
    }

    private void load() {
        NodeList nodes = XMLElement.getSubElements(this.mm_document.getDocumentElement(), TAG_APPLICATION);
        int i = 0;
        while (i < nodes.getLength()) {
            Node node = nodes.item(i);
            String applicationName = XMLElement.getAttribute((Element)node, ATTR_NAME);
            this.mm_applications.put(applicationName, node);
            ++i;
        }
    }

    public static TestSuite loadTestSuite(File source) {
        Document document = null;
        try {
            document = XMLHelper.parseXMLContent(source);
        }
        catch (ProtocolException e) {
            e.printStackTrace();
        }
        if (document != null) {
            return new TestSuite(document);
        }
        return null;
    }

    public static TestSuite loadTestSuite(Document document) {
        return new TestSuite(document);
    }

    public static void writeTo(TestSuite testSuite, OutputStream dest) {
        Document document = testSuite.mm_document;
        XMLHelper.outputXMLContent(document, dest, true);
    }

    /*
     * Loose catch block
     */
    public void saveAs(File dest) {
        block8: {
            FileOutputStream os = null;
            os = new FileOutputStream(dest);
            TestSuite.writeTo(this, os);
            Object var5_3 = null;
            try {
                ((OutputStream)os).close();
            }
            catch (IOException e2) {}
            break block8;
            {
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                    Object var5_4 = null;
                    try {
                        ((OutputStream)os).close();
                    }
                    catch (IOException e2) {}
                }
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                try {
                    ((OutputStream)os).close();
                }
                catch (IOException e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    public void writeTo(OutputStream dest) {
        TestSuite.writeTo(this, dest);
    }

    public void setSelection(List selectedApplications) {
        this.deselectAllApplications();
        int i = 0;
        while (i < selectedApplications.size()) {
            String applicationName = (String)selectedApplications.get(i);
            Node node = (Node)this.mm_applications.get(applicationName);
            if (node != null) {
                XMLElement.setAttribute((Element)node, ATTR_SELECTED, "true");
            }
            ++i;
        }
    }

    public void deselectAllApplications() {
        this.selectAllApplications(false);
    }

    public void selectAllApplications() {
        this.selectAllApplications(true);
    }

    private void selectAllApplications(boolean select) {
        Iterator iterator = this.mm_applications.values().iterator();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            if (node == null) continue;
            if (select) {
                XMLElement.setAttribute((Element)node, ATTR_SELECTED, "true");
                continue;
            }
            XMLElement.setAttribute((Element)node, ATTR_SELECTED, "false");
        }
    }

    public void dumpResultsTo(ITSDataViewer viewer) {
        NodeList nodes = XMLElement.getSubElements(this.mm_document.getDocumentElement(), TAG_APPLICATION);
        int i = 0;
        while (i < nodes.getLength()) {
            Node node = nodes.item(i);
            String applicationName = XMLElement.getAttribute((Element)node, ATTR_NAME);
            viewer.addLine(new TSApplication((Element)node));
            ++i;
        }
    }
}

