/*
 * Decompiled with CFR 0.152.
 */
package com.sap.netweaver.ide.uts.model;

import com.sap.netweaver.ide.helpers.xml.ProtocolException;
import com.sap.netweaver.ide.helpers.xml.XMLElement;
import com.sap.netweaver.ide.helpers.xml.XMLHelper;
import com.sap.netweaver.ide.uts.model.ITRData;
import com.sap.netweaver.ide.uts.model.ITRDataViewer;
import com.sap.netweaver.ide.uts.model.TRAssert;
import com.sap.netweaver.ide.uts.model.TRComponent;
import com.sap.netweaver.ide.uts.model.TRMethod;
import com.sap.netweaver.ide.uts.model.TRVerify;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TestResult {
    private Document mm_document;
    private Counters mm_counters = null;

    public TestResult(Document document) {
        this.mm_document = document;
    }

    public static TestResult loadTestResult(File source) {
        Document document = null;
        try {
            document = XMLHelper.parseXMLContent(source);
        }
        catch (ProtocolException e) {
            e.printStackTrace();
        }
        if (document != null) {
            return new TestResult(document);
        }
        return null;
    }

    public static TestResult loadTestResult(Document document) {
        return new TestResult(document);
    }

    public static void writeTo(TestResult testResult, OutputStream dest) {
        Document document = testResult.mm_document;
        XMLHelper.outputXMLContent(document, dest, true);
    }

    public void writeTo(OutputStream dest) {
        TestResult.writeTo(this, dest);
    }

    /*
     * Loose catch block
     */
    public void saveAs(File dest) {
        block8: {
            FileOutputStream os = null;
            os = new FileOutputStream(dest);
            TestResult.writeTo(this, os);
            Object var5_3 = null;
            try {
                ((OutputStream)os).close();
            }
            catch (IOException e2) {}
            break block8;
            {
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                    Object var5_4 = null;
                    try {
                        ((OutputStream)os).close();
                    }
                    catch (IOException e2) {}
                }
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                try {
                    ((OutputStream)os).close();
                }
                catch (IOException e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    public void dumpResultsTo(ITRDataViewer viewer) {
        NodeList suites = XMLElement.getSubElements(this.mm_document.getDocumentElement(), "TESTSUITE");
        int i = 0;
        while (i < suites.getLength()) {
            Node node = suites.item(i);
            this.dumpComponentResults(node, viewer);
            ++i;
        }
    }

    private boolean isFilteredOut(ITRData data) {
        return data.isSuccess();
    }

    public void dumpComponentResults(Node parentNode, ITRDataViewer viewer) {
        NodeList nodes = XMLElement.getSubElements(parentNode, "COMPONENT");
        int i = 0;
        while (i < nodes.getLength()) {
            Node node = nodes.item(i);
            TRComponent data = new TRComponent((Element)node);
            if (viewer.addLine(data)) {
                this.dumpMethodResults(node, viewer);
            }
            ++i;
        }
    }

    public void dumpMethodResults(Node parentNode, ITRDataViewer viewer) {
        NodeList nodes = XMLElement.getSubElements(parentNode, "METHOD");
        int i = 0;
        while (i < nodes.getLength()) {
            Node node = nodes.item(i);
            TRMethod data = new TRMethod((Element)node);
            if (viewer.addLine(data)) {
                this.dumpVerifyResults(node, viewer);
                this.dumpAssertResult(node, viewer);
            }
            ++i;
        }
    }

    public void dumpVerifyResults(Node parentNode, ITRDataViewer viewer) {
        NodeList methods = XMLElement.getSubElements(parentNode, "VERIFY");
        int i = 0;
        while (i < methods.getLength()) {
            Node node = methods.item(i);
            TRVerify data = new TRVerify((Element)node);
            viewer.addLine(data);
            ++i;
        }
    }

    public void dumpAssertResult(Node parentNode, ITRDataViewer viewer) {
        Element node = XMLElement.getSubElement(parentNode, "ASSERT");
        if (node != null) {
            TRAssert data = new TRAssert(node);
            viewer.addLine(data);
        }
    }

    public Counters getCounters() {
        this.loadInternal();
        return this.mm_counters;
    }

    private void loadInternal() {
        if (this.mm_counters != null) {
            return;
        }
        this.mm_counters = new Counters();
        NodeList suites = XMLElement.getSubElements(this.mm_document.getDocumentElement(), "TESTSUITE");
        int i = 0;
        while (i < suites.getLength()) {
            Node node = suites.item(i);
            this.loadComponentResults(node);
            ++i;
        }
    }

    public void loadComponentResults(Node parentNode) {
        NodeList nodes = XMLElement.getSubElements(parentNode, "COMPONENT");
        int i = 0;
        while (i < nodes.getLength()) {
            Node node = nodes.item(i);
            TRComponent data = new TRComponent((Element)node);
            ++this.mm_counters.mm_nbComponents;
            if (!data.isSuccess()) {
                ++this.mm_counters.mm_nbComponentWithErrors;
            }
            this.mm_counters.mm_nbTestCases += data.getNbMethods();
            this.mm_counters.mm_successes += data.getNbSuccesses();
            this.mm_counters.mm_failures += data.getNbFailures();
            this.mm_counters.mm_exceptions += data.getNbExceptions();
            ++i;
        }
    }

    public class Counters {
        int mm_nbComponents;
        int mm_nbComponentWithErrors;
        int mm_nbTestCases;
        int mm_successes;
        int mm_failures;
        int mm_exceptions;

        Counters() {
            this.reset();
        }

        void reset() {
            this.mm_nbComponents = 0;
            this.mm_nbComponentWithErrors = 0;
            this.mm_nbTestCases = 0;
            this.mm_successes = 0;
            this.mm_failures = 0;
            this.mm_exceptions = 0;
        }

        public int getNbComponents() {
            return this.mm_nbComponents;
        }

        public int getNbComponentWithErrors() {
            return this.mm_nbComponentWithErrors;
        }

        public int getNbTestCases() {
            return this.mm_nbTestCases;
        }

        public int getSuccesses() {
            return this.mm_successes;
        }

        public int getExceptions() {
            return this.mm_exceptions;
        }

        public int getFailures() {
            return this.mm_failures;
        }
    }
}

