/*
 * Decompiled with CFR 0.152.
 */
package com.sap.netweaver.ide.uts.model;

import com.sap.netweaver.ide.helpers.xml.XMLElement;
import com.sap.netweaver.ide.uts.model.ITRData;
import com.sap.netweaver.ide.uts.model.ITRMethodData;
import org.w3c.dom.Element;

public class TRMethod
implements ITRData,
ITRMethodData {
    Element mm_node;

    public TRMethod(Element node) {
        this.mm_node = node;
    }

    public String getType() {
        return this.mm_node.getNodeName();
    }

    public String getId() {
        Element node = XMLElement.getSubElement(this.mm_node, "MSGID");
        return XMLElement.getNodeValue(node);
    }

    public String getMessage() {
        String value = this.getException();
        if (value != null) {
            int pos = value.indexOf("\r");
            if (pos == -1) {
                pos = value.indexOf("\n");
            }
            if (pos != -1) {
                value = value.substring(0, pos);
            }
        }
        return value;
    }

    public String getException() {
        return XMLElement.getAttribute(this.mm_node, "exception");
    }

    public boolean isSuccess() {
        String status = XMLElement.getAttribute(this.mm_node, "success");
        return "true".equals(status);
    }

    public String getTestName() {
        return XMLElement.getAttribute(this.getComponentNode(), "testname");
    }

    public String getMethodName() {
        return XMLElement.getAttribute(this.mm_node, "name");
    }

    private Element getComponentNode() {
        return (Element)this.mm_node.getParentNode();
    }

    public String getShortMethodName() {
        String fullMethodName = this.getMethodName();
        int lastDot = fullMethodName.lastIndexOf(".");
        if (lastDot != -1) {
            return fullMethodName.substring(lastDot + 1);
        }
        return fullMethodName;
    }

    public String[] convDataToStringArray() {
        return new String[]{null, null, null, null, this.getShortMethodName(), this.getMessage(), this.getId()};
    }
}

