/*
 * Decompiled with CFR 0.152.
 */
package com.sap.netweaver.ide.uts.model;

import com.sap.netweaver.ide.helpers.xml.XMLElement;
import com.sap.netweaver.ide.uts.model.ITRData;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TRDataProvider
implements ITRData {
    Element mm_node;

    public TRDataProvider(Element node) {
        this.mm_node = node;
    }

    public String getType() {
        return this.mm_node.getNodeName();
    }

    public String getId() {
        return XMLElement.getAttribute(this.getComponentNode(), "testid");
    }

    public String getMsgId() {
        NodeList nodes = XMLElement.getSubElements(this.mm_node, "MSGID");
        if (nodes.getLength() > 0) {
            Node node = nodes.item(0);
            return node.getNodeValue().trim();
        }
        return null;
    }

    public String getMessage() {
        Node node;
        NodeList nodes = XMLElement.getSubElements(this.mm_node, "MSGLOG");
        if (nodes.getLength() > 0 && (node = nodes.item(0)).getNodeValue() != null) {
            return node.getNodeValue().trim();
        }
        return null;
    }

    public String getException() {
        return XMLElement.getAttribute(this.getComponentNode(), "exception");
    }

    public boolean isSuccess() {
        String status = XMLElement.getAttribute(this.mm_node, "success");
        return "true".equals(status);
    }

    public String getTestName() {
        return XMLElement.getAttribute(this.getComponentNode(), "testname");
    }

    public String getMethodName() {
        return XMLElement.getAttribute(this.getMethodNode(), "name");
    }

    private Element getMethodNode() {
        return (Element)this.mm_node.getParentNode();
    }

    private Element getComponentNode() {
        return (Element)this.mm_node.getParentNode().getParentNode();
    }

    public String getShortMethodName() {
        String fullMethodName = this.getMethodName();
        int lastDot = fullMethodName.lastIndexOf(".");
        if (lastDot != -1) {
            return fullMethodName.substring(lastDot + 1);
        }
        return fullMethodName;
    }

    public String[] convDataToStringArray() {
        return new String[]{null, null, null, null, this.getShortMethodName(), this.getMessage(), this.getId()};
    }
}

