/*
 * Decompiled with CFR 0.152.
 */
package com.sap.netweaver.ide.uts.model;

import com.sap.netweaver.ide.helpers.xml.XMLElement;
import com.sap.netweaver.ide.uts.model.ITRData;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TRComponent
implements ITRData {
    Element mm_node;
    int mm_nbMethods = 0;
    int mm_nbSuccesses = 0;
    int mm_nbFailures = 0;
    int mm_nbExceptions = 0;
    boolean mm_done = false;

    public TRComponent(Element node) {
        this.mm_node = node;
    }

    public String getType() {
        return this.mm_node.getNodeName();
    }

    public String getTestName() {
        return XMLElement.getAttribute(this.mm_node, "testname");
    }

    public String getTestId() {
        return XMLElement.getAttribute(this.mm_node, "testid");
    }

    public boolean isSuccess() {
        String status = XMLElement.getAttribute(this.mm_node, "success");
        return "true".equals(status);
    }

    public int getNbSuccesses() {
        this.countResults();
        return this.mm_nbSuccesses;
    }

    public String getNbSuccessesAsString() {
        this.countResults();
        return "" + this.mm_nbSuccesses;
    }

    public int getNbFailures() {
        this.countResults();
        return this.mm_nbFailures;
    }

    public String getNbFailuresAsString() {
        this.countResults();
        return "" + this.mm_nbFailures;
    }

    public int getNbExceptions() {
        this.countResults();
        return this.mm_nbExceptions;
    }

    public String getNbExceptionsAsString() {
        this.countResults();
        return "" + this.mm_nbExceptions;
    }

    public int getNbMethods() {
        this.countResults();
        return this.mm_nbMethods;
    }

    public String getNbMethodsAsString() {
        this.countResults();
        return "" + this.mm_nbMethods;
    }

    public String[] convDataToStringArray() {
        return new String[]{this.getTestId(), this.getNbSuccessesAsString(), this.getNbFailuresAsString(), this.getNbExceptionsAsString(), null, null, null};
    }

    public void countResults() {
        if (!this.mm_done) {
            try {
                NodeList methods = XMLElement.getSubElements(this.mm_node, "METHOD");
                int i = 0;
                while (i < methods.getLength()) {
                    Node method = methods.item(i);
                    ++this.mm_nbMethods;
                    String success = XMLElement.getAttribute((Element)method, "success");
                    if ("true".equals(success)) {
                        ++this.mm_nbSuccesses;
                    } else if (XMLElement.getAttribute((Element)method, "exception") != null) {
                        ++this.mm_nbExceptions;
                    } else {
                        ++this.mm_nbFailures;
                    }
                    ++i;
                }
                Object var6_5 = null;
                this.mm_done = true;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                this.mm_done = true;
                throw throwable;
            }
        }
    }
}

