/*
 * Decompiled with CFR 0.152.
 */
package com.sap.netweaver.ide.helpers.xml;

import com.sap.netweaver.ide.helpers.xml.FilteredNodeList;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLElement {
    Element mm_element;

    public XMLElement(Element element) {
        this.mm_element = element;
    }

    public Element getSubElement(String tagName) {
        return XMLElement.getSubElement(this.mm_element, tagName);
    }

    public static Element getSubElement(Node node, String tagName) {
        Element element = null;
        FilteredNodeList list = new FilteredNodeList(node.getChildNodes(), tagName);
        if (list.getLength() > 0) {
            element = (Element)list.item(0);
        }
        return element;
    }

    public NodeList getSubElements(String tagName) {
        return XMLElement.getSubElements(this.mm_element, tagName);
    }

    public static NodeList getSubElements(Node node, String tagName) {
        return new FilteredNodeList(node.getChildNodes(), tagName);
    }

    public String getAttribute(String attributeName) {
        return XMLElement.getAttribute(this.mm_element, attributeName);
    }

    public static String getAttribute(Element element, String attributeName) {
        Attr attr = element.getAttributeNode(attributeName);
        if (attr != null) {
            return attr.getNodeValue();
        }
        return null;
    }

    public void setAttribute(String attributeName, String attributeValue) {
        XMLElement.setAttribute(this.mm_element, attributeName, attributeValue);
    }

    public static void setAttribute(Element element, String attributeName, String attributeValue) {
        element.setAttribute(attributeName, attributeValue);
    }

    public static String getNodeValue(Node node) {
        if (node != null && node instanceof Element && (node = node.getFirstChild()) != null && node.getNodeType() == 3) {
            String value = node.getNodeValue().trim();
            while (value.endsWith("\r") || value.endsWith("\n") || value.endsWith("\t")) {
                value = value.substring(0, value.length());
            }
            return value;
        }
        return null;
    }

    public String getNodeValue() {
        return XMLElement.getNodeValue(this.mm_element);
    }

    public static boolean getBooleanAttribute(Element element, String attributeName) {
        Attr attr = element.getAttributeNode(attributeName);
        return attr != null && "true".equals(attr.getNodeValue());
    }

    public static void setBooleanAttribute(Element element, String attributeName, boolean value) {
        String attributeValue = value ? "true" : "false";
        XMLElement.setAttribute(element, attributeName, attributeValue);
    }
}

