/*
 * Decompiled with CFR 0.152.
 */
package com.sap.netweaver.ide.helpers.connection;

import com.sap.netweaver.ide.helpers.connection.ConnectionException;
import com.sap.netweaver.ide.helpers.connection.ConnectionParameters;
import com.sap.netweaver.ide.helpers.xml.ProtocolException;
import com.sap.netweaver.ide.helpers.xml.XMLHelper;
import com.sap.netweaver.ide.uts.model.TestSuite;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import org.w3c.dom.Document;

public class Connection {
    static URL getURL(ConnectionParameters params, String queryParameters) throws MalformedURLException {
        URL url = new URL(params.getProtocol(), params.getHost(), params.getPort(), params.getPortalContext() + params.getPortalSpecificParameters() + params.getQueryHandler() + "?" + queryParameters + params.getAuthParameters());
        return url;
    }

    public static Document connectAndGetApplications(ConnectionParameters connectionParameters) throws ConnectionException, ProtocolException {
        ArrayList listApplication = new ArrayList();
        String queryParameters = "query=applications&filter=testable";
        try {
            URL url = Connection.getURL(connectionParameters, queryParameters);
            URLConnection urlConnexion = url.openConnection();
            urlConnexion.setRequestProperty("Accept", "text/xml");
            Document document = Connection.getDocument(urlConnexion);
            return document;
        }
        catch (ConnectionException e) {
            throw e.setConnectionParameters(connectionParameters);
        }
        catch (ProtocolException e) {
            throw e;
        }
        catch (Exception e) {
            if (e instanceof ConnectionException) {
                throw ((ConnectionException)e).setConnectionParameters(connectionParameters);
            }
            throw new ConnectionException("Connection.connectAndExecuteTestSuite failed - " + connectionParameters.toString(), e).setConnectionParameters(connectionParameters);
        }
    }

    public static Document connectAndExecuteTestSuite(ConnectionParameters connectionParameters, TestSuite testSuite) throws ConnectionException, ProtocolException {
        String CONTENT_BOUNDARY = "-----------------------------7d22371e1f0356";
        String queryParameters = "query=test_applications";
        URLConnection urlConnection = null;
        OutputStream os = null;
        try {
            URL url = Connection.getURL(connectionParameters, queryParameters);
            urlConnection = url.openConnection();
            urlConnection.setAllowUserInteraction(true);
            urlConnection.setDoOutput(true);
            urlConnection.setRequestProperty("Content-Type", "multipart/form-data; boundary=-----------------------------7d22371e1f0356");
            urlConnection.setRequestProperty("User-Agent", "Mozilla/4.7 [en] (WinNT; U)");
            urlConnection.setRequestProperty("Accept-Language", "en-us");
            urlConnection.setRequestProperty("Accept", "text/xml");
            urlConnection.setUseCaches(false);
            os = urlConnection.getOutputStream();
            os.write("-------------------------------7d22371e1f0356\r\nContent-Disposition: form-data; name=\"applicationlist\"; filename=\"applicationlist.xml\" \r\nContent-Type: text/xml \r\n\r\n".getBytes());
            testSuite.writeTo(os);
            os.write("\r\n\r\n-------------------------------7d22371e1f0356--\r\n".getBytes());
            os.close();
            Document document = Connection.getDocument(urlConnection);
            return document;
        }
        catch (ConnectionException e) {
            throw e.setConnectionParameters(connectionParameters);
        }
        catch (ProtocolException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConnectionException("Connection.connectAndExecuteTestSuite failed - " + connectionParameters.toString(), e).setConnectionParameters(connectionParameters);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static byte[] getURLContent(URLConnection urlConnection) throws ConnectionException {
        int responseCode;
        IOException ioe = null;
        try {
            urlConnection.connect();
        }
        catch (IOException e) {
            ioe = e;
        }
        try {
            responseCode = ((HttpURLConnection)urlConnection).getResponseCode();
        }
        catch (IOException e) {
            responseCode = 503;
        }
        if (ioe != null) throw new ConnectionException("[Connection.getURLContent] connection failed - response code: " + responseCode + " url: " + urlConnection.getURL().toExternalForm(), ioe).setResponseCode(responseCode);
        if (responseCode != 200) {
            throw new ConnectionException("[Connection.getURLContent] connection failed - response code: " + responseCode + " url: " + urlConnection.getURL().toExternalForm(), ioe).setResponseCode(responseCode);
        }
        InputStream is = null;
        ByteArrayOutputStream buffer = null;
        try {
            try {
                is = urlConnection.getInputStream();
                buffer = new ByteArrayOutputStream();
                byte[] bytes = new byte[16384];
                int readCount = 0;
                while (true) {
                    if ((readCount = is.read(bytes)) <= 0) {
                        buffer.close();
                        break;
                    }
                    buffer.write(bytes, 0, readCount);
                }
            }
            catch (IOException e) {
                throw new ConnectionException("[Connection.getURLContent] connection failed - response code: " + responseCode + " url: " + urlConnection.getURL().toExternalForm(), e);
            }
            Object var8_10 = null;
            if (is == null) return buffer.toByteArray();
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            if (is == null) throw throwable;
            try {
                is.close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException e) {}
        is.close();
        return buffer.toByteArray();
    }

    private static Document getDocument(URLConnection urlConnection) throws ConnectionException, ProtocolException {
        byte[] bytes = Connection.getURLContent(urlConnection);
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(bytes);
            Document document = XMLHelper.parseXMLContent(is);
            return document;
        }
        catch (ProtocolException e) {
            System.err.println(new String(bytes));
            throw e;
        }
    }
}

