/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.util;

import com.sap.ide.metamodel.Metamodel;
import com.sap.ide.metamodel.core.i18n.TextPoolProxy;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.ide.metamodel.general.MetamodelIterator;
import com.sap.ide.metamodel.general.exception.DeleteException;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class RawLanguageConverter {
    private static final Location sLocation = Location.getLocation((String)"com.sap.ide.metamodel.util.RawLanguageConverter");
    private static final Category sCategoryTexts = Category.getCategory((String)"/MetamodelCore/TranslatableTexts");

    public static synchronized MainDevelopmentObject[] getAffectedMDOs(Metamodel metamodel) {
        ArrayList<DevelopmentObject> lResult = new ArrayList<DevelopmentObject>();
        MetamodelIterator it = metamodel.iterator();
        while (it.hasNext()) {
            TextPoolProxy lTextPool;
            List<String> lLanguages;
            DevelopmentObject lObject = it.next();
            if (!lObject.isMDO() || lObject.originatesInArchive() || (lLanguages = Arrays.asList((lTextPool = (TextPoolProxy)((MainDevelopmentObject)lObject).getTextPool()).getAvailableLanguages())).isEmpty() || lLanguages.contains("")) continue;
            lResult.add(lObject);
        }
        return lResult.toArray(new MainDevelopmentObject[0]);
    }

    public static synchronized void convert(Metamodel metamodel) {
        RawLanguageConverter.convert(RawLanguageConverter.getAffectedMDOs(metamodel));
    }

    public static synchronized void convert(MainDevelopmentObject[] mdos) {
        String method = "convert()";
        int i = 0;
        while (i < mdos.length) {
            TextPoolProxy lTextPool = (TextPoolProxy)mdos[i].getTextPool();
            List<String> lLanguages = Arrays.asList(lTextPool.getAvailableLanguages());
            if (!lLanguages.isEmpty() && !lLanguages.contains("")) {
                lTextPool.createLanguageState("");
                String lMasterLanguage = lTextPool.getMasterLanguage();
                if (lLanguages.contains(lMasterLanguage) && !lTextPool.isReadOnly(lMasterLanguage)) {
                    try {
                        lTextPool.deleteLanguage(lMasterLanguage);
                    }
                    catch (DeleteException ex) {
                        sCategoryTexts.errorT(sLocation, "convert()", "could not delete obsolete master language file " + lTextPool.getAbsolutePath(lMasterLanguage) + " during raw language activation: " + ex.getMessage());
                    }
                } else {
                    sCategoryTexts.errorT(sLocation, "convert()", "could not delete obsolete master language file " + lTextPool.getAbsolutePath(lMasterLanguage) + " during raw language activation.");
                }
            }
            ++i;
        }
    }

    public static synchronized boolean isRawLanguageMissing(MainDevelopmentObject mdo) {
        List<String> lLanguages = Arrays.asList(mdo.getTextPool().getAvailableLanguages());
        return !lLanguages.isEmpty() && !lLanguages.contains("");
    }
}

