/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.general.exception;

import com.sap.ide.metamodel.general.exception.MetamodelException;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;

public class ReflectionException
extends MetamodelException {
    private static final Location sLocation = Location.getLocation((String)"com.sap.ide.metamodel.general.exception.ReflectionException");
    private static final Category sCategoryReflection = Category.getCategory((String)"/MetamodelCore/Reflection");
    private Exception mException = null;

    public ReflectionException(String exceptionText) {
        super(exceptionText);
        sCategoryReflection.errorT(sLocation, "reflection error in method \"" + this.getCallingMethod() + "\": " + exceptionText);
    }

    public ReflectionException(Exception exception) {
        if (exception != null) {
            super.setMessage(exception.getMessage());
            this.mException = exception;
        }
        sCategoryReflection.errorT(sLocation, "reflection error in method \"" + this.getCallingMethod() + "\": " + exception.getMessage());
    }

    public ReflectionException(String message, Exception exception) {
        super(message);
        this.mException = exception;
        sCategoryReflection.errorT(sLocation, "reflection error in method \"" + this.getCallingMethod() + "\": " + message);
    }

    public Throwable getCause() {
        return this.mException;
    }

    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    public void printStackTrace(PrintStream ps) {
        PrintStream printStream = ps;
        synchronized (printStream) {
            super.printStackTrace(ps);
            if (this.mException != null) {
                ps.print("nested: ");
                this.mException.printStackTrace(ps);
            }
        }
    }

    public void printStackTrace(PrintWriter pw) {
        PrintWriter printWriter = pw;
        synchronized (printWriter) {
            super.printStackTrace(pw);
            if (this.mException != null) {
                pw.print("nested: ");
                this.mException.printStackTrace(pw);
            }
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ReflectionException: ");
        String message = this.getMessage();
        if (message != null) {
            sb.append(message);
        }
        return sb.toString();
    }

    private String getCallingMethod() {
        StringWriter lWriter = new StringWriter();
        this.printStackTrace(new PrintWriter(lWriter));
        BufferedReader lReader = new BufferedReader(new StringReader(lWriter.getBuffer().toString()));
        String lLine = null;
        try {
            lReader.readLine();
            lLine = lReader.readLine();
            lReader.close();
            lWriter.close();
        }
        catch (IOException ex) {
            return "<unknown>";
        }
        int lPos1 = lLine.indexOf("com.sap.ide.metamodel.core.") + 27;
        int lPos2 = lLine.indexOf(40);
        return lLine.substring(lPos1, lPos2) + "()";
    }
}

