/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.core.service;

import com.sap.ide.metamodel.general.MDOEnum;
import com.sap.ide.metamodel.general.MDOLocation;
import com.sap.ide.metamodel.general.MDOLocator;
import com.sap.ide.metamodel.general.RootMDOEnum;
import com.sap.ide.metamodel.general.SourcePathIdentifier;
import com.sap.ide.metamodel.general.exception.MetamodelException;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Vector;

public class SingleRootPathMDOLocator
implements MDOLocator {
    private static final Location sLocation = Location.getLocation((String)"com.sap.ide.metamodel.core.service.SingleRootPathMDOLocator");
    private static final Category sCategoryInitialization = Category.getCategory((String)"/MetamodelCore/Initialization");
    private String mSourcePath;
    private FilenameFilter mFilter = null;

    private SingleRootPathMDOLocator() {
    }

    public SingleRootPathMDOLocator(String rootPath) throws MetamodelException {
        String method = "constructor()";
        if (rootPath == null || !new File(rootPath).isDirectory()) {
            sCategoryInitialization.fatalT(sLocation, "constructor()", "source path \"" + rootPath + "\" is not a valid directory");
            throw new MetamodelException("Source path \"" + rootPath + "\" is not a valid directory");
        }
        this.mSourcePath = new File(rootPath).getAbsolutePath();
        sCategoryInitialization.infoT(sLocation, "constructor()", "source path: " + this.mSourcePath);
    }

    public String getMDOPath(String mdoPackage, String mdoName, MDOEnum mdoType) {
        String lPath = this.mSourcePath;
        if (mdoPackage != null && mdoPackage.length() > 0) {
            lPath = lPath + File.separator + mdoPackage.replace('.', File.separatorChar);
        }
        if (new File(lPath = lPath + File.separator + mdoName + "." + mdoType.getFileExtension()).exists()) {
            return lPath;
        }
        return null;
    }

    public String[] getRootMDOPaths(String mdoPackage, RootMDOEnum rootMDOType) {
        final String lExtension = "." + rootMDOType.getFileExtension();
        String lPath = this.mSourcePath + File.separator + mdoPackage.replace('.', File.separatorChar);
        File[] lFiles = new File(lPath).listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(lExtension);
            }
        });
        Vector<String> lVector = new Vector<String>();
        if (lFiles != null) {
            int i = 0;
            while (i < lFiles.length) {
                String lName = lFiles[i].getAbsolutePath();
                lVector.add(lName);
                ++i;
            }
        }
        return lVector.toArray(new String[0]);
    }

    public MDOLocation[] getRootMDOLocations(RootMDOEnum rootMDOType) {
        final String lExtension = "." + rootMDOType.getFileExtension();
        this.mFilter = new FilenameFilter(){

            public boolean accept(File dir, String name) {
                if (new File(dir, name).isDirectory()) {
                    return true;
                }
                if (name != null) {
                    return name.endsWith(lExtension);
                }
                return false;
            }
        };
        Vector lVector = new Vector();
        this.doRecursion(this.mSourcePath, lVector);
        return lVector.toArray(new MDOLocation[0]);
    }

    public String getSourcePath() {
        return this.mSourcePath;
    }

    public String getSourcePath(SourcePathIdentifier identifier) {
        return this.mSourcePath;
    }

    private void doRecursion(String name, Vector result) {
        File f = new File(name);
        if (f.isFile()) {
            String lParentFolder = f.getParent();
            String lPackage = "";
            if (!lParentFolder.equals(this.mSourcePath)) {
                lPackage = lParentFolder.substring(this.mSourcePath.length() + 1).replace(File.separatorChar, '.');
            }
            result.add(new MDOLocation(f.getAbsolutePath(), lPackage));
        } else if (f.isDirectory()) {
            String[] lObjects = f.list(this.mFilter);
            int i = 0;
            while (i < lObjects.length) {
                this.doRecursion(name + File.separator + lObjects[i], result);
                ++i;
            }
        }
    }
}

