/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.core.service;

import com.sap.ide.metamodel.core.CoreMainDevelopmentObject;
import com.sap.ide.metamodel.core.DataState;
import com.sap.ide.metamodel.core.DevelopmentObjectProxy;
import com.sap.ide.metamodel.core.ForeignReference;
import com.sap.ide.metamodel.core.Reference;
import com.sap.ide.metamodel.core.i18n.LanguageObjectImpl;
import com.sap.ide.metamodel.core.i18n.TextPoolProxy;
import com.sap.ide.metamodel.core.refactoring.MDORefactoringHistoryEntryImpl;
import com.sap.ide.metamodel.core.refactoring.RefactoredLanguageObjectImpl;
import com.sap.ide.metamodel.core.refactoring.RefactoredMDOImpl;
import com.sap.ide.metamodel.core.refactoring.RefactoringHistoryEntryImpl;
import com.sap.ide.metamodel.core.service.CommitResultImpl;
import com.sap.ide.metamodel.core.service.FileSystemService;
import com.sap.ide.metamodel.core.service.MDOAccessProblemImpl;
import com.sap.ide.metamodel.core.service.MetamodelNotificationService;
import com.sap.ide.metamodel.core.service.RollbackResultImpl;
import com.sap.ide.metamodel.general.CommitResult;
import com.sap.ide.metamodel.general.DevelopmentObjectKey;
import com.sap.ide.metamodel.general.MDOAccessProblem;
import com.sap.ide.metamodel.general.MDOEnum;
import com.sap.ide.metamodel.general.MetamodelDocument;
import com.sap.ide.metamodel.general.MetamodelIterator;
import com.sap.ide.metamodel.general.RollbackResult;
import com.sap.ide.metamodel.general.Root;
import com.sap.ide.metamodel.general.exception.DeleteException;
import com.sap.ide.metamodel.general.exception.LoadException;
import com.sap.ide.metamodel.general.exception.SaveException;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.io.File;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;

public class ObjectCacheManager {
    private static final Location sLocation = Location.getLocation((String)"com.sap.ide.metamodel.core.service.ObjectCacheManager");
    private static final Category sCategoryCaching = Category.getCategory((String)"/MetamodelCore/Caching");
    private static final Category sCategoryIntegrity = Category.getCategory((String)"/MetamodelCore/Integrity");
    private static FileSystemService sFileSystemService = FileSystemService.getInstance();
    private MetamodelNotificationService mMetamodelNotificationService;
    private boolean mKeyCachingEnabled = false;
    private boolean mFileDeletionEnabled = true;
    private HashMap mAllMDOInstances = new HashMap();
    private HashMap mAllTextPools = new HashMap();
    private HashMap mAllKeyedNonMDOs = new HashMap();
    private HashMap mReplacedMDOs = new HashMap();
    private HashMap mReplacedTextPools = new HashMap();
    private HashMap mReplacedDocuments = new HashMap();
    private HashMap mReplacedDocumentTextPools = new HashMap();
    private HashSet mRefactoredProxies = new HashSet();
    private ArrayList mRefactoredMDOs = new ArrayList();
    private ArrayList mRefactoredDocuments = new ArrayList();
    private HashMap mMDOsReplacedByRefactoring = new HashMap();
    private HashMap mTextPoolsReplacedByRefactoring = new HashMap();
    private HashMap mDocumentsReplacedByRefactoring = new HashMap();
    private HashMap mDocumentTextPoolsReplacedByRefactoring = new HashMap();
    private HashSet mMDOWriteSet = new HashSet();
    private HashSet mTextPoolWriteSet = new HashSet();

    public ObjectCacheManager(MetamodelNotificationService metamodelNotificationService) {
        this.mMetamodelNotificationService = metamodelNotificationService;
    }

    public DevelopmentObjectProxy getMDOInstance(String modelName, String packageName, String mdoName, MDOEnum mdoType) {
        return (DevelopmentObjectProxy)this.mAllMDOInstances.get(new ForeignReference(modelName, packageName, mdoName, mdoType).toString().toLowerCase());
    }

    public DevelopmentObjectProxy getMDOInstance(String modelName, Reference reference) {
        return this.getMDOInstance(modelName, reference.getMDOPackage(), reference.getMDOName(), reference.getMDOType());
    }

    public DevelopmentObjectProxy getMDOInstance(ForeignReference reference) {
        return this.getMDOInstance(reference.getModelName(), reference.getMDOPackage(), reference.getMDOName(), reference.getMDOType());
    }

    public void registerMDOInstance(CoreMainDevelopmentObject mdo) {
        String method = "registerMDOInstance()";
        String lKey = ((ForeignReference)((DevelopmentObjectProxy)((Object)mdo)).getKey()).toLowerString();
        if (!this.mAllMDOInstances.containsKey(lKey)) {
            sCategoryCaching.infoT(sLocation, "registerMDOInstance()", "caching MDO: " + lKey);
        }
        this.mAllMDOInstances.put(lKey, mdo);
    }

    public void registerKeyedNonMDO(ForeignReference key, DevelopmentObjectProxy object) {
        String method = "registerKeyedNonMDO()";
        String lKey = key.toLowerString();
        if (!this.mAllKeyedNonMDOs.containsKey(lKey)) {
            sCategoryCaching.infoT(sLocation, "registerKeyedNonMDO()", "caching development object: " + lKey);
            this.mAllKeyedNonMDOs.put(lKey, object);
        }
    }

    public void unregisterKeyedNonMDO(ForeignReference key) {
        String method = "unregisterKeyedNonMDO()";
        String lKey = key.toLowerString();
        if (this.mAllKeyedNonMDOs.containsKey(lKey)) {
            sCategoryCaching.infoT(sLocation, "unregisterKeyedNonMDO()", "removing from cache: " + lKey);
            this.mAllKeyedNonMDOs.remove(lKey);
        }
    }

    public DevelopmentObjectProxy getKeyedNonMDO(ForeignReference key) {
        return (DevelopmentObjectProxy)this.mAllKeyedNonMDOs.get(key.toLowerString());
    }

    public void setKeyCachingEnabled(boolean value) {
        String method = "setKeyCachingEnabled()";
        this.mKeyCachingEnabled = value;
        sCategoryCaching.infoT(sLocation, "setKeyCachingEnabled()", (value ? "enabled" : "disabled") + " key caching");
    }

    public boolean getKeyCachingEnabled() {
        return this.mKeyCachingEnabled;
    }

    public void clearKeyCache() {
        this.mAllKeyedNonMDOs.clear();
    }

    public void registerTextPool(TextPoolProxy textPool) {
        String method = "registerTextPool()";
        String lKey = ((ForeignReference)((DevelopmentObjectProxy)((Object)textPool.getOwner())).getKey()).toLowerString();
        if (!this.mAllTextPools.containsKey(lKey)) {
            sCategoryCaching.infoT(sLocation, "registerTextPool()", "caching text pool for MDO: " + lKey);
        }
        this.mAllTextPools.put(lKey, textPool);
    }

    private MDOAccessProblem[] checkForCommit() {
        String lPath;
        String method = "checkForCommit()";
        ArrayList<MDOAccessProblemImpl> lMDOAccessProblems = new ArrayList<MDOAccessProblemImpl>();
        Iterator it = this.mReplacedMDOs.values().iterator();
        while (it.hasNext()) {
            CoreMainDevelopmentObject lMDO = (CoreMainDevelopmentObject)it.next();
            String lPath2 = lMDO.getAbsolutePath();
            if (!sFileSystemService.fileExists(lPath2) || !sFileSystemService.isReadOnly(lPath2)) continue;
            lMDOAccessProblems.add(new MDOAccessProblemImpl(lMDO, lPath2, 3));
            sCategoryIntegrity.infoT(sLocation, "checkForCommit()", "cannot delete: \"" + lPath2 + "\"");
        }
        Iterator it2 = this.mReplacedTextPools.values().iterator();
        while (it2.hasNext()) {
            TextPoolProxy lTextPool = (TextPoolProxy)it2.next();
            Vector lVector = lTextPool.getDeletedLanguages();
            int i = 0;
            while (i < lVector.size()) {
                String lLanguage = (String)lVector.get(i);
                lPath = lTextPool.getAbsolutePath(lLanguage);
                if (sFileSystemService.fileExists(lPath) && sFileSystemService.isReadOnly(lPath)) {
                    CoreMainDevelopmentObject lMDO = (CoreMainDevelopmentObject)((Object)lTextPool.getOwner());
                    lMDOAccessProblems.add(new MDOAccessProblemImpl(lMDO, lLanguage, lPath, 7));
                    sCategoryIntegrity.infoT(sLocation, "checkForCommit()", "cannot delete language: \"" + lPath + "\"");
                }
                ++i;
            }
        }
        Iterator it3 = ((AbstractList)this.mRefactoredMDOs).iterator();
        while (it3.hasNext()) {
            CoreMainDevelopmentObject lMDO;
            String lKey;
            TextPoolProxy lTextPool;
            MDORefactoringHistoryEntryImpl lHistoryEntry = (MDORefactoringHistoryEntryImpl)it3.next();
            if (!lHistoryEntry.isOriginal()) continue;
            String lPath3 = lHistoryEntry.getAbsolutePath();
            if (sFileSystemService.fileExists(lPath3) && sFileSystemService.isReadOnly(lPath3)) {
                lMDOAccessProblems.add(new MDOAccessProblemImpl((CoreMainDevelopmentObject)((Object)lHistoryEntry.getObject()), lPath3, 3));
                sCategoryIntegrity.infoT(sLocation, "checkForCommit()", "cannot delete: \"" + lPath3 + "\"");
            }
            if ((lTextPool = (TextPoolProxy)this.mAllTextPools.get(lKey = ((ForeignReference)((DevelopmentObjectProxy)((Object)(lMDO = (CoreMainDevelopmentObject)((Object)lHistoryEntry.getObject())))).getKey()).toLowerString())) == null || lHistoryEntry.getAbsolutePath().equals(lMDO.getAbsolutePath())) continue;
            String[] lLanguages = lTextPool.getAvailableLanguages();
            int i = 0;
            while (i < lLanguages.length) {
                lPath3 = TextPoolProxy.getAbsolutePath(lLanguages[i], lHistoryEntry.getAbsolutePath());
                if (sFileSystemService.fileExists(lPath3) && sFileSystemService.isReadOnly(lPath3)) {
                    lMDOAccessProblems.add(new MDOAccessProblemImpl(lMDO, lLanguages[i], lPath3, 7));
                    sCategoryIntegrity.infoT(sLocation, "checkForCommit()", "cannot delete language: \"" + lPath3 + "\"");
                }
                ++i;
            }
        }
        Iterator it4 = this.mMDOWriteSet.iterator();
        while (it4.hasNext()) {
            CoreMainDevelopmentObject lMDO = (CoreMainDevelopmentObject)it4.next();
            DataState lDataState = ((DevelopmentObjectProxy)((Object)lMDO))._getDataState();
            lPath = lMDO.getAbsolutePath();
            if (lDataState == DataState.MODIFIED || lDataState == DataState.NEW) {
                if (!sFileSystemService.fileExists(lPath) || !sFileSystemService.isReadOnly(lPath)) continue;
                lMDOAccessProblems.add(new MDOAccessProblemImpl(lMDO, lPath, 2));
                sCategoryIntegrity.infoT(sLocation, "checkForCommit()", "cannot save: \"" + lPath + "\"");
                continue;
            }
            if (lDataState != DataState.DELETED || !sFileSystemService.fileExists(lPath) || !sFileSystemService.isReadOnly(lPath)) continue;
            lMDOAccessProblems.add(new MDOAccessProblemImpl(lMDO, lPath, 3));
            sCategoryIntegrity.infoT(sLocation, "checkForCommit()", "cannot delete: \"" + lPath + "\"");
        }
        Iterator it5 = this.mTextPoolWriteSet.iterator();
        while (it5.hasNext()) {
            CoreMainDevelopmentObject lMDO;
            String lLanguage;
            TextPoolProxy lTextPool = (TextPoolProxy)it5.next();
            Vector lVector = lTextPool.getDeletedLanguages();
            int i = 0;
            while (i < lVector.size()) {
                lLanguage = (String)lVector.get(i);
                String lPath4 = lTextPool.getAbsolutePath(lLanguage);
                if (sFileSystemService.fileExists(lPath4) && sFileSystemService.isReadOnly(lPath4)) {
                    lMDO = (CoreMainDevelopmentObject)((Object)lTextPool.getOwner());
                    lMDOAccessProblems.add(new MDOAccessProblemImpl(lMDO, lLanguage, lPath4, 7));
                    sCategoryIntegrity.infoT(sLocation, "checkForCommit()", "cannot delete language: \"" + lPath4 + "\"");
                }
                ++i;
            }
            lVector = (Vector)lTextPool.getNewLanguages().clone();
            lVector.addAll(lTextPool.getModifiedLanguages());
            i = 0;
            while (i < lVector.size()) {
                lLanguage = (String)lVector.get(i);
                String lPath5 = lTextPool.getAbsolutePath(lLanguage);
                if (sFileSystemService.fileExists(lPath5) && sFileSystemService.isReadOnly(lPath5)) {
                    lMDO = (CoreMainDevelopmentObject)((Object)lTextPool.getOwner());
                    lMDOAccessProblems.add(new MDOAccessProblemImpl(lMDO, lLanguage, lPath5, 6));
                    sCategoryIntegrity.infoT(sLocation, "checkForCommit()", "cannot save language: \"" + lPath5 + "\"");
                }
                ++i;
            }
        }
        return lMDOAccessProblems.toArray(new MDOAccessProblem[0]);
    }

    public CommitResult commitChanges() throws SaveException, DeleteException {
        String method = "commitChanges()";
        ArrayList<CoreMainDevelopmentObject> lCreatedMDOs = new ArrayList<CoreMainDevelopmentObject>();
        ArrayList<CoreMainDevelopmentObject> lDeletedMDOs = new ArrayList<CoreMainDevelopmentObject>();
        ArrayList<CoreMainDevelopmentObject> lModifiedMDOs = new ArrayList<CoreMainDevelopmentObject>();
        ArrayList<CoreMainDevelopmentObject> lCancelledMDOs = new ArrayList<CoreMainDevelopmentObject>();
        ArrayList<RefactoredMDOImpl> lRefactoredMDOs = new ArrayList<RefactoredMDOImpl>();
        ArrayList<LanguageObjectImpl> lCreatedLanguages = new ArrayList<LanguageObjectImpl>();
        ArrayList<LanguageObjectImpl> lDeletedLanguages = new ArrayList<LanguageObjectImpl>();
        ArrayList<LanguageObjectImpl> lModifiedLanguages = new ArrayList<LanguageObjectImpl>();
        ArrayList<RefactoredLanguageObjectImpl> lRefactoredLanguages = new ArrayList<RefactoredLanguageObjectImpl>();
        MDOAccessProblem[] lMDOAccessProblems = this.checkForCommit();
        if (lMDOAccessProblems.length == 0) {
            TextPoolProxy lTextPool;
            Iterator it = this.mReplacedMDOs.values().iterator();
            while (it.hasNext()) {
                CoreMainDevelopmentObject lMDO = (CoreMainDevelopmentObject)it.next();
                if (this.mFileDeletionEnabled && !this.isMDORefactored(lMDO._getKey())) {
                    sFileSystemService.delete(lMDO.getAbsolutePath());
                }
                sCategoryCaching.infoT(sLocation, "commitChanges()", "removing deleted MDO from cache: " + ((DevelopmentObjectProxy)((Object)lMDO)).getKey());
                lDeletedMDOs.add(lMDO);
            }
            Iterator it2 = this.mReplacedTextPools.values().iterator();
            while (it2.hasNext()) {
                TextPoolProxy lTextPool2 = (TextPoolProxy)it2.next();
                Vector lVector = lTextPool2.getDeletedLanguages();
                int i = 0;
                while (i < lVector.size()) {
                    String lLanguage = (String)lVector.get(i);
                    sCategoryCaching.infoT(sLocation, "commitChanges()", "deleting deleted language \"" + lLanguage + "\" for MDO: " + lTextPool2.getOwner().getKey());
                    if (this.mFileDeletionEnabled && !this.isMDORefactored(lTextPool2.getOwner().getKey())) {
                        sFileSystemService.delete(lTextPool2.getAbsolutePath(lLanguage));
                    }
                    lDeletedLanguages.add(new LanguageObjectImpl(lLanguage, lTextPool2.getOwner(), lTextPool2.getAbsolutePath(lLanguage)));
                    ++i;
                }
            }
            Iterator it3 = this.mMDOsReplacedByRefactoring.values().iterator();
            while (it3.hasNext()) {
                CoreMainDevelopmentObject lMDO = (CoreMainDevelopmentObject)it3.next();
                if (this.mFileDeletionEnabled && !this.isMDORefactored(lMDO._getKey())) {
                    sFileSystemService.delete(lMDO.getAbsolutePath());
                }
                sCategoryCaching.infoT(sLocation, "commitChanges()", "removing deleted MDO from cache: " + ((DevelopmentObjectProxy)((Object)lMDO)).getKey());
                lDeletedMDOs.add(lMDO);
            }
            Iterator it4 = this.mTextPoolsReplacedByRefactoring.values().iterator();
            while (it4.hasNext()) {
                TextPoolProxy lTextPool3 = (TextPoolProxy)it4.next();
                Vector lVector = lTextPool3.getDeletedLanguages();
                int i = 0;
                while (i < lVector.size()) {
                    String lLanguage = (String)lVector.get(i);
                    sCategoryCaching.infoT(sLocation, "commitChanges()", "deleting deleted language \"" + lLanguage + "\" for MDO: " + lTextPool3.getOwner().getKey());
                    if (this.mFileDeletionEnabled && !this.isMDORefactored(lTextPool3.getOwner().getKey())) {
                        sFileSystemService.delete(lTextPool3.getAbsolutePath(lLanguage));
                    }
                    lDeletedLanguages.add(new LanguageObjectImpl(lLanguage, lTextPool3.getOwner(), lTextPool3.getAbsolutePath(lLanguage)));
                    ++i;
                }
            }
            Iterator it5 = ((AbstractList)this.mRefactoredMDOs).iterator();
            while (it5.hasNext()) {
                MDORefactoringHistoryEntryImpl lHistoryEntry = (MDORefactoringHistoryEntryImpl)it5.next();
                if (!lHistoryEntry.isOriginal()) continue;
                CoreMainDevelopmentObject lMDO = (CoreMainDevelopmentObject)((Object)lHistoryEntry.getObject());
                sCategoryCaching.infoT(sLocation, "commitChanges()", "deleting refactored MDO: " + ((DevelopmentObjectProxy)((Object)lMDO)).getKey());
                if (this.mFileDeletionEnabled) {
                    sFileSystemService.delete(lHistoryEntry.getAbsolutePath());
                }
                lRefactoredMDOs.add(new RefactoredMDOImpl(lMDO, lHistoryEntry.getName(), lHistoryEntry.getPackage(), lHistoryEntry.getAbsolutePath(), (DevelopmentObjectProxy)lHistoryEntry.getParent(), lHistoryEntry.getKey()));
                String lKey = ((ForeignReference)((DevelopmentObjectProxy)((Object)lMDO)).getKey()).toLowerString();
                lTextPool = (TextPoolProxy)this.mAllTextPools.get(lKey);
                if (lTextPool == null || lHistoryEntry.getAbsolutePath().equals(lMDO.getAbsolutePath())) continue;
                String[] lLanguages = lTextPool.getAvailableLanguages();
                int i = 0;
                while (i < lLanguages.length) {
                    sCategoryCaching.infoT(sLocation, "commitChanges()", "deleting refactored language \"" + lLanguages[i] + "\" for MDO: " + ((DevelopmentObjectProxy)((Object)lMDO)).getKey());
                    String lOriginalPath = TextPoolProxy.getAbsolutePath(lLanguages[i], lHistoryEntry.getAbsolutePath());
                    if (this.mFileDeletionEnabled) {
                        sFileSystemService.delete(lOriginalPath);
                    }
                    lRefactoredLanguages.add(new RefactoredLanguageObjectImpl(lLanguages[i], lMDO, lTextPool.getAbsolutePath(lLanguages[i]), lOriginalPath));
                    ++i;
                }
            }
            Iterator it6 = this.mMDOWriteSet.iterator();
            while (it6.hasNext()) {
                CoreMainDevelopmentObject lMDO = (CoreMainDevelopmentObject)it6.next();
                if (lMDO instanceof MetamodelDocument) continue;
                DataState lDataState = ((DevelopmentObjectProxy)((Object)lMDO))._getDataState();
                if (lDataState == DataState.MODIFIED || lDataState == DataState.NEW) {
                    sCategoryCaching.infoT(sLocation, "commitChanges()", "saving " + (lDataState == DataState.MODIFIED ? "modified" : "new") + " MDO: " + ((DevelopmentObjectProxy)((Object)lMDO)).getKey());
                    if (lDataState == DataState.MODIFIED) {
                        lModifiedMDOs.add(lMDO);
                    } else {
                        lCreatedMDOs.add(lMDO);
                    }
                    lMDO._save();
                    continue;
                }
                if (lDataState == DataState.DELETED) {
                    if (this.mFileDeletionEnabled && !this.isMDORefactored(lMDO._getKey())) {
                        sFileSystemService.delete(lMDO.getAbsolutePath());
                    }
                    sCategoryCaching.infoT(sLocation, "commitChanges()", "removing deleted MDO from cache: " + ((DevelopmentObjectProxy)((Object)lMDO)).getKey());
                    lDeletedMDOs.add(lMDO);
                    this.mAllMDOInstances.remove(((ForeignReference)lMDO._getKey()).toLowerString());
                    continue;
                }
                if (lDataState == DataState.CANCELLED) {
                    sCategoryCaching.infoT(sLocation, "commitChanges()", "removing cancelled MDO from cache: " + ((DevelopmentObjectProxy)((Object)lMDO)).getKey());
                    lCancelledMDOs.add(lMDO);
                    this.mAllMDOInstances.remove(((ForeignReference)lMDO._getKey()).toLowerString());
                    continue;
                }
                if (lDataState != DataState.SYNCED || !lMDO._hasRepairedReferences()) continue;
                lMDO._setRepairedReferences(false);
            }
            Iterator it7 = this.mTextPoolWriteSet.iterator();
            while (it7.hasNext()) {
                lTextPool = (TextPoolProxy)it7.next();
                if (lTextPool.getOwner() instanceof MetamodelDocument) continue;
                Vector lVector = lTextPool.getDeletedLanguages();
                int i = 0;
                while (i < lVector.size()) {
                    String lLanguage = (String)lVector.get(i);
                    sCategoryCaching.infoT(sLocation, "commitChanges()", "deleting deleted language \"" + lLanguage + "\" for MDO: " + lTextPool.getOwner().getKey());
                    if (this.mFileDeletionEnabled && !this.isMDORefactored(lTextPool.getOwner().getKey())) {
                        sFileSystemService.delete(lTextPool.getAbsolutePath(lLanguage));
                    }
                    lDeletedLanguages.add(new LanguageObjectImpl(lLanguage, lTextPool.getOwner(), lTextPool.getAbsolutePath(lLanguage)));
                    lTextPool.removeLanguageDataState(lLanguage);
                    ++i;
                }
                lVector = lTextPool.getCancelledLanguages();
                i = 0;
                while (i < lVector.size()) {
                    String lLanguage = (String)lVector.get(i);
                    sCategoryCaching.infoT(sLocation, "commitChanges()", "removing cancelled language \"" + lLanguage + "\" for MDO: " + lTextPool.getOwner().getKey());
                    lTextPool.removeLanguageDataState(lLanguage);
                    ++i;
                }
                lVector = lTextPool.getNewLanguages();
                i = 0;
                while (i < lVector.size()) {
                    String lLanguage = (String)lVector.get(i);
                    sCategoryCaching.infoT(sLocation, "commitChanges()", "saving new language \"" + lLanguage + "\" for MDO: " + lTextPool.getOwner().getKey());
                    lCreatedLanguages.add(new LanguageObjectImpl(lLanguage, lTextPool.getOwner(), lTextPool.getAbsolutePath(lLanguage)));
                    lTextPool.saveLanguage(lLanguage);
                    ++i;
                }
                lVector = lTextPool.getModifiedLanguages();
                i = 0;
                while (i < lVector.size()) {
                    String lLanguage = (String)lVector.get(i);
                    sCategoryCaching.infoT(sLocation, "commitChanges()", "saving modified language \"" + lLanguage + "\" for MDO: " + lTextPool.getOwner().getKey());
                    lModifiedLanguages.add(new LanguageObjectImpl(lLanguage, lTextPool.getOwner(), lTextPool.getAbsolutePath(lLanguage)));
                    lTextPool.saveLanguage(lLanguage);
                    ++i;
                }
                lTextPool.setDirty(false);
                if (!lDeletedMDOs.contains(lTextPool.getOwner()) && !lCancelledMDOs.contains(lTextPool.getOwner())) continue;
                CoreMainDevelopmentObject lMDO = (CoreMainDevelopmentObject)((Object)lTextPool.getOwner());
                sCategoryCaching.infoT(sLocation, "commitChanges()", "removing text pool for MDO: " + lMDO._getKey());
                this.mAllTextPools.remove(((ForeignReference)lMDO._getKey()).toLowerString());
            }
            this.mReplacedMDOs.clear();
            this.mReplacedTextPools.clear();
            this.mRefactoredMDOs.clear();
            this.mMDOsReplacedByRefactoring.clear();
            this.mTextPoolsReplacedByRefactoring.clear();
            this.clearRefactoringHistories();
            this.mMDOWriteSet.clear();
            this.mTextPoolWriteSet.clear();
            this.setDirty(false);
        }
        return new CommitResultImpl(lMDOAccessProblems, lCancelledMDOs, lDeletedMDOs, lCreatedMDOs, lModifiedMDOs, lRefactoredMDOs, lCreatedLanguages, lDeletedLanguages, lModifiedLanguages, lRefactoredLanguages);
    }

    private MDOAccessProblem[] checkForRollback() {
        String method = "checkForRollback()";
        ArrayList<MDOAccessProblemImpl> lMDOAccessProblems = new ArrayList<MDOAccessProblemImpl>();
        Iterator it = this.mMDOWriteSet.iterator();
        while (it.hasNext()) {
            DevelopmentObjectProxy lMDO = (DevelopmentObjectProxy)it.next();
            if ((lMDO._getDataState() == DataState.NEW || lMDO._getDataState() == DataState.CANCELLED) && !this.mReplacedMDOs.containsKey(((ForeignReference)lMDO._getKey()).toLowerString())) continue;
            String lPath = null;
            int i = this.mRefactoredMDOs.size() - 1;
            while (i >= 0) {
                MDORefactoringHistoryEntryImpl lHistoryEntry = (MDORefactoringHistoryEntryImpl)this.mRefactoredMDOs.get(i);
                if (lHistoryEntry.getObject() == lMDO) {
                    lPath = lHistoryEntry.getAbsolutePath();
                    break;
                }
                --i;
            }
            if (lPath == null) {
                lPath = ((CoreMainDevelopmentObject)((Object)lMDO)).getAbsolutePath();
            }
            if (sFileSystemService.fileExists(lPath)) continue;
            lMDOAccessProblems.add(new MDOAccessProblemImpl((CoreMainDevelopmentObject)((Object)lMDO), lPath, 5));
            sCategoryIntegrity.infoT(sLocation, "checkForRollback()", "cannot reload: \"" + lPath + "\"");
        }
        Iterator it2 = this.mTextPoolWriteSet.iterator();
        while (it2.hasNext()) {
            TextPoolProxy lTextPool = (TextPoolProxy)it2.next();
            String lKey = ((ForeignReference)((DevelopmentObjectProxy)((Object)lTextPool.getOwner()))._getKey()).toLowerString();
            String lRefactoredMDOPath = null;
            int i = this.mRefactoredMDOs.size() - 1;
            while (i >= 0) {
                MDORefactoringHistoryEntryImpl lHistoryEntry = (MDORefactoringHistoryEntryImpl)this.mRefactoredMDOs.get(i);
                if (lHistoryEntry.getObject() == lTextPool.getOwner()) {
                    lRefactoredMDOPath = lHistoryEntry.getAbsolutePath();
                    break;
                }
                --i;
            }
            String[] lLanguages = lTextPool.getAvailableLanguages();
            int i2 = 0;
            while (i2 < lLanguages.length) {
                DataState lDataState = lTextPool.getLanguageDataState(lLanguages[i2]);
                if (lDataState == DataState.DELETED || lDataState == DataState.MODIFIED) {
                    String lPath = null;
                    lPath = lRefactoredMDOPath != null ? TextPoolProxy.getAbsolutePath(lLanguages[i2], lRefactoredMDOPath) : lTextPool.getAbsolutePath(lLanguages[i2]);
                    if (!sFileSystemService.fileExists(lPath)) {
                        lMDOAccessProblems.add(new MDOAccessProblemImpl((CoreMainDevelopmentObject)((Object)lTextPool.getOwner()), lPath, 9));
                        sCategoryIntegrity.infoT(sLocation, "checkForRollback()", "cannot reload: \"" + lPath + "\"");
                    }
                }
                ++i2;
            }
        }
        return lMDOAccessProblems.toArray(new MDOAccessProblem[0]);
    }

    public RollbackResult rollbackChanges() throws LoadException {
        String method = "rollbackChanges()";
        MDOAccessProblem[] lMDOAccessProblems = this.checkForRollback();
        ArrayList<DevelopmentObjectProxy> lCancelledMDOs = new ArrayList<DevelopmentObjectProxy>();
        ArrayList<RefactoredMDOImpl> lRefactoredMDOs = new ArrayList<RefactoredMDOImpl>();
        if (lMDOAccessProblems.length == 0) {
            Iterator it = this.mReplacedMDOs.keySet().iterator();
            while (it.hasNext()) {
                String lKey = (String)it.next();
                DevelopmentObjectProxy lPartnerMDO = (DevelopmentObjectProxy)this.mAllMDOInstances.get(lKey);
                if (lPartnerMDO._getDataState() == DataState.NEW) {
                    sCategoryCaching.infoT(sLocation, "rollbackChanges()", "internally deleting new MDO: " + lPartnerMDO.getKey());
                    lPartnerMDO._deleteInternal();
                }
                ((DevelopmentObjectProxy)this.mReplacedMDOs.get(lKey))._dropState();
            }
            this.mAllMDOInstances.putAll(this.mReplacedMDOs);
            Iterator it2 = this.mReplacedTextPools.values().iterator();
            while (it2.hasNext()) {
                ((TextPoolProxy)it2.next())._dropState();
            }
            this.mAllTextPools.putAll(this.mReplacedTextPools);
            Iterator it3 = ((AbstractList)this.mRefactoredMDOs).iterator();
            while (it3.hasNext()) {
                DevelopmentObjectProxy lObstacle;
                MDORefactoringHistoryEntryImpl lHistoryEntry = (MDORefactoringHistoryEntryImpl)it3.next();
                DevelopmentObjectProxy lObject = (DevelopmentObjectProxy)lHistoryEntry.getObject();
                DevelopmentObjectKey lKeyToCheck = lHistoryEntry.getKey();
                if (lHistoryEntry.isOriginal()) {
                    lRefactoredMDOs.add(new RefactoredMDOImpl((CoreMainDevelopmentObject)((Object)lObject), lObject.getName(), ((CoreMainDevelopmentObject)((Object)lObject)).getPackage(), ((CoreMainDevelopmentObject)((Object)lObject)).getAbsolutePath(), (DevelopmentObjectProxy)lObject.getParent(), lObject.getKey()));
                }
                if (lObject.getMetamodel().objectExists(lKeyToCheck) && (lObstacle = (DevelopmentObjectProxy)lObject.getMetamodel().getObjectFromKey(lKeyToCheck)) != null && lObstacle._getDataState() == DataState.NEW) {
                    lObstacle._deleteInternal();
                }
                String lOldKey = ((ForeignReference)lObject._getKey()).toLowerString();
                ((CoreMainDevelopmentObject)((Object)lObject))._unrefactor(lHistoryEntry);
                String lNewKey = (lOldKey.substring(0, lOldKey.indexOf(58) + 1) + lHistoryEntry.getPackage() + "." + lHistoryEntry.getName()).toLowerCase();
                if (lOldKey.equals(lNewKey)) continue;
                this.mAllMDOInstances.remove(lOldKey);
                this.mAllMDOInstances.put(lNewKey, lObject);
                TextPoolProxy lTextPool = (TextPoolProxy)this.mAllTextPools.get(lOldKey);
                if (lTextPool == null) continue;
                this.mAllTextPools.remove(lOldKey);
                this.mAllTextPools.put(lNewKey, lTextPool);
            }
            Iterator it4 = this.mMDOsReplacedByRefactoring.keySet().iterator();
            while (it4.hasNext()) {
                String lKey = (String)it4.next();
                DevelopmentObjectProxy lPartnerMDO = (DevelopmentObjectProxy)this.mAllMDOInstances.get(lKey);
                if (lPartnerMDO != null) {
                    sCategoryCaching.infoT(sLocation, "rollbackChanges()", "internally deleting new MDO: " + lPartnerMDO.getKey());
                    lPartnerMDO._deleteInternal();
                }
                ((DevelopmentObjectProxy)this.mMDOsReplacedByRefactoring.get(lKey))._dropState();
            }
            this.mAllMDOInstances.putAll(this.mMDOsReplacedByRefactoring);
            Iterator it5 = this.mTextPoolsReplacedByRefactoring.values().iterator();
            while (it5.hasNext()) {
                ((TextPoolProxy)it5.next())._dropState();
            }
            this.mAllTextPools.putAll(this.mTextPoolsReplacedByRefactoring);
            ArrayList<DevelopmentObjectKey> lToRemove = new ArrayList<DevelopmentObjectKey>();
            ArrayList<DevelopmentObjectProxy> lNotifyDiscarded = new ArrayList<DevelopmentObjectProxy>();
            ArrayList<DevelopmentObjectProxy> lNotifyReloaded = new ArrayList<DevelopmentObjectProxy>();
            Iterator it6 = this.mMDOWriteSet.iterator();
            while (it6.hasNext()) {
                DevelopmentObjectProxy lMDO = (DevelopmentObjectProxy)it6.next();
                DevelopmentObjectKey lKey = lMDO.getKey();
                if (lMDO._getDataState() == DataState.NEW) {
                    sCategoryCaching.infoT(sLocation, "rollbackChanges()", "internally deleting new MDO: " + lKey);
                    lMDO._deleteInternal();
                    lCancelledMDOs.add(lMDO);
                    if (lMDO.getRoot().isEventingEnabled()) {
                        lNotifyDiscarded.add(lMDO);
                    }
                    lToRemove.add(lKey);
                    continue;
                }
                if (lMDO._getDataState() == DataState.CANCELLED) {
                    sCategoryCaching.infoT(sLocation, "rollbackChanges()", "removing cancelled MDO: " + lKey);
                    lCancelledMDOs.add(lMDO);
                    lToRemove.add(lKey);
                    continue;
                }
                sCategoryCaching.infoT(sLocation, "rollbackChanges()", "reloading MDO: " + lKey);
                ((CoreMainDevelopmentObject)((Object)lMDO))._reload();
                if (lMDO.getRoot().isEventingEnabled()) {
                    lNotifyReloaded.add(lMDO);
                }
                if (lMDO._getDataState() != DataState.SYNCED) continue;
                ((CoreMainDevelopmentObject)((Object)lMDO))._setRepairedReferences(false);
            }
            Iterator it7 = ((AbstractList)lToRemove).iterator();
            while (it7.hasNext()) {
                this.mAllMDOInstances.remove(((ForeignReference)it7.next()).toLowerString());
            }
            Iterator it8 = this.mTextPoolWriteSet.iterator();
            while (it8.hasNext()) {
                TextPoolProxy lTextPool = (TextPoolProxy)it8.next();
                CoreMainDevelopmentObject lMDO = (CoreMainDevelopmentObject)((Object)lTextPool.getOwner());
                if (lCancelledMDOs.contains(lMDO)) {
                    sCategoryCaching.infoT(sLocation, "rollbackChanges()", "removing text pool for MDO: " + lMDO._getKey());
                    this.mAllTextPools.remove(((ForeignReference)lMDO._getKey()).toLowerString());
                    continue;
                }
                lTextPool.reload();
            }
            this.mReplacedMDOs.clear();
            this.mReplacedTextPools.clear();
            this.mRefactoredMDOs.clear();
            this.mMDOsReplacedByRefactoring.clear();
            this.mTextPoolsReplacedByRefactoring.clear();
            this.clearRefactoringHistories();
            this.mMDOWriteSet.clear();
            this.mTextPoolWriteSet.clear();
            this.setDirty(false);
            Iterator it9 = ((AbstractList)lNotifyDiscarded).iterator();
            while (it9.hasNext()) {
                ((DevelopmentObjectProxy)it9.next())._notifyMDODiscarded();
            }
            Iterator it10 = ((AbstractList)lNotifyReloaded).iterator();
            while (it10.hasNext()) {
                ((DevelopmentObjectProxy)it10.next())._notifyMDOReloaded();
            }
        }
        return new RollbackResultImpl(lMDOAccessProblems, lCancelledMDOs, lRefactoredMDOs);
    }

    public void fastRollback() {
        String method = "fastRollback()";
        ArrayList<DevelopmentObjectProxy> lCancelledMDOs = new ArrayList<DevelopmentObjectProxy>();
        if (!(this.mReplacedMDOs.isEmpty() && this.mReplacedTextPools.isEmpty() && this.mRefactoredMDOs.isEmpty() && this.mMDOsReplacedByRefactoring.isEmpty() && this.mTextPoolsReplacedByRefactoring.isEmpty())) {
            sCategoryCaching.errorT(sLocation, "fastRollback()", "MDO replacements or refactoring occured");
        }
        Iterator it = this.mMDOWriteSet.iterator();
        while (it.hasNext()) {
            DevelopmentObjectProxy lMDO = (DevelopmentObjectProxy)it.next();
            if (lMDO._getDataState() == DataState.MODIFIED) {
                MetamodelIterator it2 = lMDO.iterator(false, false, true);
                while (it2.hasNext()) {
                    DevelopmentObjectProxy lProxy = (DevelopmentObjectProxy)it2.next();
                    if (lProxy._getDataState() == DataState.MODIFIED) {
                        sCategoryCaching.infoT(sLocation, "fastRollback()", "re-setting datastate of modified object to synced: " + lMDO._getKey());
                        lProxy._setDataState(DataState.SYNCED);
                        continue;
                    }
                    if (lProxy._getDataState() != DataState.NEW) continue;
                    sCategoryCaching.errorT(sLocation, "fastRollback()", "found new object: " + lProxy._getKey());
                }
                continue;
            }
            if (lMDO._getDataState() == DataState.CANCELLED) {
                sCategoryCaching.infoT(sLocation, "fastRollback()", "removing cancelled MDO: " + lMDO._getKey());
                lCancelledMDOs.add(lMDO);
                this.mAllMDOInstances.remove(((ForeignReference)lMDO._getKey()).toLowerString());
                continue;
            }
            if (lMDO._getDataState() == DataState.DELETED) {
                sCategoryCaching.errorT(sLocation, "fastRollback()", "found deleted MDO: " + lMDO._getKey());
                continue;
            }
            if (lMDO._getDataState() != DataState.NEW) continue;
            sCategoryCaching.errorT(sLocation, "fastRollback()", "found new MDO: " + lMDO._getKey());
        }
        Iterator it2 = this.mTextPoolWriteSet.iterator();
        while (it2.hasNext()) {
            TextPoolProxy lTextPool = (TextPoolProxy)it2.next();
            CoreMainDevelopmentObject lMDO = (CoreMainDevelopmentObject)((Object)lTextPool.getOwner());
            if (lCancelledMDOs.contains(lMDO)) {
                sCategoryCaching.infoT(sLocation, "fastRollback()", "removing text pool for MDO: " + lMDO._getKey());
                this.mAllTextPools.remove(((ForeignReference)lMDO._getKey()).toLowerString());
                continue;
            }
            Vector lLanguages = lTextPool.getCancelledLanguages();
            int i = 0;
            while (i < lLanguages.size()) {
                lTextPool.removeLanguageDataState((String)lLanguages.get(i));
                ++i;
            }
            lLanguages = lTextPool.getModifiedLanguages();
            int i2 = 0;
            while (i2 < lLanguages.size()) {
                lTextPool.setLanguageDataState((String)lLanguages.get(i2), DataState.SYNCED);
                ++i2;
            }
            lTextPool.getModifiedLanguages();
            if (!lTextPool.getDeletedLanguages().isEmpty()) {
                sCategoryCaching.errorT(sLocation, "fastRollback()", "found deleted languages for MDO: " + ((DevelopmentObjectProxy)((Object)lTextPool.getOwner()))._getKey());
            }
            if (lTextPool.getNewLanguages().isEmpty()) continue;
            sCategoryCaching.errorT(sLocation, "fastRollback()", "found new languages for MDO: " + ((DevelopmentObjectProxy)((Object)lTextPool.getOwner()))._getKey());
        }
        this.mMDOWriteSet.clear();
        this.mTextPoolWriteSet.clear();
        this.setDirty(false);
    }

    public void existingMDOReplaced(CoreMainDevelopmentObject mdo) {
        String lKey = ((ForeignReference)((DevelopmentObjectProxy)((Object)mdo)).getKey()).toLowerString();
        if (mdo instanceof MetamodelDocument) {
            this.mReplacedDocuments.put(lKey, mdo);
        } else {
            this.mReplacedMDOs.put(lKey, mdo);
        }
        this.mMDOWriteSet.remove(mdo);
        TextPoolProxy lTextPool = (TextPoolProxy)this.mAllTextPools.get(lKey);
        if (lTextPool != null) {
            if (mdo instanceof MetamodelDocument) {
                this.mReplacedDocumentTextPools.put(lKey, lTextPool);
            } else {
                this.mReplacedTextPools.put(lKey, lTextPool);
            }
            this.mAllTextPools.remove(lKey);
            this.mTextPoolWriteSet.remove(lTextPool);
        }
    }

    private MDOAccessProblem[] checkMDOForCommit(CoreMainDevelopmentObject mdo) {
        DataState lDataState;
        String lPath;
        int i;
        TextPoolProxy lReplacedTextPool;
        String lPath2;
        String method = "checkMDOForCommit()";
        DevelopmentObjectProxy lMDO = (DevelopmentObjectProxy)((Object)mdo);
        sCategoryIntegrity.infoT(sLocation, "checkMDOForCommit()", "checking commit preconditions for MDO: " + lMDO.getKey());
        ArrayList<MDOAccessProblemImpl> lMDOAccessProblems = new ArrayList<MDOAccessProblemImpl>();
        String lKey = ((ForeignReference)lMDO.getKey()).toLowerString();
        CoreMainDevelopmentObject lReplacedMDO = (CoreMainDevelopmentObject)this.mReplacedDocuments.get(lKey);
        if (lReplacedMDO != null && sFileSystemService.fileExists(lPath2 = lReplacedMDO.getAbsolutePath()) && sFileSystemService.isReadOnly(lPath2)) {
            lMDOAccessProblems.add(new MDOAccessProblemImpl(lReplacedMDO, lPath2, 3));
            sCategoryIntegrity.infoT(sLocation, "checkMDOForCommit()", "cannot delete: \"" + lPath2 + "\"");
        }
        if ((lReplacedTextPool = (TextPoolProxy)this.mReplacedDocumentTextPools.get(lKey)) != null) {
            Vector lVector = lReplacedTextPool.getDeletedLanguages();
            i = 0;
            while (i < lVector.size()) {
                String lLanguage = (String)lVector.get(i);
                lPath = lReplacedTextPool.getAbsolutePath(lLanguage);
                if (sFileSystemService.fileExists(lPath) && sFileSystemService.isReadOnly(lPath)) {
                    lMDOAccessProblems.add(new MDOAccessProblemImpl(lReplacedMDO, lLanguage, lPath, 7));
                    sCategoryIntegrity.infoT(sLocation, "checkMDOForCommit()", "cannot delete language: \"" + lPath + "\"");
                }
                ++i;
            }
        }
        String lOriginalPath = null;
        i = this.mRefactoredDocuments.size() - 1;
        while (i >= 0) {
            MDORefactoringHistoryEntryImpl lHistoryEntry = (MDORefactoringHistoryEntryImpl)this.mRefactoredDocuments.get(i);
            if (lHistoryEntry.getObject() == mdo) {
                lOriginalPath = lHistoryEntry.getAbsolutePath();
                break;
            }
            --i;
        }
        if (lOriginalPath != null) {
            TextPoolProxy lTextPool;
            if (sFileSystemService.fileExists(lOriginalPath) && sFileSystemService.isReadOnly(lOriginalPath)) {
                lMDOAccessProblems.add(new MDOAccessProblemImpl(mdo, lOriginalPath, 3));
                sCategoryIntegrity.infoT(sLocation, "checkMDOForCommit()", "cannot delete: \"" + lOriginalPath + "\"");
            }
            if ((lTextPool = (TextPoolProxy)this.mAllTextPools.get(lKey = ((ForeignReference)lMDO.getKey()).toLowerString())) != null && !lOriginalPath.equals(mdo.getAbsolutePath())) {
                String[] lLanguages = lTextPool.getAvailableLanguages();
                int i2 = 0;
                while (i2 < lLanguages.length) {
                    String lLanguagePath = TextPoolProxy.getAbsolutePath(lLanguages[i2], lOriginalPath);
                    if (sFileSystemService.fileExists(lLanguagePath) && sFileSystemService.isReadOnly(lLanguagePath)) {
                        lMDOAccessProblems.add(new MDOAccessProblemImpl(mdo, lLanguages[i2], lLanguagePath, 7));
                        sCategoryIntegrity.infoT(sLocation, "checkMDOForCommit()", "cannot delete language: \"" + lLanguagePath + "\"");
                    }
                    ++i2;
                }
            }
        }
        if ((lDataState = lMDO._getDataState()) == DataState.MODIFIED || lDataState == DataState.NEW) {
            lPath = mdo.getAbsolutePath();
            if (sFileSystemService.fileExists(lPath) && sFileSystemService.isReadOnly(lPath)) {
                lMDOAccessProblems.add(new MDOAccessProblemImpl(mdo, lPath, 2));
                sCategoryIntegrity.infoT(sLocation, "checkMDOForCommit()", "cannot save: \"" + lPath + "\"");
            }
        } else if (lDataState == DataState.DELETED && sFileSystemService.fileExists(lPath = mdo.getAbsolutePath()) && sFileSystemService.isReadOnly(lPath)) {
            lMDOAccessProblems.add(new MDOAccessProblemImpl(mdo, lPath, 3));
            sCategoryIntegrity.infoT(sLocation, "checkMDOForCommit()", "cannot delete: \"" + lPath + "\"");
        }
        TextPoolProxy lTextPool = (TextPoolProxy)this.mAllTextPools.get(lKey);
        if (lTextPool != null) {
            Iterator it = ((AbstractList)lTextPool.getDeletedLanguages()).iterator();
            while (it.hasNext()) {
                String lLanguage = (String)it.next();
                String lPath3 = lTextPool.getAbsolutePath(lLanguage);
                if (!sFileSystemService.fileExists(lPath3) || !sFileSystemService.isReadOnly(lPath3)) continue;
                lMDOAccessProblems.add(new MDOAccessProblemImpl(mdo, lLanguage, lPath3, 7));
                sCategoryIntegrity.infoT(sLocation, "checkMDOForCommit()", "cannot delete language: \"" + lPath3 + "\"");
            }
            Vector lLanguages = lTextPool.getNewLanguages();
            lLanguages.addAll(lTextPool.getModifiedLanguages());
            Iterator it2 = ((AbstractList)lLanguages).iterator();
            while (it2.hasNext()) {
                String lLanguage = (String)it2.next();
                String lPath4 = lTextPool.getAbsolutePath(lLanguage);
                if (!sFileSystemService.fileExists(lPath4) || !sFileSystemService.isReadOnly(lPath4)) continue;
                lMDOAccessProblems.add(new MDOAccessProblemImpl(mdo, lLanguage, lPath4, 6));
                sCategoryIntegrity.infoT(sLocation, "checkMDOForCommit()", "cannot save language: \"" + lPath4 + "\"");
            }
        }
        return lMDOAccessProblems.toArray(new MDOAccessProblem[0]);
    }

    public CommitResult commitChangesForMDO(CoreMainDevelopmentObject mdo) throws SaveException, DeleteException {
        String method = "commitChangesForMDO()";
        ArrayList<CoreMainDevelopmentObject> lCreatedMDOs = new ArrayList<CoreMainDevelopmentObject>();
        ArrayList<CoreMainDevelopmentObject> lDeletedMDOs = new ArrayList<CoreMainDevelopmentObject>();
        ArrayList<CoreMainDevelopmentObject> lCancelledMDOs = new ArrayList<CoreMainDevelopmentObject>();
        ArrayList<CoreMainDevelopmentObject> lModifiedMDOs = new ArrayList<CoreMainDevelopmentObject>();
        ArrayList<RefactoredMDOImpl> lRefactoredMDOs = new ArrayList<RefactoredMDOImpl>();
        ArrayList<LanguageObjectImpl> lCreatedLanguages = new ArrayList<LanguageObjectImpl>();
        ArrayList<LanguageObjectImpl> lDeletedLanguages = new ArrayList<LanguageObjectImpl>();
        ArrayList<LanguageObjectImpl> lModifiedLanguages = new ArrayList<LanguageObjectImpl>();
        ArrayList<RefactoredLanguageObjectImpl> lRefactoredLanguages = new ArrayList<RefactoredLanguageObjectImpl>();
        MDOAccessProblem[] lMDOAccessProblems = this.checkMDOForCommit(mdo);
        if (lMDOAccessProblems.length == 0) {
            DataState lDataState;
            int i;
            TextPoolProxy lReplacedTextPool;
            DevelopmentObjectProxy lMDO = (DevelopmentObjectProxy)((Object)mdo);
            String lKey = ((ForeignReference)lMDO.getKey()).toLowerString();
            CoreMainDevelopmentObject lReplacedMDO = (CoreMainDevelopmentObject)this.mReplacedDocuments.get(lKey);
            if (lReplacedMDO != null) {
                if (this.mFileDeletionEnabled && !this.isMDORefactored(lReplacedMDO._getKey())) {
                    sFileSystemService.delete(lReplacedMDO.getAbsolutePath());
                }
                sCategoryCaching.infoT(sLocation, "commitChangesForMDO()", "removing deleted MDO from cache: " + ((DevelopmentObjectProxy)((Object)lReplacedMDO))._getKey());
                lDeletedMDOs.add(lReplacedMDO);
            }
            if ((lReplacedTextPool = (TextPoolProxy)this.mReplacedDocumentTextPools.get(lKey)) != null) {
                Vector lVector = lReplacedTextPool.getDeletedLanguages();
                i = 0;
                while (i < lVector.size()) {
                    String lLanguage = (String)lVector.get(i);
                    sCategoryCaching.infoT(sLocation, "commitChangesForMDO()", "deleting deleted language \"" + lLanguage + "\" for MDO: " + ((DevelopmentObjectProxy)((Object)lReplacedMDO))._getKey());
                    if (this.mFileDeletionEnabled && !this.isMDORefactored(lReplacedTextPool.getOwner().getKey())) {
                        sFileSystemService.delete(lReplacedTextPool.getAbsolutePath(lLanguage));
                    }
                    lDeletedLanguages.add(new LanguageObjectImpl(lLanguage, lReplacedTextPool.getOwner(), lReplacedTextPool.getAbsolutePath(lLanguage)));
                    ++i;
                }
            }
            MDORefactoringHistoryEntryImpl lHistoryEntry = null;
            i = this.mRefactoredDocuments.size() - 1;
            while (i >= 0) {
                MDORefactoringHistoryEntryImpl lEntry = (MDORefactoringHistoryEntryImpl)this.mRefactoredDocuments.get(i);
                if (lEntry.getObject() == mdo) {
                    lHistoryEntry = lEntry;
                    break;
                }
                --i;
            }
            if (lHistoryEntry != null) {
                sCategoryCaching.infoT(sLocation, "commitChangesForMDO()", "deleting refactored MDO: " + lMDO._getKey());
                if (this.mFileDeletionEnabled) {
                    sFileSystemService.delete(lHistoryEntry.getAbsolutePath());
                }
                lRefactoredMDOs.add(new RefactoredMDOImpl(mdo, lHistoryEntry.getName(), lHistoryEntry.getPackage(), lHistoryEntry.getAbsolutePath(), (DevelopmentObjectProxy)lHistoryEntry.getParent(), lHistoryEntry.getKey()));
                lKey = ((ForeignReference)lMDO.getKey()).toLowerString();
                TextPoolProxy lTextPool = (TextPoolProxy)this.mAllTextPools.get(lKey);
                if (lTextPool != null && !lHistoryEntry.getAbsolutePath().equals(mdo.getAbsolutePath())) {
                    String[] lLanguages = lTextPool.getAvailableLanguages();
                    int i2 = 0;
                    while (i2 < lLanguages.length) {
                        sCategoryCaching.infoT(sLocation, "commitChangesForMDO()", "deleting refactored language \"" + lLanguages[i2] + "\" for MDO: " + lMDO.getKey());
                        String lOriginalPath = TextPoolProxy.getAbsolutePath(lLanguages[i2], lHistoryEntry.getAbsolutePath());
                        if (this.mFileDeletionEnabled) {
                            sFileSystemService.delete(lOriginalPath);
                        }
                        lRefactoredLanguages.add(new RefactoredLanguageObjectImpl(lLanguages[i2], mdo, lTextPool.getAbsolutePath(lLanguages[i2]), lOriginalPath));
                        ++i2;
                    }
                }
            }
            if ((lDataState = lMDO._getDataState()) == DataState.MODIFIED || lDataState == DataState.NEW) {
                sCategoryCaching.infoT(sLocation, "commitChangesForMDO()", "saving " + (lDataState == DataState.MODIFIED ? "modified" : "new") + " MDO: " + lMDO.getKey());
                if (lDataState == DataState.MODIFIED) {
                    lModifiedMDOs.add(mdo);
                } else {
                    lCreatedMDOs.add(mdo);
                }
                mdo._save();
            } else if (lDataState == DataState.DELETED) {
                if (this.mFileDeletionEnabled && !this.isMDORefactored(mdo._getKey())) {
                    sFileSystemService.delete(mdo.getAbsolutePath());
                }
                sCategoryCaching.infoT(sLocation, "commitChangesForMDO()", "removing deleted MDO from cache: " + lMDO.getKey());
                lDeletedMDOs.add(mdo);
                this.mAllMDOInstances.remove(lKey);
            } else if (lDataState == DataState.CANCELLED) {
                sCategoryCaching.infoT(sLocation, "commitChangesForMDO()", "removing cancelled MDO from cache: " + lMDO.getKey());
                lCancelledMDOs.add(mdo);
                this.mAllMDOInstances.remove(lKey);
            } else if (lDataState == DataState.SYNCED && mdo._hasRepairedReferences()) {
                mdo._setRepairedReferences(false);
            }
            TextPoolProxy lTextPool = (TextPoolProxy)this.mAllTextPools.get(lKey);
            if (lTextPool != null) {
                Iterator it = ((AbstractList)lTextPool.getDeletedLanguages()).iterator();
                while (it.hasNext()) {
                    String lLanguage = (String)it.next();
                    sCategoryCaching.infoT(sLocation, "commitChangesForMDO()", "deleting deleted language \"" + lLanguage + "\" for MDO: " + lMDO.getKey());
                    if (this.mFileDeletionEnabled && !this.isMDORefactored(lTextPool.getOwner().getKey())) {
                        sFileSystemService.delete(lTextPool.getAbsolutePath(lLanguage));
                    }
                    lDeletedLanguages.add(new LanguageObjectImpl(lLanguage, lTextPool.getOwner(), lTextPool.getAbsolutePath(lLanguage)));
                    lTextPool.removeLanguageDataState(lLanguage);
                }
                Iterator it2 = ((AbstractList)lTextPool.getCancelledLanguages()).iterator();
                while (it2.hasNext()) {
                    String lLanguage = (String)it2.next();
                    sCategoryCaching.infoT(sLocation, "commitChangesForMDO()", "removing cancelled language \"" + lLanguage + "\" for MDO: " + lMDO.getKey());
                    lTextPool.removeLanguageDataState(lLanguage);
                }
                Iterator it3 = ((AbstractList)lTextPool.getNewLanguages()).iterator();
                while (it3.hasNext()) {
                    String lLanguage = (String)it3.next();
                    sCategoryCaching.infoT(sLocation, "commitChangesForMDO()", "saving new language \"" + lLanguage + "\" for MDO: " + lMDO.getKey());
                    lCreatedLanguages.add(new LanguageObjectImpl(lLanguage, lTextPool.getOwner(), lTextPool.getAbsolutePath(lLanguage)));
                    lTextPool.saveLanguage(lLanguage);
                }
                Iterator it4 = ((AbstractList)lTextPool.getModifiedLanguages()).iterator();
                while (it4.hasNext()) {
                    String lLanguage = (String)it4.next();
                    sCategoryCaching.infoT(sLocation, "commitChangesForMDO()", "saving modified language \"" + lLanguage + "\" for MDO: " + lMDO.getKey());
                    lModifiedLanguages.add(new LanguageObjectImpl(lLanguage, lTextPool.getOwner(), lTextPool.getAbsolutePath(lLanguage)));
                    lTextPool.saveLanguage(lLanguage);
                }
                lTextPool.setDirty(false);
                if (lDeletedMDOs.contains(mdo) || lCancelledMDOs.contains(mdo)) {
                    sCategoryCaching.infoT(sLocation, "commitChangesForMDO()", "removing text pool for MDO: " + lMDO.getKey());
                    this.mAllTextPools.remove(lKey);
                }
            }
            this.mReplacedDocuments.remove(lKey);
            this.mReplacedDocumentTextPools.remove(lKey);
            Iterator it = ((AbstractList)this.mRefactoredDocuments).iterator();
            while (it.hasNext()) {
                MDORefactoringHistoryEntryImpl lEntry = (MDORefactoringHistoryEntryImpl)it.next();
                if (lEntry.getObject() != mdo) continue;
                it.remove();
            }
        }
        return new CommitResultImpl(lMDOAccessProblems, lCancelledMDOs, lDeletedMDOs, lCreatedMDOs, lModifiedMDOs, lRefactoredMDOs, lCreatedLanguages, lDeletedLanguages, lModifiedLanguages, lRefactoredLanguages);
    }

    private MDOAccessProblem[] checkMDOForRollback(CoreMainDevelopmentObject mdo) {
        String lKey;
        TextPoolProxy lTextPool;
        String method = "checkMDOForRollback()";
        sCategoryIntegrity.infoT(sLocation, "checkMDOForRollback()", "checking rollback preconditions for MDO: " + ((DevelopmentObjectProxy)((Object)mdo)).getKey());
        ArrayList<MDOAccessProblemImpl> lMDOAccessProblems = new ArrayList<MDOAccessProblemImpl>();
        DevelopmentObjectProxy lMDO = (DevelopmentObjectProxy)((Object)mdo);
        if (lMDO._getDataState() != DataState.SYNCED && lMDO._getDataState() != DataState.HOLLOW && (lMDO._getDataState() != DataState.NEW && lMDO._getDataState() != DataState.CANCELLED || this.mReplacedDocuments.containsKey(((ForeignReference)lMDO._getKey()).toLowerString()))) {
            String lPath = null;
            int i = this.mRefactoredDocuments.size() - 1;
            while (i >= 0) {
                MDORefactoringHistoryEntryImpl lHistoryEntry = (MDORefactoringHistoryEntryImpl)this.mRefactoredDocuments.get(i);
                if (lHistoryEntry.getObject() == mdo) {
                    lPath = lHistoryEntry.getAbsolutePath();
                    break;
                }
                --i;
            }
            if (lPath == null) {
                lPath = mdo.getAbsolutePath();
            }
            if (!sFileSystemService.fileExists(lPath)) {
                lMDOAccessProblems.add(new MDOAccessProblemImpl(mdo, lPath, 5));
                sCategoryIntegrity.infoT(sLocation, "checkMDOForRollback()", "cannot reload: \"" + lPath + "\"");
            }
        }
        if ((lTextPool = (TextPoolProxy)this.mAllTextPools.get(lKey = ((ForeignReference)lMDO.getKey()).toLowerString())) != null && lTextPool.isModified() || this.mReplacedDocumentTextPools.containsKey(lKey)) {
            String lRefactoredMDOPath = null;
            int i = this.mRefactoredDocuments.size() - 1;
            while (i >= 0) {
                MDORefactoringHistoryEntryImpl lHistoryEntry = (MDORefactoringHistoryEntryImpl)this.mRefactoredDocuments.get(i);
                if (lHistoryEntry.getObject() == mdo) {
                    lRefactoredMDOPath = lHistoryEntry.getAbsolutePath();
                    break;
                }
                --i;
            }
            String[] lLanguages = lTextPool.getAvailableLanguages();
            int i2 = 0;
            while (i2 < lLanguages.length) {
                DataState lDataState = lTextPool.getLanguageDataState(lLanguages[i2]);
                if (lDataState == DataState.DELETED || lDataState == DataState.MODIFIED) {
                    String lPath = null;
                    lPath = lRefactoredMDOPath != null ? TextPoolProxy.getAbsolutePath(lLanguages[i2], lRefactoredMDOPath) : lTextPool.getAbsolutePath(lLanguages[i2]);
                    if (!sFileSystemService.fileExists(lPath)) {
                        lMDOAccessProblems.add(new MDOAccessProblemImpl(mdo, lPath, 9));
                        sCategoryIntegrity.infoT(sLocation, "checkMDOForRollback()", "cannot reload: \"" + lPath + "\"");
                    }
                }
                ++i2;
            }
        }
        return lMDOAccessProblems.toArray(new MDOAccessProblem[0]);
    }

    public RollbackResult rollbackChangesForMDO(CoreMainDevelopmentObject mdo) throws LoadException {
        String method = "rollbackChangesForMDO()";
        ArrayList<DevelopmentObjectProxy> lCancelledMDOs = new ArrayList<DevelopmentObjectProxy>();
        ArrayList<RefactoredMDOImpl> lRefactoredMDOs = new ArrayList<RefactoredMDOImpl>();
        MDOAccessProblem[] lMDOAccessProblems = this.checkMDOForRollback(mdo);
        if (lMDOAccessProblems.length == 0) {
            TextPoolProxy lTextPool;
            DevelopmentObjectProxy lMDO;
            DataState lDataState;
            TextPoolProxy lReplacedTextPool;
            boolean lNotifyDiscarded = false;
            boolean lNotifyReloaded = false;
            String lKey = ((ForeignReference)((DevelopmentObjectProxy)((Object)mdo)).getKey()).toLowerString();
            DevelopmentObjectProxy lReplacedMDO = (DevelopmentObjectProxy)this.mReplacedDocuments.get(lKey);
            if (lReplacedMDO != null) {
                DevelopmentObjectProxy lPartnerMDO = (DevelopmentObjectProxy)this.mAllMDOInstances.get(lKey);
                if (lPartnerMDO._getDataState() == DataState.NEW) {
                    sCategoryCaching.infoT(sLocation, "rollbackChangesForMDO()", "internally deleting new MDO: " + lPartnerMDO.getKey());
                    lPartnerMDO._deleteInternal();
                }
                lReplacedMDO._dropState();
                this.mAllMDOInstances.put(lKey, lReplacedMDO);
            }
            if ((lReplacedTextPool = (TextPoolProxy)this.mReplacedDocumentTextPools.get(lKey)) != null) {
                lReplacedTextPool._dropState();
                this.mAllTextPools.put(lKey, lReplacedTextPool);
            }
            RefactoringHistoryEntryImpl lHistoryEntry = null;
            int i = this.mRefactoredDocuments.size() - 1;
            while (i >= 0) {
                MDORefactoringHistoryEntryImpl lEntry = (MDORefactoringHistoryEntryImpl)this.mRefactoredDocuments.get(i);
                if (lEntry.getObject() == mdo) {
                    lHistoryEntry = lEntry;
                    break;
                }
                --i;
            }
            if (lHistoryEntry != null) {
                DevelopmentObjectProxy lObstacle;
                DevelopmentObjectProxy lObject = (DevelopmentObjectProxy)lHistoryEntry.getObject();
                DevelopmentObjectKey lKeyToCheck = lHistoryEntry.getKey();
                lRefactoredMDOs.add(new RefactoredMDOImpl((CoreMainDevelopmentObject)((Object)lObject), ((CoreMainDevelopmentObject)((Object)lObject)).getName(), ((CoreMainDevelopmentObject)((Object)lObject)).getPackage(), ((CoreMainDevelopmentObject)((Object)lObject)).getAbsolutePath(), (DevelopmentObjectProxy)lObject.getParent(), lObject.getKey()));
                if (lObject.getMetamodel().objectExists(lKeyToCheck) && (lObstacle = (DevelopmentObjectProxy)lObject.getMetamodel().getObjectFromKey(lKeyToCheck)) != null && lObstacle._getDataState() == DataState.NEW) {
                    lObstacle._deleteInternal();
                }
                String lOldKey = ((ForeignReference)lObject._getKey()).toLowerString();
                ((CoreMainDevelopmentObject)((Object)lObject))._unrefactor((MDORefactoringHistoryEntryImpl)lHistoryEntry);
                String lNewKey = (lOldKey.substring(0, lOldKey.indexOf(58) + 1) + ((MDORefactoringHistoryEntryImpl)lHistoryEntry).getPackage() + "." + lHistoryEntry.getName()).toLowerCase();
                if (!lOldKey.equals(lNewKey)) {
                    this.mAllMDOInstances.remove(lOldKey);
                    this.mAllMDOInstances.put(lNewKey, lObject);
                    TextPoolProxy lTextPool2 = (TextPoolProxy)this.mAllTextPools.get(lOldKey);
                    if (lTextPool2 != null) {
                        this.mAllTextPools.remove(lOldKey);
                        this.mAllTextPools.put(lNewKey, lTextPool2);
                    }
                }
            }
            if ((lDataState = (lMDO = (DevelopmentObjectProxy)((Object)mdo))._getDataState()) != DataState.HOLLOW) {
                if (lDataState == DataState.NEW) {
                    sCategoryCaching.infoT(sLocation, "rollbackChangesForMDO()", "internally deleting new MDO: " + lMDO.getKey());
                    lMDO._deleteInternal();
                    if (lMDO.getRoot().isEventingEnabled()) {
                        lNotifyDiscarded = true;
                    }
                    lCancelledMDOs.add(lMDO);
                    this.mAllMDOInstances.remove(lKey);
                } else if (lDataState == DataState.CANCELLED) {
                    sCategoryCaching.infoT(sLocation, "rollbackChangesForMDO()", "removing cancelled MDO: " + lMDO.getKey());
                    this.mAllMDOInstances.remove(lKey);
                } else if (lDataState == DataState.SYNCED && mdo._hasRepairedReferences()) {
                    sCategoryCaching.infoT(sLocation, "rollbackChangesForMDO()", "reloading MDO: " + lMDO.getKey());
                    mdo._reload();
                    if (lMDO.getRoot().isEventingEnabled()) {
                        lNotifyReloaded = true;
                    }
                    mdo._setRepairedReferences(false);
                } else {
                    sCategoryCaching.infoT(sLocation, "rollbackChangesForMDO()", "reloading MDO: " + lMDO.getKey());
                    mdo._reload();
                    if (lMDO.getRoot().isEventingEnabled()) {
                        lNotifyReloaded = true;
                    }
                }
            }
            if ((lTextPool = (TextPoolProxy)this.mAllTextPools.get(lKey)) != null && lTextPool.isModified()) {
                lTextPool.reload();
            }
            this.mReplacedDocuments.remove(lKey);
            this.mReplacedDocumentTextPools.remove(lKey);
            Iterator it = ((AbstractList)this.mRefactoredDocuments).iterator();
            while (it.hasNext()) {
                MDORefactoringHistoryEntryImpl lEntry = (MDORefactoringHistoryEntryImpl)it.next();
                if (lEntry.getObject() != mdo) continue;
                it.remove();
            }
            if (lNotifyDiscarded) {
                lMDO._notifyMDODiscarded();
            }
            if (lNotifyReloaded) {
                lMDO._notifyMDOReloaded();
            }
        }
        return new RollbackResultImpl(lMDOAccessProblems, lCancelledMDOs, lRefactoredMDOs);
    }

    public void setFileDeletionEnabled(boolean value) {
        this.mFileDeletionEnabled = value;
    }

    public boolean getFileDeletionEnabled() {
        return this.mFileDeletionEnabled;
    }

    public void objectRefactored(RefactoringHistoryEntryImpl historyEntry) {
        DevelopmentObjectProxy lObject = (DevelopmentObjectProxy)historyEntry.getObject();
        if (lObject.isMDO()) {
            this.mdoRefactored((MDORefactoringHistoryEntryImpl)historyEntry);
        }
        this.mRefactoredProxies.add(lObject);
    }

    private void clearRefactoringHistories() {
        Iterator it = this.mRefactoredProxies.iterator();
        while (it.hasNext()) {
            ((DevelopmentObjectProxy)it.next()).initializeRefactoringHistory();
        }
        this.mRefactoredProxies.clear();
    }

    private void existingMDOReplacedByRefactoring(CoreMainDevelopmentObject mdo) {
        String lKey = ((ForeignReference)((DevelopmentObjectProxy)((Object)mdo)).getKey()).toLowerString();
        if (mdo instanceof MetamodelDocument) {
            this.mDocumentsReplacedByRefactoring.put(lKey, mdo);
        } else {
            this.mMDOsReplacedByRefactoring.put(lKey, mdo);
        }
        this.mMDOWriteSet.remove(mdo);
        TextPoolProxy lTextPool = (TextPoolProxy)this.mAllTextPools.get(lKey);
        if (lTextPool != null) {
            if (mdo instanceof MetamodelDocument) {
                this.mDocumentTextPoolsReplacedByRefactoring.put(lKey, lTextPool);
            } else {
                this.mTextPoolsReplacedByRefactoring.put(lKey, lTextPool);
            }
            this.mAllTextPools.remove(lKey);
            this.mTextPoolWriteSet.remove(lTextPool);
        }
    }

    private void mdoRefactored(MDORefactoringHistoryEntryImpl historyEntry) {
        DevelopmentObjectProxy lMDO = (DevelopmentObjectProxy)historyEntry.getObject();
        String lOldKey = ((ForeignReference)historyEntry.getKey()).toLowerString();
        String lNewKey = ((ForeignReference)lMDO.getKey()).toLowerString();
        DevelopmentObjectProxy lObject = (DevelopmentObjectProxy)this.mAllMDOInstances.get(lNewKey);
        if (lObject != null && lObject._getDataState() == DataState.DELETED) {
            this.existingMDOReplacedByRefactoring((CoreMainDevelopmentObject)((Object)lObject));
        }
        this.mAllMDOInstances.remove(lOldKey);
        this.mAllMDOInstances.put(lNewKey, lMDO);
        TextPoolProxy lTextPool = (TextPoolProxy)this.mAllTextPools.get(lOldKey);
        if (lTextPool != null) {
            this.mAllTextPools.remove(lOldKey);
            this.mAllTextPools.put(lNewKey, lTextPool);
        }
        if (lMDO._getDataState() == DataState.MODIFIED) {
            if (lMDO instanceof MetamodelDocument) {
                this.mRefactoredDocuments.add(0, historyEntry);
            } else {
                this.mRefactoredMDOs.add(0, historyEntry);
            }
        }
    }

    public boolean isMDORefactored(DevelopmentObjectKey key) {
        int i = this.mRefactoredMDOs.size() - 1;
        while (i >= 0) {
            MDORefactoringHistoryEntryImpl lHistoryEntry = (MDORefactoringHistoryEntryImpl)this.mRefactoredMDOs.get(i);
            if (lHistoryEntry.getKey().equals(key)) {
                return true;
            }
            --i;
        }
        int i2 = this.mRefactoredDocuments.size() - 1;
        while (i2 >= 0) {
            MDORefactoringHistoryEntryImpl lHistoryEntry = (MDORefactoringHistoryEntryImpl)this.mRefactoredDocuments.get(i2);
            if (lHistoryEntry.getKey().equals(key)) {
                return true;
            }
            --i2;
        }
        return false;
    }

    public void addMDOToWriteSet(CoreMainDevelopmentObject mdo) {
        this.mMDOWriteSet.add(mdo);
    }

    public void addTextPoolToWriteSet(TextPoolProxy textpool) {
        this.mTextPoolWriteSet.add(textpool);
    }

    public void invalidateAllProxies() {
        Iterator it = this.mAllMDOInstances.values().iterator();
        while (it.hasNext()) {
            ((DevelopmentObjectProxy)it.next())._invalidate();
        }
        Iterator it2 = this.mAllTextPools.values().iterator();
        while (it2.hasNext()) {
            ((TextPoolProxy)it2.next())._invalidate();
        }
    }

    public void allArchivesRemoved() {
        HashSet<Root> lRootsToRefresh = new HashSet<Root>();
        Iterator it = this.mAllMDOInstances.values().iterator();
        while (it.hasNext()) {
            DevelopmentObjectProxy lMDO = (DevelopmentObjectProxy)it.next();
            if (!lMDO.originatesInArchive()) continue;
            lRootsToRefresh.add(lMDO.getRoot());
            String lKey = ((ForeignReference)lMDO._getKey()).toLowerString();
            TextPoolProxy lTextPool = (TextPoolProxy)this.mAllTextPools.get(lKey);
            if (lTextPool != null) {
                lTextPool._invalidate();
            }
            lMDO._invalidate();
            this.mAllTextPools.remove(((ForeignReference)lMDO._getKey()).toLowerString());
            it.remove();
        }
        try {
            Iterator it2 = lRootsToRefresh.iterator();
            while (it2.hasNext()) {
                ((Root)it2.next()).rescanRootMDOs();
            }
        }
        catch (LoadException loadException) {
            // empty catch block
        }
    }

    public void archiveRemoved(String archivePath) {
        HashSet<Root> lRootsToRefresh = new HashSet<Root>();
        String lPath = new File(archivePath).getAbsolutePath();
        Iterator it = this.mAllMDOInstances.values().iterator();
        while (it.hasNext()) {
            DevelopmentObjectProxy lMDO = (DevelopmentObjectProxy)it.next();
            if (!new File(lMDO.getArchivePath()).getAbsolutePath().equalsIgnoreCase(lPath)) continue;
            lRootsToRefresh.add(lMDO.getRoot());
            String lKey = ((ForeignReference)lMDO._getKey()).toLowerString();
            TextPoolProxy lTextPool = (TextPoolProxy)this.mAllTextPools.get(lKey);
            if (lTextPool != null) {
                lTextPool._invalidate();
            }
            lMDO._invalidate();
            this.mAllTextPools.remove(((ForeignReference)lMDO._getKey()).toLowerString());
            it.remove();
        }
        try {
            Iterator it2 = lRootsToRefresh.iterator();
            while (it2.hasNext()) {
                ((Root)it2.next()).rescanRootMDOs();
            }
        }
        catch (LoadException ex) {
            // empty catch block
        }
    }

    public void setDirty(boolean dirty) {
        this.mMetamodelNotificationService.setDirty(dirty);
    }

    public void refresh() {
        Iterator it = this.mAllMDOInstances.values().iterator();
        while (it.hasNext()) {
            DevelopmentObjectProxy lObject = (DevelopmentObjectProxy)it.next();
            CoreMainDevelopmentObject lMDO = (CoreMainDevelopmentObject)((Object)lObject);
            String lKey = ((ForeignReference)lObject._getKey()).toLowerString();
            TextPoolProxy lTextPool = (TextPoolProxy)this.mAllTextPools.get(lKey);
            if (lObject._getDataState() == DataState.SYNCED) {
                lObject._dropState();
            }
            lMDO._checkExistence();
            if (!lObject.isValid()) {
                if (lTextPool != null) {
                    lTextPool._invalidate();
                    this.mAllTextPools.remove(lKey);
                }
                lObject._setDataState(DataState.INVALID);
                it.remove();
                continue;
            }
            if (lTextPool == null) continue;
            lTextPool._dropState();
        }
        this.clearKeyCache();
    }

    public void clear() {
        this.invalidateAllProxies();
        this.mAllKeyedNonMDOs.clear();
        this.mAllMDOInstances.clear();
        this.mAllTextPools.clear();
        this.mDocumentsReplacedByRefactoring.clear();
        this.mDocumentTextPoolsReplacedByRefactoring.clear();
        this.mMDOsReplacedByRefactoring.clear();
        this.mMDOWriteSet.clear();
        this.mRefactoredDocuments.clear();
        this.mRefactoredMDOs.clear();
        this.mRefactoredProxies.clear();
        this.mReplacedDocuments.clear();
        this.mReplacedDocumentTextPools.clear();
        this.mReplacedMDOs.clear();
        this.mReplacedTextPools.clear();
        this.mTextPoolsReplacedByRefactoring.clear();
        this.mTextPoolWriteSet.clear();
        this.mMetamodelNotificationService.setDirty(false);
    }
}

