/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.core.service;

import com.sap.ide.metamodel.general.MDOEnum;
import com.sap.ide.metamodel.general.MDOLocation;
import com.sap.ide.metamodel.general.MDOLocator;
import com.sap.ide.metamodel.general.RootMDOEnum;
import com.sap.ide.metamodel.general.SourcePathIdentifier;
import com.sap.ide.metamodel.general.exception.MetamodelException;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Vector;

public class MultipleRootPathMDOLocator
implements MDOLocator {
    private static final Location sLocation = Location.getLocation((String)"com.sap.ide.metamodel.core.service.MultipleRootPathMDOLocator");
    private static final Category sCategoryInitialization = Category.getCategory((String)"/MetamodelCore/Initialization");
    private String mDefaultSourcePath;
    private Vector mAdditionalSourcePaths = new Vector();
    private FilenameFilter mFilter = null;

    private MultipleRootPathMDOLocator() {
    }

    public MultipleRootPathMDOLocator(String defaultSourcePath, String[] additionalSourcePaths) throws MetamodelException {
        String method = "constructor()";
        if (defaultSourcePath == null || !new File(defaultSourcePath).isDirectory()) {
            sCategoryInitialization.fatalT(sLocation, "constructor()", "default source path \"" + defaultSourcePath + "\" is not a valid directory");
            throw new MetamodelException("Default source path \"" + defaultSourcePath + "\" is not a valid directory");
        }
        int i = 0;
        while (i < additionalSourcePaths.length) {
            if (additionalSourcePaths[i] == null || !new File(additionalSourcePaths[i]).isDirectory()) {
                sCategoryInitialization.fatalT(sLocation, "constructor()", "additional source path \"" + additionalSourcePaths[i] + "\" is not a valid directory");
                throw new MetamodelException("Additional source path \"" + additionalSourcePaths[i] + "\" is not a valid directory");
            }
            ++i;
        }
        this.mDefaultSourcePath = new File(defaultSourcePath).getAbsolutePath();
        int i2 = 0;
        while (i2 < additionalSourcePaths.length) {
            this.mAdditionalSourcePaths.add(new File(additionalSourcePaths[i2]).getAbsolutePath());
            ++i2;
        }
        sCategoryInitialization.infoT(sLocation, "constructor()", "default source path: " + this.mDefaultSourcePath + ", additional source paths: " + this.mAdditionalSourcePaths);
    }

    public String getMDOPath(String mdoPackage, String mdoName, MDOEnum mdoType) {
        String lDefaultPath;
        String lRelativePath = mdoName + "." + mdoType.getFileExtension();
        if (mdoPackage != null && mdoPackage.length() > 0) {
            lRelativePath = mdoPackage.replace('.', File.separatorChar) + File.separator + lRelativePath;
        }
        if (new File(lDefaultPath = this.mDefaultSourcePath + File.separator + lRelativePath).exists()) {
            return lDefaultPath;
        }
        int i = 0;
        while (i < this.mAdditionalSourcePaths.size()) {
            String lPath = this.mAdditionalSourcePaths.get(i) + File.separator + lRelativePath;
            if (new File(lPath).exists()) {
                return lPath;
            }
            ++i;
        }
        return null;
    }

    public String[] getRootMDOPaths(String mdoPackage, RootMDOEnum rootMDOType) {
        int i;
        final String lExtension = "." + rootMDOType.getFileExtension();
        FilenameFilter lFilter = new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(lExtension);
            }
        };
        Vector<String> lVector = new Vector<String>();
        String lPath = this.mDefaultSourcePath + File.separator + mdoPackage.replace('.', File.separatorChar);
        File[] lFiles = new File(lPath).listFiles(lFilter);
        if (lFiles != null) {
            i = 0;
            while (i < lFiles.length) {
                String lName = lFiles[i].getAbsolutePath();
                lVector.add(lName);
                ++i;
            }
        }
        i = 0;
        while (i < this.mAdditionalSourcePaths.size()) {
            lPath = this.mAdditionalSourcePaths.get(i) + File.separator + mdoPackage.replace('.', File.separatorChar);
            lFiles = new File(lPath).listFiles(lFilter);
            if (lFiles != null) {
                lVector = new Vector();
                int j = 0;
                while (j < lFiles.length) {
                    String lName = lFiles[j].getAbsolutePath();
                    lVector.add(lName);
                    ++j;
                }
            }
            ++i;
        }
        return lVector.toArray(new String[0]);
    }

    public MDOLocation[] getRootMDOLocations(RootMDOEnum rootMDOType) {
        final String lExtension = "." + rootMDOType.getFileExtension();
        this.mFilter = new FilenameFilter(){

            public boolean accept(File dir, String name) {
                if (new File(dir, name).isDirectory()) {
                    return true;
                }
                if (name != null) {
                    return name.endsWith(lExtension);
                }
                return false;
            }
        };
        Vector lVector = new Vector();
        this.doRecursion(this.mDefaultSourcePath, this.mDefaultSourcePath, lVector);
        int i = 0;
        while (i < this.mAdditionalSourcePaths.size()) {
            String lAdditionalSourcePath = (String)this.mAdditionalSourcePaths.get(i);
            this.doRecursion(lAdditionalSourcePath, lAdditionalSourcePath, lVector);
            ++i;
        }
        return lVector.toArray(new MDOLocation[0]);
    }

    public String getSourcePath() {
        return this.mDefaultSourcePath;
    }

    public String getSourcePath(SourcePathIdentifier identifier) {
        return this.mDefaultSourcePath;
    }

    private void doRecursion(String sourcePath, String name, Vector result) {
        File f = new File(name);
        if (f.isFile()) {
            String lParentFolder = f.getParent();
            String lPackage = "";
            if (!lParentFolder.equals(sourcePath)) {
                lPackage = lParentFolder.substring(sourcePath.length() + 1).replace(File.separatorChar, '.');
            }
            result.add(new MDOLocation(f.getAbsolutePath(), lPackage));
        } else if (f.isDirectory()) {
            String[] lObjects = f.list(this.mFilter);
            int i = 0;
            while (i < lObjects.length) {
                this.doRecursion(sourcePath, name + File.separator + lObjects[i], result);
                ++i;
            }
        }
    }
}

