/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.core.service;

import com.sap.ide.metamodel.core.CoreMainDevelopmentObject;
import com.sap.ide.metamodel.core.DevelopmentObjectProxy;
import com.sap.ide.metamodel.core.RootImpl;
import com.sap.ide.metamodel.core.i18n.TextPoolProxy;
import com.sap.ide.metamodel.core.marshalling.Marshaller;
import com.sap.ide.metamodel.core.service.LoggingService;
import com.sap.ide.metamodel.general.MDOEnum;
import com.sap.ide.metamodel.general.MDOLocator;
import com.sap.ide.metamodel.general.MetamodelIterator;
import com.sap.ide.metamodel.general.SourcePathIdentifier;
import com.sap.ide.metamodel.general.exception.DeleteException;
import com.sap.ide.metamodel.general.exception.SaveException;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.io.File;
import java.io.OutputStreamWriter;
import java.net.JarURLConnection;
import java.net.URL;

public class FileSystemService {
    private static final Location sLocation = Location.getLocation((String)"com.sap.ide.metamodel.core.service.FileSystemService");
    private static final Category sCategoryFileSystem = Category.getCategory((String)"/MetamodelCore/FileSystem");
    private static final Category sCategoryArchiveAccess = Category.getCategory((String)"/MetamodelCore/ArchiveAccess");
    private static final Category sCategoryMDOLocating = Category.getCategory((String)"/MetamodelCore/MDOLocating");
    private static final int MAXLENGTH_ABSOLUTE_PATH = 249;
    private static FileSystemService sInstance = null;

    private FileSystemService() {
    }

    public static FileSystemService getInstance() {
        if (sInstance == null) {
            sInstance = new FileSystemService();
        }
        return sInstance;
    }

    public String computeAbsolutePath(MDOLocator mdoLocator, String mdoPackage, String mdoName, MDOEnum mdoType, SourcePathIdentifier sourcePathIdentifier) {
        return this.computeAbsolutePathInternal(mdoLocator, mdoPackage, mdoName, mdoType, sourcePathIdentifier, true);
    }

    public String computeAbsolutePathNoLogging(MDOLocator mdoLocator, String mdoPackage, String mdoName, MDOEnum mdoType, SourcePathIdentifier sourcePathIdentifier) {
        return this.computeAbsolutePathInternal(mdoLocator, mdoPackage, mdoName, mdoType, sourcePathIdentifier, false);
    }

    private String computeAbsolutePathInternal(MDOLocator mdoLocator, String mdoPackage, String mdoName, MDOEnum mdoType, SourcePathIdentifier sourcePathIdentifier, boolean logging) {
        String lAbsolutePath;
        block7: {
            String method = "computeAbsolutePath()";
            lAbsolutePath = null;
            try {
                lAbsolutePath = sourcePathIdentifier != null ? mdoLocator.getSourcePath(sourcePathIdentifier) : mdoLocator.getSourcePath();
            }
            catch (Throwable t) {
                if (!logging) break block7;
                LoggingService.getInstance().logException(t, sLocation, sCategoryMDOLocating, "computeAbsolutePath()", "MDOLocator " + mdoLocator + " threw exception: ");
            }
        }
        if (lAbsolutePath == null) {
            if (logging) {
                sCategoryMDOLocating.errorT(sLocation, "computeAbsolutePath()", "MDOLocator failed to provide source path for " + mdoType + " " + mdoPackage + "." + mdoName);
            }
            return null;
        }
        if ((lAbsolutePath = this.buildMDOPath(lAbsolutePath, mdoPackage, mdoName, mdoType)).length() > 249) {
            if (logging) {
                sCategoryMDOLocating.errorT(sLocation, "computeAbsolutePath()", "absolute path too long (" + lAbsolutePath.length() + ") for MDO: ");
            }
            return null;
        }
        if (logging) {
            sCategoryMDOLocating.infoT(sLocation, "computeAbsolutePath()", "MDOLocator provided source path " + lAbsolutePath + " for " + mdoType + " " + mdoPackage + "." + mdoName);
        }
        return lAbsolutePath;
    }

    public boolean fileExists(String path) {
        String method = "fileExists()";
        if (path == null) {
            return false;
        }
        if (path.length() == 0) {
            return false;
        }
        if (path.startsWith("jar:")) {
            try {
                URL lUrl = new URL(path);
                JarURLConnection lConnection = (JarURLConnection)lUrl.openConnection();
                lConnection.setUseCaches(false);
                return lConnection.getJarEntry() != null;
            }
            catch (Exception ex) {
                sCategoryArchiveAccess.errorT(sLocation, "fileExists()", "error accessing archive " + path + ": " + ex.getMessage());
                return false;
            }
        }
        return new File(path).exists();
    }

    public boolean isReadOnly(String path) {
        if (path.startsWith("jar:")) {
            return true;
        }
        File lFile = new File(path);
        return lFile.exists() && !lFile.canWrite();
    }

    public String getMDOName(String path) {
        String lFileName = null;
        lFileName = path.startsWith("jar:") ? path.substring(path.lastIndexOf(47) + 1) : new File(path).getName();
        return lFileName.substring(0, lFileName.indexOf(46));
    }

    public void exportToFilesystem(CoreMainDevelopmentObject mdo, String sourcePath) throws SaveException {
        DevelopmentObjectProxy lMDO = (DevelopmentObjectProxy)((Object)mdo);
        Marshaller lMarshaller = ((RootImpl)lMDO.getRoot()).getMarshaller();
        MetamodelIterator it = lMDO.iterator();
        while (it.hasNext()) {
            DevelopmentObjectProxy lProxy = (DevelopmentObjectProxy)it.next();
            if (!lProxy.isMDO()) continue;
            String lPath = this.buildMDOPath(sourcePath, ((CoreMainDevelopmentObject)((Object)lProxy)).getPackage(), lProxy.getName(), (MDOEnum)lProxy.getDevelopmentObjectEnum());
            lMarshaller.marshal(lProxy._getState(), lPath);
            TextPoolProxy lTextPool = (TextPoolProxy)((CoreMainDevelopmentObject)((Object)lProxy)).getTextPool();
            if (lTextPool.isEmpty()) continue;
            lTextPool.exportToFilesystem(lPath);
        }
    }

    public void exportToWriter(CoreMainDevelopmentObject mdo, OutputStreamWriter writer) throws SaveException {
        String method = "exportToWriter()";
        String lMessage = null;
        if (writer == null) {
            lMessage = "OutputStreamWriter is null";
        } else if (!writer.getEncoding().equals("UTF8")) {
            lMessage = "exportToWriter() requires an OutputStreamWriter with encoding \"UTF-8\"";
        }
        if (lMessage != null) {
            sCategoryFileSystem.errorT(sLocation, "exportToWriter()", lMessage);
            throw new SaveException(this.exceptionMessage(lMessage));
        }
        DevelopmentObjectProxy lMDO = (DevelopmentObjectProxy)((Object)mdo);
        Marshaller lMarshaller = ((RootImpl)lMDO.getRoot()).getMarshaller();
        lMarshaller.marshal(lMDO._getState(), writer);
    }

    public void delete(String path) throws DeleteException {
        String method = "delete()";
        if (!new File(path).exists()) {
            sCategoryFileSystem.errorT(sLocation, "delete()", "attempt to delete non-existing file " + path);
            return;
        }
        try {
            new File(path).delete();
        }
        catch (Exception ex) {
            sCategoryFileSystem.errorT(sLocation, "delete()", "error deleting " + path + ": " + ex.getMessage());
            throw new DeleteException(ex);
        }
        sCategoryFileSystem.infoT(sLocation, "delete()", "deleted file " + path);
    }

    private String buildMDOPath(String sourcePath, String mdoPackage, String mdoName, MDOEnum mdoType) {
        String lFullPath = sourcePath;
        String lPackagePart = mdoPackage;
        if (lPackagePart.length() > 0) {
            lPackagePart = lPackagePart.replace('.', File.separatorChar);
            lFullPath = lFullPath + File.separatorChar + lPackagePart;
        }
        lFullPath = lFullPath + File.separatorChar + mdoName + "." + mdoType.getFileExtension();
        return lFullPath;
    }

    private String exceptionMessage(String message) {
        return message.substring(0, 1).toUpperCase() + message.substring(1) + "!";
    }
}

