/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.core.refactoring;

import com.sap.ide.metamodel.core.ForeignReference;
import com.sap.ide.metamodel.core.Reference;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class RefactoringService {
    private HashMap mMap = new HashMap();
    private HashSet mOriginalReferences = new HashSet();

    public void add(Reference oldReference, Reference newReference) {
        this.mMap.put(oldReference.toReferenceString(), newReference);
        this.mOriginalReferences.add(oldReference);
    }

    public boolean isEmpty() {
        return this.mMap.isEmpty();
    }

    public void clear() {
        this.mMap.clear();
        this.mOriginalReferences.clear();
    }

    public Set keySet() {
        return this.mOriginalReferences;
    }

    public Reference refactor(Reference reference) {
        String lMDOPackage = reference.getMDOPackage();
        String lMDOName = reference.getMDOName();
        String lPath = reference.getPath();
        Reference lNewRef = (Reference)this.mMap.get(reference.toMDOString());
        if (lNewRef != null) {
            lMDOPackage = lNewRef.getMDOPackage();
            lMDOName = lNewRef.getMDOName();
        } else {
            String lPathToCheck = lPath;
            String lMDOString = reference.toMDOString() + "/";
            while (!lPathToCheck.equals("")) {
                Reference lRef = (Reference)this.mMap.get(lMDOString + lPathToCheck);
                if (!(lRef == null || lRef.getMDOPackage().equals(lMDOPackage) && lRef.getMDOName().equals(lMDOName))) {
                    lMDOPackage = lRef.getMDOPackage();
                    lMDOName = lRef.getMDOName();
                    break;
                }
                lPathToCheck = this.allButLastSegment(lPathToCheck);
            }
        }
        if (!reference.refersToMDO()) {
            lPath = this.refactorPath(reference, lPath);
        }
        if (reference instanceof ForeignReference) {
            return new ForeignReference(((ForeignReference)reference).getModelName(), lMDOPackage, lMDOName, reference.getMDOType(), lPath);
        }
        return new Reference(lMDOPackage, lMDOName, reference.getMDOType(), lPath);
    }

    private String allButLastSegment(String path) {
        if (path.indexOf(47) == -1) {
            return "";
        }
        return path.substring(0, path.lastIndexOf(47));
    }

    private String lastSegment(String path) {
        if (path.indexOf(47) == -1) {
            return path;
        }
        return path.substring(path.lastIndexOf(47) + 1);
    }

    private String refactorPath(Reference reference, String path) {
        String lOldPath = null;
        String lNewPath = null;
        HashMap lMap = (HashMap)this.mMap.clone();
        Reference lRef = (Reference)lMap.get(reference.toReferenceString());
        if (lRef != null) {
            lOldPath = this.allButLastSegment(lRef.getPath());
            lNewPath = this.lastSegment(lRef.getPath());
            lMap.values().remove(lRef);
        } else {
            lOldPath = this.allButLastSegment(path);
            lNewPath = this.lastSegment(path);
        }
        String lMDOString = reference.toMDOString() + "/";
        while (!lOldPath.equals("")) {
            lRef = (Reference)lMap.get(lMDOString + lOldPath);
            if (lRef != null) {
                lNewPath = this.lastSegment(lRef.getPath()) + "/" + lNewPath;
                lOldPath = this.allButLastSegment(lRef.getPath());
                lMap.values().remove(lRef);
                continue;
            }
            lNewPath = this.lastSegment(lOldPath) + "/" + lNewPath;
            lOldPath = this.allButLastSegment(lOldPath);
        }
        return lNewPath;
    }
}

