/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.core.refactoring;

import com.sap.ide.metamodel.Metamodel;
import com.sap.ide.metamodel.core.CoreMainDevelopmentObject;
import com.sap.ide.metamodel.core.DevelopmentObjectProxy;
import com.sap.ide.metamodel.core.ForeignReference;
import com.sap.ide.metamodel.core.Reference;
import com.sap.ide.metamodel.core.RootImpl;
import com.sap.ide.metamodel.core.i18n.TextPoolProxy;
import com.sap.ide.metamodel.core.refactoring.MDORefactoringTaskImpl;
import com.sap.ide.metamodel.core.refactoring.RefactoringItemImpl;
import com.sap.ide.metamodel.core.refactoring.RefactoringService;
import com.sap.ide.metamodel.core.refactoring.RefactoringTaskImpl;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.ide.metamodel.general.MetamodelIterator;
import com.sap.ide.metamodel.general.Root;
import com.sap.ide.metamodel.general.exception.ObjectInvalidException;
import com.sap.ide.metamodel.general.exception.RefactoringException;
import com.sap.ide.metamodel.general.refactoring.MDORefactoringTask;
import com.sap.ide.metamodel.general.refactoring.RefactoringItem;
import com.sap.ide.metamodel.general.refactoring.RefactoringRequest;
import com.sap.ide.metamodel.general.refactoring.RefactoringTask;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;

public class RefactoringRequestImpl
implements RefactoringRequest {
    private static final Location sLocation = Location.getLocation((String)"com.sap.ide.metamodel.core.refactoring.RefactoringRequestImpl");
    private static final Category sCategoryRefactoring = Category.getCategory((String)"/MetamodelCore/Refactoring");
    private static final Category sCategoryObjectAccess = Category.getCategory((String)"/MetamodelCore/ObjectAccess");
    private HashMap mRefactoringTasks;
    private HashSet mRefactoringScope;
    private Metamodel mMetamodel;
    private HashMap mAffectedMDOs;
    private HashMap mProxiesToRefactorPerMDO;
    private RefactoringService mRefactoringService;
    private boolean mRecomputeAffectedMDOs;
    private boolean mIsValid;

    public RefactoringRequestImpl(Metamodel metamodel) {
        this.mMetamodel = metamodel;
        this.mRefactoringTasks = new HashMap();
        this.mRefactoringScope = new HashSet();
        this.mAffectedMDOs = new HashMap();
        this.mProxiesToRefactorPerMDO = new HashMap();
        this.mRecomputeAffectedMDOs = false;
        this.mRefactoringService = new RefactoringService();
        this.mIsValid = true;
    }

    public RefactoringTask createRefactoringTask(DevelopmentObject object) {
        this._prepareForAccess();
        String method = "createRefactoringTask()";
        if (object == null) {
            String lMessage = "object to refactor is null";
            sCategoryRefactoring.errorT(sLocation, "createRefactoringTask()", lMessage);
            throw new IllegalArgumentException(this.exceptionMessage(lMessage));
        }
        if (!((DevelopmentObjectProxy)object)._isValid()) {
            String lMessage = "object to refactor is not valid: " + ((DevelopmentObjectProxy)object)._getKey();
            sCategoryRefactoring.errorT(sLocation, "createRefactoringTask()", lMessage);
            throw new IllegalArgumentException(this.exceptionMessage(lMessage));
        }
        if (object.originatesInArchive()) {
            String lMessage = "objects from archives cannot be refactored: " + ((DevelopmentObjectProxy)object)._getKey();
            sCategoryRefactoring.errorT(sLocation, "createRefactoringTask()", lMessage);
            throw new IllegalArgumentException(this.exceptionMessage(lMessage));
        }
        if (object.getMetamodel() != this.mMetamodel) {
            String lMessage = "all objects to refactor must belong to the metamodel that was used when creating the request";
            sCategoryRefactoring.errorT(sLocation, "createRefactoringTask()", lMessage);
            throw new IllegalArgumentException(this.exceptionMessage(lMessage));
        }
        RefactoringTaskImpl lTask = (RefactoringTaskImpl)this.mRefactoringTasks.get(object);
        if (lTask == null) {
            DevelopmentObject lParent;
            lTask = object instanceof CoreMainDevelopmentObject ? new MDORefactoringTaskImpl(this, (DevelopmentObjectProxy)object) : new RefactoringTaskImpl(this, (DevelopmentObjectProxy)object);
            this.mRefactoringTasks.put(object, lTask);
            this.mRefactoringScope.addAll(this.expandMDO(object.getMDO()));
            if (object instanceof CoreMainDevelopmentObject && (lParent = object.getParent()) != null) {
                this.mRefactoringScope.add(lParent.getMDO());
            }
            this.mRecomputeAffectedMDOs = true;
            sCategoryRefactoring.infoT(sLocation, "createRefactoringTask()", "created refactoring task for object: " + ((DevelopmentObjectProxy)object)._getKey());
        }
        return lTask;
    }

    public RefactoringTask[] getRefactoringTasks() {
        this._prepareForAccess();
        return this.mRefactoringTasks.values().toArray(new RefactoringTask[0]);
    }

    public void addToRefactoringScope(MainDevelopmentObject mdo) {
        this._prepareForAccess();
        this.addToRefactoringScope(new MainDevelopmentObject[]{mdo});
    }

    public void addToRefactoringScope(MainDevelopmentObject[] mdos) {
        this._prepareForAccess();
        String method = "addToRefactoringScope(MainDevelopmentObject[])";
        if (mdos == null) {
            String lMessage = "refactoring scope array is null";
            sCategoryRefactoring.errorT(sLocation, "addToRefactoringScope(MainDevelopmentObject[])", lMessage);
            throw new IllegalArgumentException(this.exceptionMessage(lMessage));
        }
        int lSize = this.mRefactoringScope.size();
        int i = 0;
        while (i < mdos.length) {
            MainDevelopmentObject lMDO = mdos[i];
            if (lMDO != null) {
                if (lMDO.originatesInArchive()) {
                    sCategoryRefactoring.warningT(sLocation, "addToRefactoringScope(MainDevelopmentObject[])", "objects from archives cannot be part of the refactoring scope: " + ((DevelopmentObjectProxy)((Object)lMDO))._getKey());
                } else {
                    this.mRefactoringScope.addAll(this.expandMDO(mdos[i]));
                }
            }
            ++i;
        }
        if (this.mRefactoringScope.size() != lSize) {
            sCategoryRefactoring.infoT(sLocation, "addToRefactoringScope(MainDevelopmentObject[])", "refactoring scope has changed (now " + this.mRefactoringScope.size() + " MDO(s) in scope)");
            this.mRecomputeAffectedMDOs = true;
        }
    }

    public void addToRefactoringScope(Root root) {
        this._prepareForAccess();
        this.addToRefactoringScope(new Root[]{root});
    }

    public void addToRefactoringScope(Root[] roots) {
        this._prepareForAccess();
        String method = "addToRefactoringScope(Root[])";
        if (roots == null) {
            String lMessage = "refactoring scope array is null";
            sCategoryRefactoring.errorT(sLocation, "addToRefactoringScope(Root[])", lMessage);
            throw new IllegalArgumentException(this.exceptionMessage(lMessage));
        }
        int lSize = this.mRefactoringScope.size();
        int i = 0;
        while (i < roots.length) {
            RootImpl lRoot = (RootImpl)roots[i];
            if (lRoot != null) {
                this.mRefactoringScope.addAll(this.expandRoot(roots[i]));
            }
            ++i;
        }
        if (this.mRefactoringScope.size() != lSize) {
            sCategoryRefactoring.infoT(sLocation, "addToRefactoringScope(Root[])", "refactoring scope has changed (now " + this.mRefactoringScope.size() + " MDO(s) in scope)");
            this.mRecomputeAffectedMDOs = true;
        }
    }

    public void minimizeRefactoringScope() {
        this._prepareForAccess();
        this.mRefactoringScope.clear();
        Iterator it = this.mRefactoringTasks.values().iterator();
        while (it.hasNext()) {
            DevelopmentObject lParent;
            RefactoringTaskImpl lTask = (RefactoringTaskImpl)it.next();
            DevelopmentObject lObject = lTask.getObjectToRefactor();
            this.mRefactoringScope.addAll(this.expandMDO(lObject.getMDO()));
            if (lObject instanceof CoreMainDevelopmentObject && (lParent = lObject.getParent()) != null) {
                this.mRefactoringScope.add(lParent.getMDO());
            }
            if (lTask.getNewParent() == null) continue;
            this.mRefactoringScope.add(lTask.getNewParent().getMDO());
        }
        this.mRecomputeAffectedMDOs = true;
    }

    public void maximizeRefactoringScope() {
        this._prepareForAccess();
        this.mRefactoringScope.clear();
        Root[] lRoots = this.mMetamodel.getRoots();
        int i = 0;
        while (i < lRoots.length) {
            this.mRefactoringScope.addAll(this.expandRoot(lRoots[i]));
            ++i;
        }
        this.mRecomputeAffectedMDOs = true;
    }

    public MainDevelopmentObject[] getRefactoringScope() {
        this._prepareForAccess();
        return ((AbstractCollection)this.mRefactoringScope).toArray(new MainDevelopmentObject[0]);
    }

    public RefactoringItem[] getAffectedMDOs() {
        this._prepareForAccess();
        if (this.mRecomputeAffectedMDOs) {
            this.initializeRefactoringService();
            this.scanRefactoringScope();
            this.mRecomputeAffectedMDOs = false;
        }
        return this.mAffectedMDOs.values().toArray(new RefactoringItem[0]);
    }

    public void execute() throws RefactoringException {
        this._prepareForAccess();
        String method = "execute()";
        int modifiedTasks = 0;
        Iterator it = this.mRefactoringTasks.values().iterator();
        while (it.hasNext()) {
            RefactoringTaskImpl lTask = (RefactoringTaskImpl)it.next();
            DevelopmentObjectProxy lObjectToRefactor = (DevelopmentObjectProxy)lTask.getObjectToRefactor();
            if (!lTask.isModified()) continue;
            ++modifiedTasks;
            if (!lObjectToRefactor._isValid()) {
                String lMessage = "the object to refactor is not valid any more: " + lObjectToRefactor._getKey();
                sCategoryRefactoring.fatalT(sLocation, "execute()", lMessage);
                throw new RefactoringException(this.exceptionMessage(lMessage));
            }
            if (!lTask.isConflicting()) continue;
            String lMessage = "naming conflict found for object " + lObjectToRefactor._getKey() + " (new name: \"" + lTask.getNewName() + "\"" + (lObjectToRefactor.isMDO() ? ", new package: \"" + ((MDORefactoringTask)((Object)lTask)).getNewPackage() : "") + "\"" + "), refactoring aborted";
            sCategoryRefactoring.fatalT(sLocation, "execute()", lMessage);
            throw new RefactoringException(this.exceptionMessage(lMessage));
        }
        if (modifiedTasks == 0) {
            return;
        }
        this.getAffectedMDOs();
        Metamodel metamodel = this.mMetamodel;
        synchronized (metamodel) {
            Iterator it2 = this.mAffectedMDOs.values().iterator();
            while (it2.hasNext()) {
                RefactoringItemImpl lItem = (RefactoringItemImpl)it2.next();
                DevelopmentObjectProxy lMDO = (DevelopmentObjectProxy)((Object)lItem.getMDO());
                if (lItem.isExcluded()) {
                    HashSet lProxies = (HashSet)this.mProxiesToRefactorPerMDO.get(lMDO);
                    if (lProxies == null) continue;
                    Iterator it22 = lProxies.iterator();
                    while (it22.hasNext()) {
                        ((DevelopmentObjectProxy)it22.next())._invalidateAssociations();
                    }
                    continue;
                }
                if (!lMDO.isReadOnly()) continue;
                String lMessage = "MDO is read-only, refactoring aborted: " + lMDO._getKey();
                sCategoryRefactoring.fatalT(sLocation, "execute()", lMessage);
                throw new RefactoringException(this.exceptionMessage(lMessage));
            }
            Iterator it3 = this.mAffectedMDOs.values().iterator();
            while (it3.hasNext()) {
                CoreMainDevelopmentObject lMDO;
                HashSet lProxies;
                RefactoringItemImpl lItem = (RefactoringItemImpl)it3.next();
                if (lItem.isExcluded() || (lProxies = (HashSet)this.mProxiesToRefactorPerMDO.get(lMDO = (CoreMainDevelopmentObject)((Object)lItem.getMDO()))) == null) continue;
                ((TextPoolProxy)lMDO.getTextPool()).refactorTextKeys(this.mRefactoringService);
                Iterator it23 = lProxies.iterator();
                while (it23.hasNext()) {
                    DevelopmentObjectProxy lProxy = (DevelopmentObjectProxy)it23.next();
                    lProxy._refactor((RefactoringTaskImpl)this.mRefactoringTasks.get(lProxy), this.mRefactoringService);
                }
            }
            this.invalidate();
        }
    }

    void addMDOToRefactoringScopeNoExpand(CoreMainDevelopmentObject mdo) {
        String method = "addMDOToRefactoringScopeNoExpand()";
        int lSize = this.mRefactoringScope.size();
        this.mRefactoringScope.add(mdo);
        if (this.mRefactoringScope.size() != lSize) {
            sCategoryRefactoring.infoT(sLocation, "addMDOToRefactoringScopeNoExpand()", "refactoring scope has changed (now " + this.mRefactoringScope.size() + " MDO(s) in scope)");
            this.mRecomputeAffectedMDOs = true;
        }
    }

    private ArrayList expandMDO(MainDevelopmentObject mdo) {
        ArrayList<DevelopmentObject> lResult = new ArrayList<DevelopmentObject>();
        MetamodelIterator it = mdo.iterator();
        while (it.hasNext()) {
            DevelopmentObject lObject = it.next();
            if (!lObject.isMDO()) continue;
            lResult.add(lObject);
        }
        return lResult;
    }

    private ArrayList expandRoot(Root root) {
        ArrayList lResult = new ArrayList();
        Vector lRootMDOs = ((RootImpl)root)._getAllChildren();
        Iterator it = ((AbstractList)lRootMDOs).iterator();
        while (it.hasNext()) {
            MainDevelopmentObject lMDO = (MainDevelopmentObject)it.next();
            if (((DevelopmentObjectProxy)((Object)lMDO)).originatesInArchive()) continue;
            lResult.addAll(this.expandMDO(lMDO));
        }
        return lResult;
    }

    private void initializeRefactoringService() {
        this.mRefactoringService.clear();
        Iterator it = this.mRefactoringTasks.values().iterator();
        while (it.hasNext()) {
            String lPath;
            String lLastSegment;
            Reference lNewRef;
            RefactoringTaskImpl lTask = (RefactoringTaskImpl)it.next();
            DevelopmentObjectProxy lObject = (DevelopmentObjectProxy)lTask.getObjectToRefactor();
            if (!lTask.isModified() || ((lNewRef = lTask.getRefactoredReference()).refersToMDO() ? ((MDORefactoringTaskImpl)lTask).onlyParentHasChanged() : (lLastSegment = (lPath = lNewRef.getPath()).substring(lPath.lastIndexOf(47) + 1)).indexOf(58) == -1)) continue;
            this.mRefactoringService.add((ForeignReference)lObject._getKey(), lNewRef);
        }
    }

    private RefactoringItemImpl addToAffectedMDOs(CoreMainDevelopmentObject mdo) {
        if (this.mAffectedMDOs.containsKey(mdo)) {
            return (RefactoringItemImpl)this.mAffectedMDOs.get(mdo);
        }
        RefactoringItemImpl lItem = new RefactoringItemImpl(mdo);
        this.mAffectedMDOs.put(mdo, lItem);
        return lItem;
    }

    private void scanRefactoringScope() {
        this.mAffectedMDOs.clear();
        this.mProxiesToRefactorPerMDO.clear();
        Iterator it = this.mRefactoringScope.iterator();
        while (it.hasNext()) {
            RefactoringTaskImpl lTask;
            DevelopmentObjectProxy lParent;
            CoreMainDevelopmentObject lMDO = (CoreMainDevelopmentObject)it.next();
            HashSet<Object> lProxiesToRefactor = (HashSet<Object>)this.mProxiesToRefactorPerMDO.get(lMDO);
            if (lProxiesToRefactor == null) {
                lProxiesToRefactor = new HashSet<Object>();
            }
            if ((lParent = (DevelopmentObjectProxy)((DevelopmentObjectProxy)((Object)lMDO)).getParent()) != null && this.mRefactoringTasks.keySet().contains(lParent) && (lTask = (RefactoringTaskImpl)this.mRefactoringTasks.get(lParent)).isModified()) {
                this.addToAffectedMDOs(lMDO).setRefactoringMandatory();
                lProxiesToRefactor.add(lMDO);
            }
            Iterator it3 = this.mRefactoringTasks.values().iterator();
            while (it3.hasNext()) {
                DevelopmentObject lNewParent;
                RefactoringTaskImpl lTask2 = (RefactoringTaskImpl)it3.next();
                if (!lTask2.isModified() || (lNewParent = lTask2.getNewParent()) == null || !(lNewParent instanceof DevelopmentObject) || lNewParent.getMDO() != lMDO) continue;
                this.addToAffectedMDOs(lMDO).setRefactoringMandatory();
            }
            MetamodelIterator it2 = ((DevelopmentObjectProxy)((Object)lMDO)).iterator(true, false, true);
            while (it2.hasNext()) {
                RefactoringTaskImpl lTask3;
                DevelopmentObjectProxy lProxy = (DevelopmentObjectProxy)it2.next();
                if (this.mRefactoringTasks.keySet().contains(lProxy) && (lTask3 = (RefactoringTaskImpl)this.mRefactoringTasks.get(lProxy)).isModified()) {
                    this.addToAffectedMDOs(lMDO).setRefactoringMandatory();
                    lProxiesToRefactor.add(lProxy);
                    if (lProxy == lMDO && lParent != null) {
                        this.addToAffectedMDOs(lParent._getMDO()).setRefactoringMandatory();
                        HashSet<DevelopmentObjectProxy> lParentProxies = (HashSet<DevelopmentObjectProxy>)this.mProxiesToRefactorPerMDO.get(lParent.getMDO());
                        if (lParentProxies == null) {
                            lParentProxies = new HashSet<DevelopmentObjectProxy>();
                            this.mProxiesToRefactorPerMDO.put(lParent.getMDO(), lParentProxies);
                        }
                        lParentProxies.add(lParent);
                    }
                }
                Iterator it32 = this.mRefactoringService.keySet().iterator();
                while (it32.hasNext()) {
                    if (!lProxy._getState()._hasReferencesToRefactor((Reference)it32.next())) continue;
                    this.addToAffectedMDOs(lMDO);
                    lProxiesToRefactor.add(lProxy);
                }
            }
            if (lProxiesToRefactor.isEmpty()) continue;
            this.mProxiesToRefactorPerMDO.put(lMDO, lProxiesToRefactor);
        }
    }

    private void invalidate() {
        this.mRefactoringTasks = null;
        this.mRefactoringScope = null;
        this.mAffectedMDOs = null;
        this.mProxiesToRefactorPerMDO = null;
        this.mRefactoringService = null;
        this.mIsValid = false;
    }

    private void _prepareForAccess() throws ObjectInvalidException {
        String method = "_prepareForAccess()";
        if (!this.mIsValid) {
            String lMessage = "attempt to access invalid refactoring request (already run): " + this;
            sCategoryObjectAccess.errorT(sLocation, "_prepareForAccess()", lMessage);
            throw new ObjectInvalidException(this.exceptionMessage(lMessage));
        }
    }

    private String exceptionMessage(String message) {
        return message.substring(0, 1).toUpperCase() + message.substring(1) + "!";
    }
}

