/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.core.refactoring;

import com.sap.ide.metamodel.core.CoreMainDevelopmentObject;
import com.sap.ide.metamodel.core.DevelopmentObjectProxy;
import com.sap.ide.metamodel.core.ForeignReference;
import com.sap.ide.metamodel.core.Reference;
import com.sap.ide.metamodel.core.RootImpl;
import com.sap.ide.metamodel.core.refactoring.RefactoringRequestImpl;
import com.sap.ide.metamodel.core.refactoring.RefactoringTaskImpl;
import com.sap.ide.metamodel.general.MDOEnum;
import com.sap.ide.metamodel.general.MDOLocator;
import com.sap.ide.metamodel.general.SourcePathIdentifier;
import com.sap.ide.metamodel.general.refactoring.MDORefactoringTask;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;

public class MDORefactoringTaskImpl
extends RefactoringTaskImpl
implements MDORefactoringTask {
    private static final Location sLocation = Location.getLocation((String)"com.sap.ide.metamodel.core.refactoring.MDORefactoringTaskImpl");
    private static final Category sCategoryRefactoring = Category.getCategory((String)"/MetamodelCore/Refactoring");
    private String mNewPackage = null;
    private SourcePathIdentifier mNewSourcePathIdentifier = null;

    MDORefactoringTaskImpl(RefactoringRequestImpl request, DevelopmentObjectProxy objectToRefactor) {
        super(request, objectToRefactor);
        this.mNewPackage = ((CoreMainDevelopmentObject)((Object)objectToRefactor)).getPackage();
        this.mNewSourcePathIdentifier = ((CoreMainDevelopmentObject)((Object)objectToRefactor)).getSourcePathIdentifier();
    }

    public void setNewPackage(String newPackage) {
        MDOEnum lType;
        String method = "setPackage()";
        if (newPackage != null && this.mNewPackage.equals(newPackage)) {
            return;
        }
        if (!RefactoringTaskImpl.sNamingService.isValidMainDevelopmentObjectPackage(newPackage)) {
            String lMessage = "the new package \"" + newPackage + "\" is empty or contains illegal characters";
            sCategoryRefactoring.errorT(sLocation, "setPackage()", lMessage);
            throw new IllegalArgumentException(this.exceptionMessage(lMessage));
        }
        CoreMainDevelopmentObject lMDO = (CoreMainDevelopmentObject)((Object)this.mObjectToRefactor);
        MDOLocator lMDOLocator = ((RootImpl)this.mObjectToRefactor.getRoot())._getMDOLocator();
        String lAbsolutePath = RefactoringTaskImpl.sFileSystemService.computeAbsolutePath(lMDOLocator, newPackage, this.mNewName, lType = (MDOEnum)this.mObjectToRefactor.getDevelopmentObjectEnum(), this.mNewSourcePathIdentifier);
        if (lAbsolutePath == null) {
            String lMessage = "could not get a valid path for " + lType + " \"" + newPackage + "." + this.mNewName + "\" (path too long?)";
            sCategoryRefactoring.errorT(sLocation, "setPackage()", lMessage);
            throw new IllegalArgumentException(this.exceptionMessage(lMessage));
        }
        this.mNewPackage = newPackage;
    }

    public String getNewPackage() {
        return this.mNewPackage;
    }

    public void setNewSourcePathIdentifier(SourcePathIdentifier newSourcePathIdentifier) {
        String method = "setNewSourcePathIdentifier()";
        CoreMainDevelopmentObject lMDO = (CoreMainDevelopmentObject)((Object)this.mObjectToRefactor);
        MDOLocator lMDOLocator = ((RootImpl)this.mObjectToRefactor.getRoot())._getMDOLocator();
        String lPackage = this.getNewPackage();
        MDOEnum lType = (MDOEnum)this.mObjectToRefactor.getDevelopmentObjectEnum();
        String lAbsolutePath = RefactoringTaskImpl.sFileSystemService.computeAbsolutePath(lMDOLocator, this.mNewPackage, this.mNewName, lType, newSourcePathIdentifier);
        if (lAbsolutePath == null) {
            String lMessage = "could not get a valid path for " + lType + " \"" + this.mNewPackage + "." + this.mNewName + "\" (path too long?)";
            sCategoryRefactoring.errorT(sLocation, "setNewSourcePathIdentifier()", lMessage);
            throw new IllegalArgumentException(this.exceptionMessage(lMessage));
        }
        this.mNewSourcePathIdentifier = newSourcePathIdentifier;
    }

    public SourcePathIdentifier getNewSourcePathIdentifier() {
        return this.mNewSourcePathIdentifier;
    }

    public boolean isModified() {
        return super.isModified() || !this.mNewPackage.equals(((CoreMainDevelopmentObject)((Object)this.mObjectToRefactor)).getPackage());
    }

    public boolean onlyParentHasChanged() {
        return super.onlyParentHasChanged() && this.mNewPackage.equals(((CoreMainDevelopmentObject)((Object)this.mObjectToRefactor)).getPackage());
    }

    public Reference getRefactoredReference() {
        return new ForeignReference(this.mObjectToRefactor._getKey().getModelName(), this.mNewPackage, this.mNewName, this.mObjectToRefactor._getKey().getMDOType());
    }

    public boolean hasPackageChanged() {
        return !this.mNewPackage.equals(((CoreMainDevelopmentObject)((Object)this.mObjectToRefactor)).getPackage());
    }

    public boolean hasSourcePathIdentifierChanged() {
        return this.mNewSourcePathIdentifier != null;
    }

    public boolean isConflicting() {
        if (!this.isModified()) {
            return false;
        }
        if (this.mNewName.equals(this.mObjectToRefactor.getName()) && this.mNewPackage.equals(((CoreMainDevelopmentObject)((Object)this.mObjectToRefactor)).getPackage()) && this.mNewParent != null) {
            return false;
        }
        ForeignReference lKeyToCheck = new ForeignReference(this.mObjectToRefactor._getKey().getModelName(), this.mNewPackage, this.mNewName, this.mObjectToRefactor._getKey().getMDOType());
        if (((ForeignReference)this.mObjectToRefactor._getKey()).toLowerString().equals(lKeyToCheck.toLowerString())) {
            return false;
        }
        return this.mObjectToRefactor.getMetamodel().objectExists(lKeyToCheck);
    }

    private String exceptionMessage(String message) {
        return message.substring(0, 1).toUpperCase() + message.substring(1) + "!";
    }
}

