/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.core.marshalling;

import com.sap.ide.metamodel.core.DevelopmentObjectState;
import com.sap.ide.metamodel.core.ForeignReference;
import com.sap.ide.metamodel.core.MetamodelAnnotationImpl;
import com.sap.ide.metamodel.core.Reference;
import com.sap.ide.metamodel.core.RootImpl;
import com.sap.ide.metamodel.core.marshalling.Unmarshaller;
import com.sap.ide.metamodel.general.MDOEnum;
import com.sap.ide.metamodel.general.exception.LoadException;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.io.InputStream;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class XMLUnmarshaller
extends DefaultHandler
implements Unmarshaller {
    private static final Location sLocation = Location.getLocation((String)"com.sap.ide.metamodel.core.marshalling.XMLUnmarshaller");
    protected static final Category sCategoryXML = Category.getCategory((String)"/MetamodelCore/XML");
    private static final Category sCategoryIntegrity = Category.getCategory((String)"/MetamodelCore/Integrity");
    private static final Category sCategoryArchiveAccess = Category.getCategory((String)"/MetamodelCore/ArchiveAccess");
    private Locator mLocator;
    private DevelopmentObjectState lRoot;
    private Stack mParentStack = new Stack();
    private Stack mRoleStack = new Stack();
    private String mMDOPackage;
    private String mMDOName;
    private MDOEnum mMDOType;
    protected RootImpl mRoot;
    private StringBuffer mText = null;
    private boolean mInsideText = false;
    private MetamodelAnnotationImpl mAnnotation = null;
    private boolean mInsideAnnotation = false;

    public DevelopmentObjectState unmarshal(String path) throws LoadException {
        this.mParentStack.clear();
        this.mRoleStack.clear();
        this.lRoot = null;
        try {
            if (path.startsWith("jar:")) {
                InputStream is = this.mRoot._getArchiveManager().getJarEntryInputStream(path);
                if (is == null) {
                    sCategoryXML.fatalT(sLocation, "could not open input stream: " + path);
                    throw new LoadException("Could not open input stream: " + path);
                }
                this.mRoot._getXMLParsingService().parse(is, (ContentHandler)this);
                is.close();
            } else {
                this.mRoot._getXMLParsingService().parse(path, (ContentHandler)this);
            }
            sCategoryXML.infoT(sLocation, "finished parsing file: " + path);
        }
        catch (Exception ex) {
            throw new LoadException("Error parsing file: " + path, ex);
        }
        return this.lRoot;
    }

    public void setDocumentLocator(Locator locator) {
        this.mLocator = locator;
    }

    public void startElement(String parm1, String parm2, String name, Attributes atts) throws SAXException {
        String method = "startElement()";
        if (name.indexOf(46) == -1) {
            DevelopmentObjectState lState = this.instantiateStateClass(name);
            int i = 0;
            while (i < atts.getLength()) {
                lState.setProperty(atts.getQName(i), atts.getValue(i));
                ++i;
            }
            if (this.lRoot == null) {
                this.lRoot = lState;
                this.mMDOPackage = atts.getValue("package");
                this.mMDOName = atts.getValue("name");
                this.mMDOType = this.mRoot._getMDOEnum(name);
            } else {
                String lRoleName = (String)this.mRoleStack.peek();
                ((DevelopmentObjectState)this.mParentStack.peek()).addData(lRoleName.substring(lRoleName.indexOf(46) + 1), lState);
            }
            this.mParentStack.push(lState);
        } else if (name.equals("Core.Reference") || name.equals("Core.ForeignReference")) {
            Reference lReference = null;
            if (atts.getLength() <= 1) {
                lReference = new Reference(this.mMDOPackage, this.mMDOName, this.mMDOType, atts.getValue("path"));
            } else if (name.equals("Core.ForeignReference")) {
                String foreignModel = atts.getValue("modelName");
                RootImpl lRoot = (RootImpl)this.mRoot.getMetamodel().getRoot(foreignModel);
                if (lRoot == null) {
                    String lMessage = "could not access foreign metamodel \"" + foreignModel + "\" (root not instantiated)";
                    sCategoryXML.warningT(sLocation, "startElement()", lMessage);
                    sCategoryIntegrity.warningT(sLocation, "startElement()", lMessage);
                    return;
                }
                lReference = new ForeignReference(foreignModel, atts.getValue("package"), atts.getValue("name"), lRoot._getMDOEnum(atts.getValue("type")), atts.getValue("path"));
            } else {
                lReference = new Reference(atts.getValue("package"), atts.getValue("name"), this.mRoot._getMDOEnum(atts.getValue("type")), atts.getValue("path"));
            }
            String lRoleName = (String)this.mRoleStack.peek();
            String lRelationName = lRoleName.substring(lRoleName.indexOf(46) + 1);
            ((DevelopmentObjectState)this.mParentStack.peek()).addData(lRelationName, lReference);
        } else if (name.equals("Core.Text")) {
            this.mInsideText = true;
        } else if (name.equals("Core.Annotation")) {
            long lTimeStamp = 0L;
            String lkey = atts.getValue("key");
            try {
                lTimeStamp = Long.parseLong(atts.getValue("timestamp"));
            }
            catch (NumberFormatException ex) {
                sCategoryXML.errorT(sLocation, "startElement()", "could not parse annotation timestamp for: " + lkey);
            }
            this.mAnnotation = new MetamodelAnnotationImpl(lkey, lTimeStamp);
            this.mInsideAnnotation = true;
        } else {
            this.mRoleStack.push(name);
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.mInsideText || this.mInsideAnnotation) {
            if (this.mText == null) {
                this.mText = new StringBuffer(String.copyValueOf(ch, start, length));
            } else {
                this.mText.append(String.copyValueOf(ch, start, length));
            }
        }
    }

    public void endElement(String parm1, String parm2, String name) throws SAXException {
        if (this.mText != null) {
            Object lObject = null;
            if (this.mInsideText) {
                lObject = this.mText.toString();
                this.mText = null;
                this.mInsideText = false;
            } else if (this.mInsideAnnotation) {
                this.mAnnotation.setValue(this.mText.toString());
                lObject = this.mAnnotation;
                this.mAnnotation = null;
                this.mText = null;
                this.mInsideAnnotation = false;
            }
            String lRoleName = (String)this.mRoleStack.peek();
            int lPos = lRoleName.indexOf(46);
            ((DevelopmentObjectState)this.mParentStack.peek()).addData(lRoleName.substring(lPos + 1), lObject);
        }
        if (name.indexOf(46) == -1) {
            this.mParentStack.pop();
        } else if (!(name.endsWith(".Parent") || name.equals("Core.Reference") || name.equals("Core.ForeignReference") || name.equals("Core.Text") || name.equals("Core.Annotation"))) {
            this.mRoleStack.pop();
        }
    }

    protected abstract DevelopmentObjectState instantiateStateClass(String var1);
}

