/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.core.i18n;

import com.sap.ide.metamodel.core.CoreMainDevelopmentObject;
import com.sap.ide.metamodel.core.DevelopmentObjectProxy;
import com.sap.ide.metamodel.core.i18n.TextData;
import com.sap.ide.metamodel.core.i18n.TextPoolProxy;
import com.sap.ide.metamodel.core.service.ObjectPathResolver;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.DevelopmentObjectKey;
import com.sap.ide.metamodel.general.Root;
import com.sap.ide.metamodel.general.exception.DataStateDeletedException;
import com.sap.ide.metamodel.general.exception.DataStateInvalidException;
import com.sap.ide.metamodel.general.exception.DeleteException;
import com.sap.ide.metamodel.general.exception.InvalidKeyException;
import com.sap.ide.metamodel.general.i18n.I18NTextProblem;
import com.sap.ide.metamodel.general.i18n.ResourceTypeEnum;
import com.sap.ide.metamodel.general.i18n.TextPool;
import com.sap.ide.metamodel.general.i18n.TranslatableText;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.util.ArrayList;

public class TranslatableTextProxy
implements TranslatableText {
    private static final Location sLocation = Location.getLocation((String)"com.sap.ide.metamodel.core.i18n.TranslatableTextProxy");
    private static final Category sCategoryObjectAccess = Category.getCategory((String)"/MetamodelCore/ObjectAccess");
    private TextPoolProxy mTextPool;
    private String mKey;
    private boolean mDeleted = false;
    private boolean mInvalid = false;
    private Root mRoot = null;
    private boolean mDoNotTranslate = false;
    private DevelopmentObjectProxy mDevelopmentObject = null;
    private boolean mDevelopmentObject_retrieved = false;

    private TranslatableTextProxy() {
    }

    TranslatableTextProxy(String key, TextPoolProxy textPool) {
        this.mTextPool = textPool;
        this.mKey = key;
        this.mRoot = textPool.getOwner().getRoot();
    }

    public synchronized TextPool getTextPool() {
        this.prepareForAccess();
        return this.mTextPool;
    }

    public synchronized String getKey() {
        this.prepareForAccess();
        return this.mKey;
    }

    public synchronized DevelopmentObject getDevelopmentObject() {
        this.prepareForAccess();
        if (!this.mDevelopmentObject_retrieved) {
            String lPath = this.mKey;
            lPath = lPath.substring(0, lPath.lastIndexOf(64));
            DevelopmentObjectKey lKey = null;
            CoreMainDevelopmentObject lMDO = (CoreMainDevelopmentObject)((Object)this.mTextPool.getOwner());
            try {
                lKey = this.mRoot.getMetamodel().createDevelopmentObjectKey(lMDO.getPackage(), lMDO.getName(), lMDO._getType(), lPath);
            }
            catch (InvalidKeyException ike) {
                // empty catch block
            }
            this.mDevelopmentObject = (DevelopmentObjectProxy)this.mRoot.getMetamodel().getObjectFromKey(lKey);
            this.mDevelopmentObject_retrieved = true;
        }
        return this.mDevelopmentObject;
    }

    public synchronized String getAttributeName() {
        this.prepareForAccess();
        return this.mTextPool.getAttributeNameFromTextKey(this.mKey);
    }

    public synchronized String getText() {
        this.prepareForAccess();
        TextData lTextData = this.mTextPool.getTextData(this.mKey);
        if (lTextData != null) {
            return lTextData.getText();
        }
        return "";
    }

    public synchronized void setText(String text) {
        this.prepareForAccess();
        TextData lOldData = this.mTextPool.getTextData(this.mKey);
        this.mTextPool.setTextData(this.mKey, text, lOldData.getType(), lOldData.getMaxLength());
        if (this.mRoot.isEventingEnabled()) {
            String lKey = this.mKey.substring(0, this.mKey.lastIndexOf(64));
            String lPropertyName = this.mKey.substring(this.mKey.lastIndexOf(64) + 1);
            DevelopmentObjectProxy lProxy = ObjectPathResolver.getInstance().getObjectFromPath((DevelopmentObjectProxy)((Object)this.mTextPool.getOwner()), lKey);
            if (lProxy != null) {
                lProxy._notifyPropertyChanged(lPropertyName, lOldData != null ? lOldData.getText() : null, text);
            }
        }
    }

    public synchronized String getText(String language) {
        this.prepareForAccess();
        TextData lTextData = this.mTextPool.getTextData(this.mKey, language);
        if (lTextData != null) {
            return lTextData.getText();
        }
        return "";
    }

    public synchronized void setText(String language, String text) {
        this.prepareForAccess();
        TextData lOldData = this.mTextPool.getTextData(this.mKey, language);
        if (lOldData != null) {
            this.mTextPool.setTextData(this.mKey, language, text, lOldData.getType(), lOldData.getMaxLength());
        } else {
            TextData lMLData = this.mTextPool.getTextData(this.mKey);
            this.mTextPool.setTextData(this.mKey, language, text, lMLData.getType(), lMLData.getMaxLength());
        }
        if (this.mRoot.isEventingEnabled()) {
            String lKey = this.mKey.substring(0, this.mKey.lastIndexOf(64));
            String lPropertyName = this.mKey.substring(this.mKey.lastIndexOf(64) + 1);
            DevelopmentObjectProxy lProxy = ObjectPathResolver.getInstance().getObjectFromPath((DevelopmentObjectProxy)((Object)this.mTextPool.getOwner()), this.mKey);
            if (lProxy != null) {
                lProxy._notifyPropertyChanged(lPropertyName, lOldData != null ? lOldData.getText() : null, text);
            }
        }
    }

    public synchronized String getMasterLanguage() {
        this.prepareForAccess();
        return this.mTextPool.getMasterLanguage();
    }

    public synchronized String getOriginalLanguage() {
        this.prepareForAccess();
        return this.mTextPool.getOriginalLanguage();
    }

    public synchronized String[] getLanguages() {
        this.prepareForAccess();
        return this.mTextPool.getLanguages(this.mKey);
    }

    public synchronized void delete() throws DeleteException {
        this.prepareForAccess();
        this.mTextPool.deleteText(this.mKey);
        this.mDeleted = true;
    }

    public synchronized boolean isReadOnly(String languageKey) {
        this.prepareForAccess();
        return this.mTextPool.isReadOnly(languageKey);
    }

    public synchronized int getMaxLength() {
        this.prepareForAccess();
        String lMaxLength = this.mTextPool.getTextData(this.mKey).getMaxLength();
        if (lMaxLength != null) {
            return Integer.parseInt(lMaxLength);
        }
        return -1;
    }

    public synchronized void setMaxLength(int value) {
        this.prepareForAccess();
        TextData lOldData = this.mTextPool.getTextData(this.mKey);
        String lValueAsString = Integer.toString(value);
        if (!lOldData.getMaxLength().equals(lValueAsString)) {
            this.mTextPool.changeMaxLength(this.mKey, lValueAsString);
        }
    }

    public synchronized ResourceTypeEnum getResourceType() {
        this.prepareForAccess();
        return ResourceTypeEnum.valueOf(this.mTextPool.getTextData(this.mKey).getType());
    }

    public synchronized void setResourceType(ResourceTypeEnum resourceType) {
        this.prepareForAccess();
        String lResourceType = resourceType.toString();
        TextData lOldData = this.mTextPool.getTextData(this.mKey);
        if (!lOldData.getType().equals(lResourceType)) {
            this.mTextPool.changeTextType(this.mKey, lResourceType);
        }
    }

    void setDeleted(boolean value) {
        this.mDeleted = value;
    }

    void _invalidate() {
        this.mInvalid = true;
    }

    private void prepareForAccess() {
        String method = "prepareForAccess()";
        if (this.mDeleted) {
            sCategoryObjectAccess.errorT(sLocation, "prepareForAccess()", "attempt to access deleted text object (Key: " + this.mKey + ", MDO: " + ((DevelopmentObjectProxy)((Object)this.mTextPool.getOwner()))._getKey() + ")");
            throw new DataStateDeletedException(this.mTextPool.getOwner(), this.mKey);
        }
        if (this.mInvalid) {
            sCategoryObjectAccess.errorT(sLocation, "prepareForAccess()", "attempt to access invalid text object (Key: " + this.mKey + ", MDO: " + ((DevelopmentObjectProxy)((Object)this.mTextPool.getOwner()))._getKey() + ")");
            throw new DataStateInvalidException(this.mTextPool.getOwner(), this.mKey);
        }
    }

    public synchronized I18NTextProblem[] validate() {
        this.prepareForAccess();
        if (this.mDoNotTranslate) {
            return new I18NTextProblem[0];
        }
        ArrayList lProblems = new ArrayList();
        String[] lLanguages = this.getLanguages();
        int i = 0;
        while (i < lLanguages.length) {
            lProblems.addAll(this.mTextPool.checkTextData(this.mKey, lLanguages[i]));
            ++i;
        }
        return lProblems.toArray(new I18NTextProblem[0]);
    }

    public synchronized I18NTextProblem[] validate(String language) {
        this.prepareForAccess();
        if (this.mDoNotTranslate) {
            return new I18NTextProblem[0];
        }
        return this.mTextPool.checkTextData(this.mKey, language).toArray(new I18NTextProblem[0]);
    }

    public synchronized void setDoNotTranslate(boolean doNotTranslate) {
        this.prepareForAccess();
        this.mDoNotTranslate = doNotTranslate;
    }

    public synchronized boolean getDoNotTranslate() {
        this.prepareForAccess();
        return this.mDoNotTranslate;
    }
}

