/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.core.i18n;

import com.sap.ide.metamodel.core.CoreMainDevelopmentObject;
import com.sap.ide.metamodel.core.DevelopmentObjectProxy;
import com.sap.ide.metamodel.core.RootImpl;
import com.sap.ide.metamodel.core.i18n.LanguageState;
import com.sap.ide.metamodel.core.i18n.LanguageUnmarshaller;
import com.sap.ide.metamodel.core.i18n.TextData;
import com.sap.ide.metamodel.core.service.LoggingService;
import com.sap.ide.metamodel.general.exception.LoadException;
import com.sap.s2x.S2XDocument;
import com.sap.s2x.etc.TranslationUnit;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.io.File;
import java.io.InputStream;
import java.util.AbstractList;
import java.util.Iterator;

public class S2XLanguageUnmarshaller
implements LanguageUnmarshaller {
    private static final Location sLocation = Location.getLocation((String)"com.sap.ide.metamodel.core.i18n.S2XLanguageUnmarshaller");
    private static final Category sCategoryTexts = Category.getCategory((String)"/MetamodelCore/TranslatableTexts");

    public LanguageState unmarshal(CoreMainDevelopmentObject mdo, String language) throws LoadException {
        String method = "unmarshal()";
        String lPath = mdo.getTextPool().getAbsolutePath(language);
        LanguageState lState = new LanguageState(language, mdo.getMasterLanguage());
        try {
            S2XDocument lDocument = null;
            if (lPath.startsWith("jar:")) {
                InputStream is = ((RootImpl)mdo.getRoot())._getArchiveManager().getJarEntryInputStream(lPath);
                if (is == null) {
                    sCategoryTexts.fatalT(sLocation, "could not open input stream: " + lPath);
                    throw new LoadException("Could not open input stream: " + lPath);
                }
                lDocument = new S2XDocument(is, 2, false);
                is.close();
            } else {
                lDocument = new S2XDocument(new File(lPath), 2, false);
            }
            Iterator it = ((AbstractList)lDocument.getTexts()).iterator();
            while (it.hasNext()) {
                TranslationUnit lTransUnit = (TranslationUnit)it.next();
                String lText = lTransUnit.getSource();
                String lId = lTransUnit.getID();
                String lKey = lTransUnit.getResname();
                String lMaxLen = lTransUnit.getMaxwidth();
                String lType = lTransUnit.getRestype();
                boolean lTranslate = true;
                if (lTransUnit.getTranslate().equals("no")) {
                    lTranslate = false;
                }
                lState.addLanguageText(lKey, new TextData(lId, lText, lType, lMaxLen, lTranslate));
            }
        }
        catch (Exception ex) {
            LoggingService.getInstance().logException(ex, sLocation, sCategoryTexts, "unmarshal()", "error loading language file " + lPath + " for MDO " + ((DevelopmentObjectProxy)((Object)mdo))._getKey() + ": ");
            throw new LoadException(ex);
        }
        return lState;
    }
}

