/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.core.i18n;

import com.sap.ide.metamodel.core.CoreMainDevelopmentObject;
import com.sap.ide.metamodel.core.DevelopmentObjectProxy;
import com.sap.ide.metamodel.core.i18n.LanguageMarshaller;
import com.sap.ide.metamodel.core.i18n.LanguageState;
import com.sap.ide.metamodel.core.i18n.TextData;
import com.sap.ide.metamodel.core.service.LoggingService;
import com.sap.ide.metamodel.general.exception.SaveException;
import com.sap.ide.metamodel.general.i18n.TextPool;
import com.sap.ide.metamodel.general.i18n.TranslatableText;
import com.sap.s2x.S2XDocument;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Iterator;

class S2XLanguageMarshaller
implements LanguageMarshaller {
    private static final Location sLocation = Location.getLocation((String)"com.sap.ide.metamodel.core.i18n.S2XLanguageMarshaller");
    private static final Category sCategoryTexts = Category.getCategory((String)"/MetamodelCore/TranslatableTexts");

    S2XLanguageMarshaller() {
    }

    public void marshal(CoreMainDevelopmentObject mdo, String absolutePathOfLanguage, LanguageState state) throws SaveException {
        String method = "marshal()";
        try {
            this.buildS2XDocument(mdo, state).storeRSX(new File(absolutePathOfLanguage));
        }
        catch (Exception ex) {
            LoggingService.getInstance().logException(ex, sLocation, sCategoryTexts, "marshal()", "error saving language file " + absolutePathOfLanguage + " for MDO " + ((DevelopmentObjectProxy)((Object)mdo))._getKey() + ": ");
            throw new SaveException(ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void marshal(CoreMainDevelopmentObject mdo, LanguageState state, OutputStreamWriter writer) throws SaveException {
        String method = "marshal(FileWriter)";
        ByteArrayOutputStream bos = null;
        try {
            try {
                bos = new ByteArrayOutputStream(2048);
                this.buildS2XDocument(mdo, state).storeRSX((OutputStream)bos);
                writer.write(bos.toString());
            }
            catch (Exception ex) {
                LoggingService.getInstance().logException(ex, sLocation, sCategoryTexts, "marshal(FileWriter)", "error exporting language \"" + state.getLanguage() + "\" to FileWriter for MDO " + ((DevelopmentObjectProxy)((Object)mdo))._getKey() + ": ");
                throw new SaveException(ex);
            }
            Object var8_6 = null;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            try {
                bos.close();
                throw throwable;
            }
            catch (IOException ioe) {
                sCategoryTexts.fatalT(sLocation, "marshal(FileWriter)", "error closing file: " + ioe.getMessage());
                throw new SaveException(ioe);
            }
        }
        try {}
        catch (IOException ioe) {
            sCategoryTexts.fatalT(sLocation, "marshal(FileWriter)", "error closing file: " + ioe.getMessage());
            throw new SaveException(ioe);
        }
        bos.close();
    }

    private S2XDocument buildS2XDocument(CoreMainDevelopmentObject mdo, LanguageState state) throws Exception {
        S2XDocument lDocument = new S2XDocument(false);
        lDocument.setCodepageValidation(false);
        lDocument.setDatatype("s2x");
        String lLanguage = state.getLanguage();
        if (lLanguage.equals("")) {
            lLanguage = mdo.getMasterLanguage();
        }
        lDocument.setSourceLanguage(lLanguage);
        lDocument.setOriginalLocale(mdo.getMasterLanguage());
        lDocument.setDevelContact(mdo.getMetamodel().getUserId());
        DevelopmentObjectProxy lMDO = (DevelopmentObjectProxy)((Object)mdo);
        String lProductName = lMDO.getDevelopmentObjectEnum().toString() + ':' + mdo.getName() + '[' + mdo.getPackage() + ']';
        DevelopmentObjectProxy lParentMDO = (DevelopmentObjectProxy)((DevelopmentObjectProxy)((Object)mdo)).getParent();
        if (lParentMDO != null) {
            lProductName = lProductName + " of " + lParentMDO.getDevelopmentObjectEnum().toString() + ':' + lParentMDO.getName() + '[' + ((CoreMainDevelopmentObject)((Object)lParentMDO)).getPackage() + ']';
        }
        lDocument.setProductname(lProductName);
        TextPool lTextPool = mdo.getTextPool();
        Iterator it = state.keyIterator();
        while (it.hasNext()) {
            String lKey = (String)it.next();
            TextData lTextData = state.getLanguageText(lKey);
            if (lTextData.getId() == null) {
                lTextData.setId(lDocument.addText(lTextData.getText(), lKey, lTextData.getType(), lTextData.getMaxLength()));
            } else {
                lDocument.addText(lTextData.getText(), lTextData.getId(), lKey, lTextData.getType(), lTextData.getMaxLength());
            }
            TranslatableText text = lTextPool.getText(lKey);
            if (text == null || !text.getDoNotTranslate()) continue;
            lDocument.changeTranslate(lTextData.getId(), lTextData.getType());
        }
        return lDocument;
    }
}

