/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.core.i18n;

import com.sap.ide.metamodel.core.Reference;
import com.sap.ide.metamodel.core.i18n.TextData;
import com.sap.ide.metamodel.core.refactoring.RefactoringService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class LanguageState
implements Cloneable {
    private HashMap mLanguageTexts = new HashMap();
    private String mLanguage;
    private String mMasterLanguage;

    private LanguageState() {
    }

    LanguageState(String language, String masterLanguage) {
        this.mLanguage = language;
        this.mMasterLanguage = masterLanguage;
    }

    public Object clone() throws CloneNotSupportedException {
        LanguageState lLanguageState = (LanguageState)super.clone();
        lLanguageState.mLanguageTexts = new HashMap();
        Iterator it = this.mLanguageTexts.keySet().iterator();
        while (it.hasNext()) {
            String lKey = (String)it.next();
            TextData lOldTextData = (TextData)this.mLanguageTexts.get(lKey);
            TextData lNewTextData = new TextData(null, lOldTextData.getText(), lOldTextData.getType(), lOldTextData.getMaxLength());
            lLanguageState.mLanguageTexts.put(lKey, lNewTextData);
        }
        return lLanguageState;
    }

    public void addTexts(LanguageState languageState) {
        Iterator it = languageState.mLanguageTexts.keySet().iterator();
        while (it.hasNext()) {
            String lKey = (String)it.next();
            this.mLanguageTexts.put(lKey, languageState.mLanguageTexts.get(lKey));
        }
    }

    public void removeExternalTexts(ArrayList innerObjectKeys) {
        Iterator it = this.mLanguageTexts.keySet().iterator();
        while (it.hasNext()) {
            String lKey = (String)it.next();
            lKey = lKey.substring(0, lKey.lastIndexOf(64));
            boolean found = false;
            int i = 0;
            while (i < innerObjectKeys.size()) {
                if (((String)innerObjectKeys.get(i)).endsWith(lKey)) {
                    found = true;
                    break;
                }
                ++i;
            }
            if (found) continue;
            it.remove();
        }
    }

    public String getLanguage() {
        return this.mLanguage;
    }

    public String getMasterLanguage() {
        return this.mMasterLanguage;
    }

    boolean isEmpty() {
        return this.mLanguageTexts.isEmpty();
    }

    boolean containsKey(String key) {
        return this.mLanguageTexts.containsKey(key);
    }

    boolean containsPath(String path) {
        Iterator it = this.mLanguageTexts.keySet().iterator();
        while (it.hasNext()) {
            String lTextKey = (String)it.next();
            if (!lTextKey.startsWith(path + "/") && !lTextKey.startsWith(path + "@")) continue;
            return true;
        }
        return false;
    }

    public boolean hasKeysToRefactor(Reference reference, RefactoringService refactoringService) {
        Iterator it = this.mLanguageTexts.keySet().iterator();
        while (it.hasNext()) {
            Reference lReference;
            String lNewKey;
            String lTextKey = (String)it.next();
            if (lTextKey.equals(lNewKey = refactoringService.refactor(lReference = new Reference(reference.getMDOPackage(), reference.getMDOName(), reference.getMDOType(), lTextKey.substring(0, lTextKey.lastIndexOf(64)))).getPath() + lTextKey.substring(lTextKey.lastIndexOf(64)))) continue;
            return true;
        }
        return false;
    }

    public HashMap refactorTextKeys(Reference reference, RefactoringService refactoringService) {
        HashMap<String, String> lResult = new HashMap<String, String>();
        HashMap lKeyChanged = new HashMap();
        Iterator it = this.mLanguageTexts.keySet().iterator();
        while (it.hasNext()) {
            Reference lReference;
            String lNewKey;
            String lTextKey = (String)it.next();
            if (lTextKey.equals(lNewKey = refactoringService.refactor(lReference = new Reference(reference.getMDOPackage(), reference.getMDOName(), reference.getMDOType(), lTextKey.substring(0, lTextKey.lastIndexOf(64)))).getPath() + lTextKey.substring(lTextKey.lastIndexOf(64)))) continue;
            lKeyChanged.put(lNewKey, this.mLanguageTexts.get(lTextKey));
            lResult.put(lTextKey, lNewKey);
            it.remove();
        }
        this.mLanguageTexts.putAll(lKeyChanged);
        return lResult;
    }

    void addLanguageText(String key, TextData textData) {
        TextData lOldData = (TextData)this.mLanguageTexts.get(key);
        if (lOldData != null) {
            textData.setId(lOldData.getId());
        }
        this.mLanguageTexts.put(key, textData);
    }

    void removeLanguageText(String key) {
        this.mLanguageTexts.remove(key);
    }

    TextData getLanguageText(String key) {
        return (TextData)this.mLanguageTexts.get(key);
    }

    void clear() {
        this.mLanguageTexts.clear();
    }

    Iterator keyIterator() {
        return this.mLanguageTexts.keySet().iterator();
    }
}

