/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.core.compare;

import com.sap.ide.metamodel.core.DevelopmentObjectProxy;
import com.sap.ide.metamodel.core.compare.MetamodelDeltaImpl;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.compare.RelationOrderingDelta;
import com.sap.ide.metamodel.general.exception.MetamodelException;
import com.sap.ide.metamodel.general.exception.ReflectionException;
import com.sap.ide.metamodel.general.metainfo.Aggregation;
import com.sap.ide.metamodel.general.metainfo.Association;
import com.sap.ide.metamodel.general.metainfo.Relation;

public class RelationOrderingDeltaImpl
extends MetamodelDeltaImpl
implements RelationOrderingDelta {
    private Relation mRelation;
    private String[] mOldOrdering;
    private String[] mNewOrdering;

    public RelationOrderingDeltaImpl(DevelopmentObjectProxy sourceObject, String relationName, String[] ordering) {
        super(sourceObject);
        this.mRelation = this.mSourceObject.getMetaClass().getRelation(relationName);
        this.mNewOrdering = ordering;
        DevelopmentObject[] lOldObjects = null;
        try {
            lOldObjects = this.mRelation instanceof Aggregation ? this.mSourceObject.getAggregatedObjects((Aggregation)this.mRelation) : this.mSourceObject.getAssociatedObjects((Association)this.mRelation);
            this.mOldOrdering = new String[lOldObjects.length];
            int i = 0;
            while (i < lOldObjects.length) {
                this.mOldOrdering[i] = this.mRelation instanceof Aggregation ? ((DevelopmentObjectProxy)lOldObjects[i])._getAggregationKey() : ((DevelopmentObjectProxy)lOldObjects[i])._getKey().toString();
                ++i;
            }
        }
        catch (ReflectionException ex) {
            this.mOldOrdering = null;
        }
    }

    public void _apply() throws MetamodelException {
        this.mSourceObject.reorderObjects(this.mRelation.getName(), this.mNewOrdering);
    }

    public void _revert() throws MetamodelException {
        this.mSourceObject.reorderObjects(this.mRelation.getName(), this.mOldOrdering);
    }

    public Relation getRelation() {
        return this.mRelation;
    }

    public String[] getNewOrdering() {
        return this.mNewOrdering;
    }

    public String[] getOldOrdering() {
        return this.mOldOrdering;
    }

    public String toString() {
        String lResult = "RelationOrderingDelta(" + this.mSourceObject._getKey() + ", [ ";
        int i = 0;
        while (i < this.mOldOrdering.length) {
            lResult = lResult + "\"" + this.mOldOrdering[i] + "\" ";
            ++i;
        }
        lResult = lResult + "] -> [ ";
        int i2 = 0;
        while (i2 < this.mNewOrdering.length) {
            lResult = lResult + "\"" + this.mNewOrdering[i2] + "\" ";
            ++i2;
        }
        return lResult + "])";
    }
}

