/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.core.compare;

import com.sap.ide.metamodel.general.compare.CompareResult;
import com.sap.ide.metamodel.general.compare.MetamodelDelta;
import com.sap.ide.metamodel.general.exception.MetamodelException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;

public class CompareResultImpl
implements CompareResult {
    private ArrayList mDeltas = new ArrayList();

    public boolean isEmpty() {
        return this.mDeltas.isEmpty();
    }

    public MetamodelDelta[] getDeltas() {
        return this.mDeltas.toArray(new MetamodelDelta[0]);
    }

    public void addDelta(MetamodelDelta delta) {
        this.mDeltas.add(delta);
    }

    public void applyAllDeltas() throws MetamodelException {
        Iterator it = ((AbstractList)this.mDeltas).iterator();
        while (it.hasNext()) {
            MetamodelDelta lDelta = (MetamodelDelta)it.next();
            if (lDelta.isApplied()) continue;
            lDelta.apply();
        }
    }

    public void revertAllDeltas() throws MetamodelException {
        Iterator it = ((AbstractList)this.mDeltas).iterator();
        while (it.hasNext()) {
            MetamodelDelta lDelta = (MetamodelDelta)it.next();
            if (!lDelta.isApplied()) continue;
            lDelta.revert();
        }
    }

    public void merge(CompareResult resultToMerge) {
        MetamodelDelta[] deltas = resultToMerge.getDeltas();
        int i = 0;
        while (i < deltas.length) {
            this.addDelta(deltas[i]);
            ++i;
        }
    }

    public String toString() {
        String lResult = new String();
        Iterator it = ((AbstractList)this.mDeltas).iterator();
        while (it.hasNext()) {
            MetamodelDelta lDelta = (MetamodelDelta)it.next();
            lResult = lResult + lDelta.toString() + "\n";
        }
        return lResult;
    }
}

