/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.core.clipboard;

import com.sap.ide.metamodel.core.clipboard.ClipboardService;
import com.sap.ide.metamodel.core.clipboard.MetamodelClipboardImpl;
import com.sap.ide.metamodel.core.metainfo.AggregationImpl;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.MetamodelObject;
import com.sap.ide.metamodel.general.SourcePathIdentifier;
import com.sap.ide.metamodel.general.clipboard.ClipboardObject;
import com.sap.ide.metamodel.general.clipboard.PasteProcess;
import com.sap.ide.metamodel.general.exception.CreateException;
import com.sap.ide.metamodel.general.exception.IncompleteRefactoringInfoException;
import com.sap.ide.metamodel.general.exception.ObjectInvalidException;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.util.ArrayList;

public class PasteProcessImpl
implements PasteProcess {
    private static final Location sLocation = Location.getLocation((String)"com.sap.ide.metamodel.core.clipboard.PasteProcessImpl");
    private static final Category sCategoryObjectAccess = Category.getCategory((String)"/MetamodelCore/ObjectAccess");
    private MetamodelClipboardImpl mClipboard;
    private MetamodelObject mNewParent;
    private AggregationImpl mAggregation;
    private ClipboardService mClipboardService;
    private SourcePathIdentifier mSourcePathIdentifier;
    private boolean mIsValid;

    public PasteProcessImpl(MetamodelClipboardImpl clipboard, MetamodelObject newParent, AggregationImpl aggregation, ClipboardService clipboardService) {
        this.mClipboard = clipboard;
        this.mNewParent = newParent;
        this.mAggregation = aggregation;
        this.mClipboardService = clipboardService;
        this.mSourcePathIdentifier = null;
        this.mIsValid = true;
    }

    public void setSourcePathIdentifier(SourcePathIdentifier sourcePathIdentifier) {
        this._prepareForAccess();
        this.mSourcePathIdentifier = sourcePathIdentifier;
    }

    public SourcePathIdentifier getSourcePathIdentifier() {
        this._prepareForAccess();
        return this.mSourcePathIdentifier;
    }

    public ClipboardObject[] getClipboardContent() {
        this._prepareForAccess();
        return this.mClipboardService.getClipboardContent();
    }

    public ClipboardObject[] getObjectsToRefactor() {
        this._prepareForAccess();
        return this.mClipboardService.getObjectsToRefactor();
    }

    public DevelopmentObject[] execute() throws CreateException, IncompleteRefactoringInfoException {
        this._prepareForAccess();
        ArrayList lResult = this.mClipboard.executePaste(this.mNewParent, this.mAggregation, this.mSourcePathIdentifier);
        this.mIsValid = false;
        return lResult.toArray(new DevelopmentObject[0]);
    }

    private void _prepareForAccess() throws ObjectInvalidException {
        String method = "_prepareForAccess()";
        if (!this.mIsValid) {
            String lMessage = "attempt to access invalid paste process (already run): " + this;
            sCategoryObjectAccess.errorT(sLocation, "_prepareForAccess()", lMessage);
            throw new ObjectInvalidException(this.exceptionMessage(lMessage));
        }
    }

    private String exceptionMessage(String message) {
        return message.substring(0, 1).toUpperCase() + message.substring(1) + "!";
    }
}

