/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.core.clipboard;

import com.sap.ide.metamodel.Metamodel;
import com.sap.ide.metamodel.core.CoreMainDevelopmentObject;
import com.sap.ide.metamodel.core.DevelopmentObjectProxy;
import com.sap.ide.metamodel.core.DevelopmentObjectState;
import com.sap.ide.metamodel.core.ForeignReference;
import com.sap.ide.metamodel.core.MainDevelopmentObjectState;
import com.sap.ide.metamodel.core.MetamodelObjectImpl;
import com.sap.ide.metamodel.core.Reference;
import com.sap.ide.metamodel.core.RootImpl;
import com.sap.ide.metamodel.core.clipboard.ClipboardService;
import com.sap.ide.metamodel.core.clipboard.PasteProcessImpl;
import com.sap.ide.metamodel.core.i18n.LanguageState;
import com.sap.ide.metamodel.core.i18n.TextPoolProxy;
import com.sap.ide.metamodel.core.metainfo.AggregationImpl;
import com.sap.ide.metamodel.core.metainfo.MetaClassImpl;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.DevelopmentObjectEnum;
import com.sap.ide.metamodel.general.DevelopmentObjectKey;
import com.sap.ide.metamodel.general.MetamodelObject;
import com.sap.ide.metamodel.general.SourcePathIdentifier;
import com.sap.ide.metamodel.general.clipboard.ClipboardObject;
import com.sap.ide.metamodel.general.clipboard.MetamodelClipboard;
import com.sap.ide.metamodel.general.clipboard.PasteProcess;
import com.sap.ide.metamodel.general.exception.CreateException;
import com.sap.ide.metamodel.general.exception.IncompleteRefactoringInfoException;
import com.sap.ide.metamodel.general.exception.ReflectionException;
import com.sap.ide.metamodel.general.metainfo.Aggregation;
import com.sap.ide.metamodel.general.metainfo.CardinalityEnum;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public class MetamodelClipboardImpl
implements MetamodelClipboard {
    private static final Location sLocation = Location.getLocation((String)"com.sap.ide.metamodel.core.clipboard.MetamodelClipboardImpl");
    private static final Category sCategoryClipboard = Category.getCategory((String)"/MetamodelCore/Clipboard");
    private HashMap mReferenceStates;
    private HashMap mReferenceLanguageStates;
    private ArrayList mClonedStatesOrdered;
    private HashMap mClonedStates;
    private HashMap mClonedLanguageStates;
    private ClipboardService mClipboardService;
    private ArrayList mInnerObjectKeys;
    private HashSet mRootClassNames;
    private ArrayList mPotentialMDOsToRefactor;
    private DevelopmentObjectKey mOldParentKey;
    private Metamodel mSourceMetamodel;
    private boolean mMultipleAggregations;
    private boolean mMultipleObjects;
    private HashMap mRootAggregations;
    private HashSet mRootMetaClasses;

    public MetamodelClipboardImpl() {
        this.init();
    }

    public synchronized void clear() {
        this.init();
    }

    public synchronized boolean isEmpty() {
        return this.mReferenceStates.isEmpty();
    }

    private void init() {
        this.mReferenceStates = new HashMap();
        this.mReferenceLanguageStates = new HashMap();
        this.mClipboardService = new ClipboardService();
        this.mInnerObjectKeys = null;
        this.mRootClassNames = null;
        this.mPotentialMDOsToRefactor = null;
        this.mOldParentKey = null;
        this.mSourceMetamodel = null;
        this.mRootAggregations = null;
        this.mRootMetaClasses = null;
    }

    public synchronized void copy(DevelopmentObject objectToCopy) {
        this.copy(new DevelopmentObject[]{objectToCopy});
    }

    public synchronized void copy(DevelopmentObject[] objectsToCopy) {
        int i;
        String method = "copy(DevelopmentObject[])";
        ArrayList<DevelopmentObject> lList = new ArrayList<DevelopmentObject>();
        int i2 = 0;
        while (i2 < objectsToCopy.length) {
            if (objectsToCopy[i2] != null && !lList.contains(objectsToCopy[i2])) {
                lList.add(objectsToCopy[i2]);
            }
            ++i2;
        }
        DevelopmentObject[] lObjectsToCopy = lList.toArray(new DevelopmentObject[0]);
        if (lObjectsToCopy.length == 0) {
            return;
        }
        this.mMultipleAggregations = false;
        DevelopmentObjectProxy lFirstObject = (DevelopmentObjectProxy)lObjectsToCopy[0];
        this.mSourceMetamodel = lFirstObject.getMetamodel();
        MetamodelObjectImpl lFirstParent = (MetamodelObjectImpl)((Object)lFirstObject.getParent());
        if (lFirstParent == null) {
            lFirstParent = (MetamodelObjectImpl)((Object)lFirstObject.getRoot());
        }
        String lFirstRole = lFirstParent._getAggregatedViaRole(lFirstObject);
        this.mOldParentKey = null;
        if (lFirstParent instanceof DevelopmentObjectProxy && lFirstObject.isMDO()) {
            this.mOldParentKey = ((DevelopmentObjectProxy)lFirstParent)._getKey();
        }
        if (lObjectsToCopy.length > 1) {
            i = 1;
            while (i < lObjectsToCopy.length) {
                MetamodelObjectImpl lParent = (MetamodelObjectImpl)((Object)lObjectsToCopy[i].getParent());
                if (lParent == null) {
                    lParent = (MetamodelObjectImpl)((Object)lObjectsToCopy[i].getRoot());
                }
                if (lParent != lFirstParent) {
                    String lMessage = "all objects to be copied must have the same parent";
                    sCategoryClipboard.errorT(sLocation, "copy(DevelopmentObject[])", lMessage);
                    throw new IllegalArgumentException(this.exceptionMessage(lMessage));
                }
                if (!lParent._getAggregatedViaRole((DevelopmentObjectProxy)lObjectsToCopy[i]).equals(lFirstRole)) {
                    this.mMultipleAggregations = true;
                }
                if (lObjectsToCopy[i].getMetamodel() != this.mSourceMetamodel) {
                    String lMessage = "all objects to be copied must belong to the same metamodel";
                    sCategoryClipboard.errorT(sLocation, "copy(DevelopmentObject[])", lMessage);
                    throw new IllegalArgumentException(this.exceptionMessage(lMessage));
                }
                ++i;
            }
        }
        this.mMultipleObjects = lObjectsToCopy.length > 1;
        this.mRootClassNames = new HashSet();
        i = 0;
        while (i < lObjectsToCopy.length) {
            String lClassName = lObjectsToCopy[i].getClass().getName();
            lClassName = lClassName.substring(0, lClassName.indexOf("Proxy"));
            lClassName = lClassName.substring(lClassName.lastIndexOf(46) + 1);
            this.mRootClassNames.add(lClassName);
            ++i;
        }
        this.mRootAggregations = new HashMap();
        Aggregation[] lAggregations = lFirstParent.getMetaClass().getAllAggregations();
        int i3 = 0;
        while (i3 < lObjectsToCopy.length) {
            String lRole = lFirstParent._getAggregatedViaRole((DevelopmentObjectProxy)lObjectsToCopy[i3]);
            int lPos = lRole.indexOf(123);
            if (lPos != -1) {
                lRole = lRole.substring(0, lPos);
            }
            int j = 0;
            while (j < lAggregations.length) {
                if (lAggregations[j].getSingularName().equals(lRole)) {
                    this.mRootAggregations.put(lObjectsToCopy[i3].getKey(), lAggregations[j]);
                }
                ++j;
            }
            ++i3;
        }
        this.mRootMetaClasses = new HashSet();
        int i4 = 0;
        while (i4 < lObjectsToCopy.length) {
            this.mRootMetaClasses.add(lObjectsToCopy[i4].getMetaClass());
            ++i4;
        }
        this.createReferenceCopy(lObjectsToCopy);
    }

    public synchronized boolean isPasteAllowed(MetamodelObject newParent) {
        if (this.isEmpty() || newParent == null) {
            return false;
        }
        if (newParent instanceof DevelopmentObjectProxy && ((DevelopmentObjectProxy)newParent).originatesInArchive()) {
            return false;
        }
        ArrayList lAggregations = null;
        if (this.mMultipleAggregations) {
            lAggregations = ((MetaClassImpl)newParent.getMetaClass())._getAllAggregations();
            if (!lAggregations.containsAll(this.mRootAggregations.values())) {
                return false;
            }
            Iterator it = this.mRootAggregations.values().iterator();
            while (it.hasNext()) {
                Aggregation lAggregation = (Aggregation)it.next();
                if (lAggregation.getCardinality() != CardinalityEnum.SINGLE) continue;
                try {
                    if (((DevelopmentObject)newParent).getAggregatedObject(lAggregation) == null) continue;
                    return false;
                }
                catch (ReflectionException ex) {
                    // empty catch block
                }
            }
            return true;
        }
        lAggregations = this._getAllowedTargetAggregations(newParent);
        return lAggregations != null && !lAggregations.isEmpty();
    }

    public synchronized DevelopmentObjectKey[] getContent() {
        return this.mClipboardService.getRootObjectKeys();
    }

    public synchronized DevelopmentObjectEnum[] getContentTypes() {
        ClipboardObject[] lObjects = this.mClipboardService.getClipboardContent();
        ArrayList<DevelopmentObjectEnum> lResult = new ArrayList<DevelopmentObjectEnum>();
        int i = 0;
        while (i < lObjects.length) {
            lResult.add(lObjects[i].getType());
            ++i;
        }
        return lResult.toArray(new DevelopmentObjectEnum[0]);
    }

    public synchronized Metamodel getSourceMetamodel() {
        return this.mSourceMetamodel;
    }

    private void createReferenceCopy(DevelopmentObject[] objects) {
        TextPoolProxy lTextPool;
        Object it;
        this.mReferenceStates.clear();
        this.mReferenceLanguageStates.clear();
        this.mClipboardService.clear();
        this.mInnerObjectKeys = new ArrayList();
        this.mPotentialMDOsToRefactor = new ArrayList();
        ArrayList<DevelopmentObjectProxy> lToClone = new ArrayList<DevelopmentObjectProxy>();
        int i = 0;
        while (i < objects.length) {
            DevelopmentObjectProxy lProxy = (DevelopmentObjectProxy)objects[i];
            it = lProxy.iterator();
            while (it.hasNext()) {
                DevelopmentObjectProxy lProxy2 = (DevelopmentObjectProxy)it.next();
                DevelopmentObjectKey lKey = lProxy2._getKey();
                lProxy2._getState().setProxyReference((ForeignReference)lKey);
                this.mInnerObjectKeys.add(((ForeignReference)lKey).toReferenceString());
                this.mClipboardService.add(lProxy2);
                if (!lProxy2.isMDO() && lProxy2 != lProxy) continue;
                lToClone.add(lProxy2);
                if (!lProxy2.isMDO()) continue;
                this.mPotentialMDOsToRefactor.add(lKey);
                lTextPool = (TextPoolProxy)((CoreMainDevelopmentObject)((Object)lProxy2)).getTextPool();
                LanguageState lClonedLanguageState = lTextPool.cloneOriginalLanguage();
                if (lClonedLanguageState == null) continue;
                this.mReferenceLanguageStates.put(lKey, lClonedLanguageState);
            }
            ++i;
        }
        Iterator it2 = ((AbstractList)lToClone).iterator();
        while (it2.hasNext()) {
            DevelopmentObjectProxy lProxy = (DevelopmentObjectProxy)it2.next();
            try {
                this.mReferenceStates.put(lProxy._getKey(), (DevelopmentObjectState)lProxy._getState().clone());
            }
            catch (CloneNotSupportedException ex) {
                // empty catch block
            }
        }
        it = this.mReferenceStates.values().iterator();
        while (it.hasNext()) {
            ((DevelopmentObjectState)it.next()).removeExternalReferences(this.mInnerObjectKeys);
        }
        int i2 = 0;
        while (i2 < objects.length) {
            LanguageState lLanguageState;
            DevelopmentObjectProxy lProxy = (DevelopmentObjectProxy)objects[i2];
            if (!lProxy.isMDO() && (lLanguageState = (lTextPool = (TextPoolProxy)lProxy._getMDO().getTextPool()).cloneOriginalLanguage()) != null) {
                lLanguageState.removeExternalTexts(this.mInnerObjectKeys);
                this.mReferenceLanguageStates.put(lProxy._getKey(), lLanguageState);
            }
            ++i2;
        }
    }

    private void createClones(String targetLanguage) {
        Reference lNewKey;
        this.mClonedStates = new HashMap();
        this.mClonedStatesOrdered = new ArrayList();
        this.mClonedLanguageStates = new HashMap();
        DevelopmentObjectKey[] lRootKeys = this.mClipboardService.getRootObjectKeys();
        int i = 0;
        while (i < lRootKeys.length) {
            Reference lKey = (Reference)((Object)lRootKeys[i]);
            if (!this.mClipboardService.isExcluded(lKey)) {
                Reference lNewKey2 = this.mClipboardService.refactor(lKey);
                DevelopmentObjectState lState = null;
                try {
                    lState = (DevelopmentObjectState)((DevelopmentObjectState)this.mReferenceStates.get(lKey)).clone();
                }
                catch (CloneNotSupportedException ex) {
                    // empty catch block
                }
                lState.refactor(this.mClipboardService);
                this.mClonedStates.put(lNewKey2.toReferenceString(), lState);
                this.mClonedStatesOrdered.add(lState);
            }
            ++i;
        }
        Iterator it = this.mReferenceStates.keySet().iterator();
        while (it.hasNext()) {
            Reference lKey = (Reference)it.next();
            boolean found = false;
            int i2 = 0;
            while (i2 < lRootKeys.length) {
                if (lRootKeys[i2].equals(lKey)) {
                    found = true;
                    break;
                }
                ++i2;
            }
            if (found || this.mClipboardService.isExcluded(lKey)) continue;
            lNewKey = this.mClipboardService.refactor(lKey);
            DevelopmentObjectState lState = null;
            try {
                lState = (DevelopmentObjectState)((DevelopmentObjectState)this.mReferenceStates.get(lKey)).clone();
            }
            catch (CloneNotSupportedException ex) {
                // empty catch block
            }
            lState.refactor(this.mClipboardService);
            this.mClonedStates.put(lNewKey.toReferenceString(), lState);
        }
        Iterator it2 = this.mReferenceLanguageStates.keySet().iterator();
        while (it2.hasNext()) {
            Reference lKey = (Reference)it2.next();
            LanguageState lReferenceState = (LanguageState)this.mReferenceLanguageStates.get(lKey);
            if (!lReferenceState.getMasterLanguage().equals(targetLanguage)) continue;
            lNewKey = this.mClipboardService.refactor(lKey);
            LanguageState lLanguageState = null;
            try {
                lLanguageState = (LanguageState)lReferenceState.clone();
            }
            catch (CloneNotSupportedException ex) {
                // empty catch block
            }
            DevelopmentObjectState lObjectState = (DevelopmentObjectState)this.mClonedStates.get(lNewKey.toReferenceString());
            this.mClonedLanguageStates.put(lObjectState, lLanguageState);
            lLanguageState.refactorTextKeys(lKey, this.mClipboardService.getRefactoringService());
        }
    }

    public synchronized PasteProcess initiatePaste(MetamodelObject newParent, Aggregation aggregation) {
        return this._initiatePaste(newParent, (AggregationImpl)aggregation);
    }

    public synchronized PasteProcess initiatePaste(MetamodelObject newParent) {
        AggregationImpl lAggregation = null;
        ArrayList lAggregations = this._getAllowedTargetAggregations(newParent);
        if (lAggregations.size() == 1) {
            lAggregation = (AggregationImpl)lAggregations.get(0);
        }
        return this._initiatePaste(newParent, lAggregation);
    }

    private PasteProcess _initiatePaste(MetamodelObject newParent, AggregationImpl aggregation) {
        DevelopmentObjectKey lNewParentKey;
        ArrayList lAggregations;
        DevelopmentObjectProxy lProxy;
        String method = "_initiatePaste()";
        if (newParent == null) {
            String lMessage = "new parent is null";
            sCategoryClipboard.errorT(sLocation, "_initiatePaste()", lMessage);
            throw new IllegalArgumentException(this.exceptionMessage(lMessage));
        }
        if (newParent instanceof DevelopmentObjectProxy && !(lProxy = (DevelopmentObjectProxy)newParent)._isValid()) {
            String lMessage = "the new parent " + lProxy._getKey() + " is not valid";
            sCategoryClipboard.errorT(sLocation, "_initiatePaste()", lMessage);
            throw new IllegalArgumentException(this.exceptionMessage(lMessage));
        }
        if (!this.isPasteAllowed(newParent)) {
            String lMessage = "new parent is not compatible with clipboard content";
            sCategoryClipboard.errorT(sLocation, "_initiatePaste()", lMessage);
            throw new IllegalArgumentException(this.exceptionMessage(lMessage));
        }
        if (aggregation != null && ((lAggregations = this._getAllowedTargetAggregations(newParent)).isEmpty() || !lAggregations.contains(aggregation))) {
            String lMessage = "aggregation is not compatible with clipboard content";
            sCategoryClipboard.errorT(sLocation, "_initiatePaste()", lMessage);
            throw new IllegalArgumentException(this.exceptionMessage(lMessage));
        }
        this.mClipboardService.reset();
        if (this.mOldParentKey != null && !this.mOldParentKey.equals(lNewParentKey = ((DevelopmentObjectProxy)newParent)._getKey())) {
            this.mClipboardService.getRefactoringService().add((Reference)((Object)this.mOldParentKey), (Reference)((Object)lNewParentKey));
        }
        Metamodel lMetamodel = newParent.getMetamodel();
        Iterator it = ((AbstractList)this.mPotentialMDOsToRefactor).iterator();
        while (it.hasNext()) {
            DevelopmentObjectKey lKey = (DevelopmentObjectKey)it.next();
            if (!lMetamodel.objectExists(lKey)) continue;
            this.mClipboardService.setRefactoringRequired(lKey);
        }
        if (newParent instanceof DevelopmentObject) {
            DevelopmentObjectKey lParentKey = ((DevelopmentObjectProxy)newParent)._getKey();
            DevelopmentObjectKey[] lRootKeys = this.mClipboardService.getRootObjectKeys();
            int i = 0;
            while (i < lRootKeys.length) {
                DevelopmentObjectKey lKey = lRootKeys[i];
                String lName = lKey.getPath();
                if ((lName = lName.substring(lName.lastIndexOf(47) + 1)).indexOf(58) != -1) {
                    lName = lName.substring(lName.indexOf(58) + 1);
                    AggregationImpl lAggregation = aggregation;
                    if (lAggregation == null) {
                        lAggregation = (AggregationImpl)this.mRootAggregations.get(lKey);
                    }
                    try {
                        if (((DevelopmentObject)newParent).getAggregatedObject(lAggregation, lName) != null) {
                            this.mClipboardService.setRefactoringRequired(lKey);
                        }
                    }
                    catch (ReflectionException ex) {
                        // empty catch block
                    }
                }
                ++i;
            }
        }
        return new PasteProcessImpl(this, newParent, aggregation, this.mClipboardService);
    }

    public synchronized ArrayList executePaste(MetamodelObject newParent, AggregationImpl aggregation, SourcePathIdentifier sourcePathIdentifier) throws IncompleteRefactoringInfoException, CreateException {
        String method = "executePaste()";
        if (!newParent.isValid()) {
            String lMessage = "the new parent is not valid any more: " + (newParent instanceof RootImpl ? newParent.toString() : ((DevelopmentObjectProxy)newParent)._getKey().toString());
            sCategoryClipboard.fatalT(sLocation, "executePaste()", lMessage);
            throw new CreateException(this.exceptionMessage(lMessage));
        }
        if (this.mClipboardService.isEverythingExcluded()) {
            return new ArrayList();
        }
        this.mClipboardService.checkAllKeysRefactored();
        this.mClipboardService.checkMDOPathLengths(newParent.getMetamodel().getMDOLocator(), sourcePathIdentifier);
        this.mClipboardService.refactorKeys(newParent, aggregation);
        String lTargetMetamodelLanguage = newParent.getMetamodel().getLanguage();
        this.createClones(lTargetMetamodelLanguage);
        Iterator it = this.mClonedStates.values().iterator();
        while (it.hasNext()) {
            DevelopmentObjectState lState = (DevelopmentObjectState)it.next();
            lState.refactorInnerReferences(this.mInnerObjectKeys, this.mClipboardService);
            if (!(lState instanceof MainDevelopmentObjectState)) continue;
            ((MainDevelopmentObjectState)((Object)lState)).setMasterLanguage(lTargetMetamodelLanguage);
        }
        ArrayList lResult = null;
        if (newParent instanceof DevelopmentObject) {
            sCategoryClipboard.infoT(sLocation, "executePaste()", "pasting " + this.mClonedStates.size() + " object(s) below new parent " + ((DevelopmentObjectProxy)newParent)._getKey());
            HashMap lAggregationsToUse = null;
            if (aggregation == null) {
                lAggregationsToUse = new HashMap();
                Iterator it2 = this.mRootAggregations.keySet().iterator();
                while (it2.hasNext()) {
                    Reference lKey = (Reference)it2.next();
                    DevelopmentObjectState lState = (DevelopmentObjectState)this.mClonedStates.get(this.mClipboardService.refactor(lKey).toReferenceString());
                    lAggregationsToUse.put(lState, this.mRootAggregations.get(lKey));
                }
            }
            try {
                lResult = ((DevelopmentObjectProxy)newParent)._clipboardPaste(aggregation, lAggregationsToUse, this.mClonedStatesOrdered, this.mClonedStates, this.mClonedLanguageStates, sourcePathIdentifier);
            }
            catch (CreateException ex) {
                this.mClonedStates = null;
                this.mClonedStatesOrdered = null;
                this.mClonedLanguageStates = null;
                throw ex;
            }
        }
        sCategoryClipboard.infoT(sLocation, "executePaste()", "pasting " + this.mClonedStates.size() + " object(s) below root " + newParent);
        try {
            lResult = ((RootImpl)newParent)._clipboardPaste(this.mClonedStates, this.mClonedLanguageStates, sourcePathIdentifier);
        }
        catch (CreateException ex) {
            this.mClonedStates = null;
            this.mClonedStatesOrdered = null;
            this.mClonedLanguageStates = null;
            throw ex;
        }
        this.mClonedStates = null;
        this.mClonedStatesOrdered = null;
        this.mClonedLanguageStates = null;
        return lResult;
    }

    public synchronized Aggregation[] getAllowedTargetAggregations(MetamodelObject newParent) {
        if (this.isEmpty() || newParent == null || this.mMultipleAggregations) {
            return new Aggregation[0];
        }
        return this._getAllowedTargetAggregations(newParent).toArray(new Aggregation[0]);
    }

    private ArrayList _getAllowedTargetAggregations(MetamodelObject newParent) {
        if (this.isEmpty()) {
            return new ArrayList();
        }
        MetaClassImpl lParent = (MetaClassImpl)newParent.getMetaClass();
        if (!this.mMultipleObjects) {
            MetaClassImpl lTarget = (MetaClassImpl)this.mRootMetaClasses.iterator().next();
            ArrayList lAggregations = lParent._getAllAggregationsTo(lTarget);
            if (lAggregations.isEmpty()) {
                return lAggregations;
            }
            ArrayList<Aggregation> lResult = new ArrayList<Aggregation>();
            Iterator it = ((AbstractList)lAggregations).iterator();
            while (it.hasNext()) {
                Aggregation lAggregation = (Aggregation)it.next();
                if (lAggregation.getCardinality() == CardinalityEnum.MULTIPLE) {
                    lResult.add(lAggregation);
                }
                if (lAggregation.getCardinality() != CardinalityEnum.SINGLE) continue;
                try {
                    if (((DevelopmentObject)newParent).getAggregatedObject(lAggregation) != null) continue;
                    lResult.add(lAggregation);
                }
                catch (ReflectionException ex) {
                    // empty catch block
                }
            }
            return lResult;
        }
        MetaClassImpl[] lClasses = ((AbstractCollection)this.mRootMetaClasses).toArray(new MetaClassImpl[0]);
        MetaClassImpl lCommonSuperClass = MetaClassImpl.getLeastCommonSuperClass(lClasses);
        ArrayList lAggregations = lParent._getAllAggregationsTo(lCommonSuperClass);
        if (lAggregations.isEmpty()) {
            return lAggregations;
        }
        ArrayList<Aggregation> lResult = new ArrayList<Aggregation>();
        Iterator it = ((AbstractList)lAggregations).iterator();
        while (it.hasNext()) {
            Aggregation lAggregation = (Aggregation)it.next();
            if (lAggregation.getCardinality() != CardinalityEnum.MULTIPLE) continue;
            lResult.add(lAggregation);
        }
        return lResult;
    }

    private String exceptionMessage(String message) {
        return message.substring(0, 1).toUpperCase() + message.substring(1) + "!";
    }
}

