/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.core.clipboard;

import com.sap.ide.metamodel.core.DevelopmentObjectProxy;
import com.sap.ide.metamodel.core.ForeignReference;
import com.sap.ide.metamodel.core.metainfo.AggregationImpl;
import com.sap.ide.metamodel.core.service.NamingServiceImpl;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.DevelopmentObjectEnum;
import com.sap.ide.metamodel.general.DevelopmentObjectKey;
import com.sap.ide.metamodel.general.MetamodelObject;
import com.sap.ide.metamodel.general.clipboard.ClipboardObject;
import com.sap.ide.metamodel.general.metainfo.CardinalityEnum;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ClipboardObjectImpl
implements ClipboardObject {
    private static final Location sLocation = Location.getLocation((String)"com.sap.ide.metamodel.core.clipboard.ClipboardObjectImpl");
    protected static final Category sCategoryRefactoring = Category.getCategory((String)"/MetamodelCore/Refactoring");
    private static NamingServiceImpl sNamingService = NamingServiceImpl.getInstance();
    private DevelopmentObjectKey mOriginalKey = null;
    private String mOriginalPackage = null;
    private String mOriginalName = null;
    private String mNewPackage = null;
    private String mNewName = null;
    private DevelopmentObjectEnum mType = null;
    private boolean mIsMDO = false;
    private boolean mRequiresRefactoring = false;
    private boolean mExclude = false;
    private ClipboardObjectImpl mParentObject = null;
    private ArrayList mChildObjects = new ArrayList();

    ClipboardObjectImpl(DevelopmentObjectProxy object) {
        this.mOriginalKey = object._getKey();
        this.mType = object.getDevelopmentObjectEnum();
        if (object.isMDO()) {
            this.mNewPackage = this.mOriginalPackage = this.mOriginalKey.getMDOPackage();
            this.mNewName = this.mOriginalName = this.mOriginalKey.getMDOName();
            this.mIsMDO = true;
        } else {
            this.mNewName = this.mOriginalName = object.getName();
        }
    }

    public String getNewName() {
        return this.mNewName;
    }

    public String getNewPackage() {
        return this.mNewPackage;
    }

    public void setNewName(String newName) {
        String method = "setNewName()";
        if (newName != null && this.mNewName.equals(newName)) {
            return;
        }
        boolean lValid = false;
        lValid = this.mIsMDO ? sNamingService.isValidMainDevelopmentObjectName(newName) : sNamingService.isValidDevelopmentObjectName(newName);
        if (!lValid) {
            String lMessage = "the new name \"" + newName + "\" is empty or contains illegal characters";
            sCategoryRefactoring.errorT(sLocation, "setNewName()", lMessage);
            throw new IllegalArgumentException(this.exceptionMessage(lMessage));
        }
        this.mNewName = newName;
    }

    public void setNewPackage(String newPackage) {
        String method = "setNewPackage()";
        if (!this.mIsMDO || newPackage != null && this.mNewPackage.equals(newPackage)) {
            return;
        }
        if (!sNamingService.isValidMainDevelopmentObjectPackage(newPackage)) {
            String lMessage = "the new package \"" + newPackage + "\" is not valid or contains illegal characters";
            sCategoryRefactoring.errorT(sLocation, "setNewPackage()", lMessage);
            throw new IllegalArgumentException(this.exceptionMessage(lMessage));
        }
        this.mNewPackage = newPackage;
    }

    public boolean isMDO() {
        return this.mIsMDO;
    }

    public DevelopmentObjectEnum getType() {
        return this.mType;
    }

    public boolean isModified() {
        if (this.mNewPackage == null) {
            return !this.mNewName.equals(this.mOriginalName);
        }
        return !this.mNewName.equals(this.mOriginalName) || !this.mNewPackage.equals(this.mOriginalPackage);
    }

    public String toString() {
        String lResult = "";
        if (this.mNewPackage != null) {
            lResult = this.mNewPackage + ".";
        }
        return lResult + this.mNewName + " (type: " + this.mType + ")";
    }

    public DevelopmentObjectKey getOriginalKey() {
        return this.mOriginalKey;
    }

    DevelopmentObjectKey getRefactoredKey(MetamodelObject newParent, AggregationImpl aggregation) {
        if (this.mIsMDO) {
            return new ForeignReference(this.mOriginalKey.getModelName(), this.mNewPackage, this.mNewName, this.mOriginalKey.getMDOType());
        }
        String lOldPath = this.mOriginalKey.getPath();
        String lLastSegment = null;
        if (aggregation != null) {
            lLastSegment = aggregation.getCardinality() == CardinalityEnum.SINGLE ? aggregation.getName() : aggregation.getSingularName() + ":" + this.mNewName;
        } else {
            lLastSegment = lOldPath.substring(lOldPath.lastIndexOf(47) + 1);
            if (lLastSegment.indexOf(58) != -1) {
                lLastSegment = lLastSegment.substring(0, lLastSegment.indexOf(58) + 1) + this.mNewName;
            }
        }
        if (newParent != null && newParent instanceof DevelopmentObject) {
            DevelopmentObjectKey lNewParentKey = ((DevelopmentObjectProxy)newParent)._getKey();
            String lPath = null;
            lPath = this.mParentObject == null ? (lNewParentKey.getPath().equals("") ? lLastSegment : lNewParentKey.getPath() + "/" + lLastSegment) : lOldPath.substring(0, lOldPath.lastIndexOf(47) + 1) + lLastSegment;
            return new ForeignReference(lNewParentKey.getModelName(), lNewParentKey.getMDOPackage(), lNewParentKey.getMDOName(), lNewParentKey.getMDOType(), lPath);
        }
        String lPath = lOldPath.substring(0, lOldPath.lastIndexOf(47) + 1) + lLastSegment;
        return new ForeignReference(this.mOriginalKey.getModelName(), this.mOriginalKey.getMDOPackage(), this.mOriginalKey.getMDOName(), this.mOriginalKey.getMDOType(), lPath);
    }

    public void reset() {
        this.mNewPackage = this.mOriginalPackage;
        this.mNewName = this.mOriginalName;
        this.mExclude = false;
        this.mRequiresRefactoring = false;
    }

    public void setParent(ClipboardObjectImpl parentObject) {
        this.mParentObject = parentObject;
        parentObject.addChild(this);
    }

    public void addChild(ClipboardObjectImpl childObject) {
        this.mChildObjects.add(childObject);
    }

    public void setRequiresRefactoring(boolean requiresRefactoring) {
        this.mRequiresRefactoring = requiresRefactoring;
    }

    public boolean requiresRefactoring() {
        return this.mRequiresRefactoring;
    }

    public void setExcluded(boolean exclude) {
        this.mExclude = exclude;
    }

    public boolean getExcluded() {
        return this.mExclude;
    }

    public boolean isExcluded() {
        if (this.mExclude) {
            return true;
        }
        ClipboardObject lObject = this.mParentObject;
        while (lObject != null) {
            if (lObject.getExcluded()) {
                return true;
            }
            lObject = lObject.getParent();
        }
        return false;
    }

    public ClipboardObject getParent() {
        return this.mParentObject;
    }

    public ClipboardObject[] getChildren() {
        return this.mChildObjects.toArray(new ClipboardObject[0]);
    }

    private void _getAllChildren(ArrayList result) {
        result.add(this);
        Iterator it = ((AbstractList)this.mChildObjects).iterator();
        while (it.hasNext()) {
            ((ClipboardObjectImpl)it.next())._getAllChildren(result);
        }
    }

    public Iterator iterator() {
        ArrayList lAllChildren = new ArrayList();
        this._getAllChildren(lAllChildren);
        return new Iterator(lAllChildren){
            private ArrayList mElements;
            private int mIndex;
            private final /* synthetic */ ArrayList val$lAllChildren;
            {
                this.mElements = this.val$lAllChildren = val$lAllChildren;
                this.mIndex = 0;
            }

            public boolean hasNext() {
                return this.mIndex < this.mElements.size();
            }

            public Object next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("No more children available!");
                }
                return this.mElements.get(this.mIndex++);
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private String exceptionMessage(String message) {
        return message.substring(0, 1).toUpperCase() + message.substring(1) + "!";
    }
}

