/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.core;

import com.sap.ide.metamodel.Metamodel;
import com.sap.ide.metamodel.core.DevelopmentObjectProxy;
import com.sap.ide.metamodel.core.ForeignReference;
import com.sap.ide.metamodel.core.MetamodelObjectImpl;
import com.sap.ide.metamodel.core.PostOrderIterator;
import com.sap.ide.metamodel.core.PreOrderIterator;
import com.sap.ide.metamodel.core.compare.AggregationNegativeDeltaImpl;
import com.sap.ide.metamodel.core.compare.AggregationPositiveDeltaImpl;
import com.sap.ide.metamodel.core.compare.CompareResultImpl;
import com.sap.ide.metamodel.core.marshalling.Marshaller;
import com.sap.ide.metamodel.core.marshalling.Unmarshaller;
import com.sap.ide.metamodel.core.metainfo.MetaClassImpl;
import com.sap.ide.metamodel.core.service.ArchiveManager;
import com.sap.ide.metamodel.core.service.NotificationService;
import com.sap.ide.metamodel.core.service.ObjectCacheManager;
import com.sap.ide.metamodel.core.service.XMLParsingService;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.DevelopmentObjectEnum;
import com.sap.ide.metamodel.general.DevelopmentObjectObserver;
import com.sap.ide.metamodel.general.MDOEnum;
import com.sap.ide.metamodel.general.MDOLocator;
import com.sap.ide.metamodel.general.MetamodelIterator;
import com.sap.ide.metamodel.general.Root;
import com.sap.ide.metamodel.general.RootMDOEnum;
import com.sap.ide.metamodel.general.SourcePathIdentifier;
import com.sap.ide.metamodel.general.TraverseModeEnum;
import com.sap.ide.metamodel.general.compare.CompareResult;
import com.sap.ide.metamodel.general.exception.CreateException;
import com.sap.ide.metamodel.general.exception.LoadException;
import com.sap.ide.metamodel.general.exception.ObjectInvalidException;
import com.sap.ide.metamodel.general.exception.ReflectionException;
import com.sap.ide.metamodel.general.metainfo.Aggregation;
import com.sap.ide.metamodel.general.metainfo.MetaClass;
import com.sap.tc.logging.Location;
import java.lang.reflect.Method;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;

public abstract class RootImpl
extends MetamodelObjectImpl
implements Root {
    private static final Location sLocation = Location.getLocation((String)"com.sap.ide.metamodel.core.RootImpl");
    private boolean mEventingEnabled = false;
    private boolean mIsValid = true;
    protected ArchiveManager _mArchiveManager;
    protected XMLParsingService _mXMLParsingService;
    protected MDOLocator _mMDOLocator;
    static /* synthetic */ Class class$java$lang$String;

    protected RootImpl() {
        this._mNotificationService = new NotificationService();
    }

    public abstract DevelopmentObject getObjectFromKey(ForeignReference var1);

    public abstract MDOEnum _getMDOEnum(String var1);

    public abstract ArrayList _getMDOEnums();

    public abstract void _reload() throws LoadException;

    public abstract boolean _isPasteAllowed(HashSet var1);

    public abstract ArrayList _clipboardPaste(HashMap var1, HashMap var2, SourcePathIdentifier var3) throws CreateException;

    public abstract void _childObjectRefactored(String var1, DevelopmentObjectProxy var2);

    public abstract Marshaller getMarshaller();

    public abstract Unmarshaller getUnmarshaller();

    public abstract Vector _getAllChildren();

    public ObjectCacheManager _getObjectCacheManager() {
        return this._mObjectCacheManager;
    }

    public ArchiveManager _getArchiveManager() {
        return this._mArchiveManager;
    }

    public XMLParsingService _getXMLParsingService() {
        return this._mXMLParsingService;
    }

    public MDOLocator _getMDOLocator() {
        return this._mMDOLocator;
    }

    public synchronized void enableEventing() {
        this._prepareForAccess();
        String method = "enableEventing()";
        this.mEventingEnabled = true;
        MetamodelObjectImpl.sCategoryEventing.infoT(sLocation, "enableEventing()", "{" + this._mName + "} enabling eventing");
    }

    public synchronized void disableEventing() {
        this._prepareForAccess();
        String method = "disableEventing()";
        this.mEventingEnabled = false;
        MetamodelObjectImpl.sCategoryEventing.infoT(sLocation, "disableEventing()", "{" + this._mName + "} disabling eventing");
    }

    public synchronized boolean isEventingEnabled() {
        this._prepareForAccess();
        return this.mEventingEnabled;
    }

    public void enableAutoNotify() {
        this._prepareForAccess();
        String method = "enableAutoNotify()";
        MetamodelObjectImpl.sCategoryEventing.infoT(sLocation, "enableAutoNotify()", "{" + this._mName + "} enabling auto-notify");
        this._mNotificationService.setAutoNotify(true);
    }

    public void disableAutoNotify() {
        this._prepareForAccess();
        String method = "disableAutoNotify()";
        MetamodelObjectImpl.sCategoryEventing.infoT(sLocation, "disableAutoNotify()", "{" + this._mName + "} disabling auto-notify");
        this._mNotificationService.setAutoNotify(false);
    }

    public boolean isAutoNotifyEnabled() {
        this._prepareForAccess();
        return this._mNotificationService.getAutoNotify();
    }

    public void attachGlobalObserver(DevelopmentObjectObserver observer) {
        this._prepareForAccess();
        this._mNotificationService.registerGlobalObserver(observer, 65535);
    }

    public void attachGlobalObserver(DevelopmentObjectObserver observer, int eventMask) {
        this._prepareForAccess();
        this._mNotificationService.registerGlobalObserver(observer, eventMask);
    }

    public void detachGlobalObserver(DevelopmentObjectObserver observer) {
        this._prepareForAccess();
        this._mNotificationService.unregisterGlobalObserver(observer);
    }

    public void detachAllGlobalObservers() {
        this._prepareForAccess();
        this._mNotificationService.unregisterAllGlobalObservers();
    }

    public void attachClassObserver(Class clazz, DevelopmentObjectObserver observer) {
        this._prepareForAccess();
        this._mNotificationService.registerClassObserver(clazz, observer, 65535);
    }

    public void attachClassObserver(Class clazz, DevelopmentObjectObserver observer, int eventMask) {
        this._prepareForAccess();
        this._mNotificationService.registerClassObserver(clazz, observer, eventMask);
    }

    public void detachClassObserver(Class clazz, DevelopmentObjectObserver observer) {
        this._prepareForAccess();
        this._mNotificationService.unregisterClassObserver(clazz, observer);
    }

    public void detachAllClassObservers(Class clazz) {
        this._prepareForAccess();
        this._mNotificationService.unregisterAllClassObservers(clazz);
    }

    public void notifyObservers() {
        this._prepareForAccess();
        this._mNotificationService.notifyObservers();
    }

    public void rescanRootMDOs() throws LoadException {
        this._prepareForAccess();
        MetamodelObjectImpl.sCategoryMDOLocating.infoT(sLocation, "rescanRootMDOs()", "rescanning filesystem and archives for root MDOs...");
        this._reload();
    }

    public NotificationService _getNotificationService() {
        return this._mNotificationService;
    }

    public void _invalidate() {
        this.mIsValid = false;
    }

    public boolean isValid() {
        return this.mIsValid;
    }

    public MetamodelIterator iterator(TraverseModeEnum traverseMode) {
        Metamodel metamodel = this._mMetamodel;
        synchronized (metamodel) {
            if (traverseMode == TraverseModeEnum.PREORDER) {
                PreOrderIterator preOrderIterator = new PreOrderIterator(this);
                return preOrderIterator;
            }
            PostOrderIterator postOrderIterator = new PostOrderIterator(this);
            return postOrderIterator;
        }
    }

    public DevelopmentObject[] getAggregatedObjects(Aggregation aggregation, String _package) throws ReflectionException {
        this._prepareForAccess();
        Metamodel metamodel = this._mMetamodel;
        synchronized (metamodel) {
            MetaClassImpl lMyMetaClass = (MetaClassImpl)this.getMetaClass();
            if (aggregation == null) {
                throw new ReflectionException("illegal argument: null");
            }
            if (!lMyMetaClass._getAllAggregations().contains(aggregation)) {
                throw new ReflectionException("illegal argument: given relation does not exist in: " + lMyMetaClass.getName());
            }
            try {
                Class<?> lInterface = Class.forName(aggregation.getParent().getName(), true, this.getClass().getClassLoader());
                Method lMethod = lInterface.getMethod("get" + aggregation.getName(), class$java$lang$String == null ? (class$java$lang$String = RootImpl.class$("java.lang.String")) : class$java$lang$String);
                Object lResult = lMethod.invoke((Object)this, _package);
                DevelopmentObject[] developmentObjectArray = (DevelopmentObject[])lResult;
                return developmentObjectArray;
            }
            catch (Exception ex) {
                throw new ReflectionException(ex);
            }
        }
    }

    protected void _prepareForAccess() throws ObjectInvalidException {
        String method = "_prepareForAccess()";
        if (!this.mIsValid) {
            String lMessage = "attempt to access invalid root object: " + this;
            MetamodelObjectImpl.sCategoryObjectAccess.errorT(sLocation, "_prepareForAccess()", lMessage);
            throw new ObjectInvalidException(this.exceptionMessage(lMessage));
        }
    }

    private String exceptionMessage(String message) {
        return message.substring(0, 1).toUpperCase() + message.substring(1) + "!";
    }

    public CompareResult compareTo(Root root) {
        return this.compareTo(root, true, true, false);
    }

    public CompareResult compareTo(Root root, boolean includeChildren, boolean includeAssociations, boolean includeDanglingReferences) {
        DevelopmentObjectProxy proxy2;
        CompareResultImpl lResult = new CompareResultImpl();
        Vector children1 = this._getAllChildren();
        Vector children2 = ((RootImpl)root)._getAllChildren();
        HashMap<MetaClass, Aggregation> aggregationMap = new HashMap<MetaClass, Aggregation>();
        Aggregation[] aggregations = this.getMetaClass().getAggregations();
        int i = 0;
        while (i < aggregations.length) {
            aggregationMap.put(aggregations[i].getTargetClass(), aggregations[i]);
            ++i;
        }
        Iterator it = ((AbstractList)children1).iterator();
        while (it.hasNext()) {
            DevelopmentObjectProxy proxy1 = (DevelopmentObjectProxy)it.next();
            proxy2 = (DevelopmentObjectProxy)((RootImpl)root).getObjectFromKey((ForeignReference)proxy1._getKey());
            if (proxy2 != null) {
                lResult.merge(proxy1.compareTo(proxy2, includeChildren, includeAssociations, includeDanglingReferences));
                children2.remove(proxy2);
                continue;
            }
            lResult.addDelta(new AggregationNegativeDeltaImpl(this, (Aggregation)aggregationMap.get(proxy1.getMetaClass()), proxy1));
        }
        Iterator it2 = ((AbstractList)children2).iterator();
        while (it2.hasNext()) {
            proxy2 = (DevelopmentObjectProxy)it2.next();
            lResult.addDelta(new AggregationPositiveDeltaImpl(this, (Aggregation)aggregationMap.get(proxy2.getMetaClass()), proxy2));
        }
        return lResult;
    }

    public abstract RootMDOEnum[] getRootMDOEnums();

    public abstract MDOEnum[] getMDOEnums();

    public abstract DevelopmentObjectEnum[] getDevelopmentObjectEnums();

    public abstract MetaClass getMetaClass(String var1);

    public abstract MetaClass getMetaClass(DevelopmentObjectEnum var1);

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

