/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.core;

import com.sap.ide.metamodel.general.MDOEnum;

public class Reference {
    protected String mMDOPackage = "";
    protected String mMDOName = "";
    protected MDOEnum mMDOType = null;
    protected String mPath = "";
    protected String mString = null;

    protected Reference() {
    }

    public Reference(String mdoPackage, String mdoName, MDOEnum mdoType) {
        this.mMDOPackage = mdoPackage;
        this.mMDOName = mdoName;
        this.mMDOType = mdoType;
    }

    public Reference(String mdoPackage, String mdoName, MDOEnum mdoType, String path) {
        this.mMDOPackage = mdoPackage;
        this.mMDOName = mdoName;
        this.mMDOType = mdoType;
        if (path != null) {
            this.mPath = path;
        }
    }

    public String getMDOPackage() {
        return this.mMDOPackage;
    }

    public String getMDOName() {
        return this.mMDOName;
    }

    public MDOEnum getMDOType() {
        return this.mMDOType;
    }

    public String getPath() {
        return this.mPath;
    }

    public boolean refersToMDO() {
        return this.mPath.equals("");
    }

    public boolean equals(Reference reference) {
        if (reference == null) {
            return false;
        }
        return this.mMDOPackage.equals(reference.getMDOPackage()) && this.mMDOName.equals(reference.getMDOName()) && this.mMDOType == reference.getMDOType() && this.mPath.equals(reference.getPath());
    }

    public boolean equals(Object object) {
        if (!(object instanceof Reference)) {
            return false;
        }
        return this.equals((Reference)object);
    }

    public String toMDOString() {
        return this.mMDOType + ":" + this.mMDOPackage + "." + this.mMDOName;
    }

    public String toReferenceString() {
        if (this.mString == null) {
            this.mString = this.mMDOType + ":" + this.mMDOPackage + "." + this.mMDOName;
            if (this.mPath.length() > 0) {
                this.mString = this.mString + "/" + this.mPath;
            }
        }
        return this.mString;
    }

    public String toString() {
        return this.toReferenceString();
    }
}

