/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.core;

import com.sap.ide.metamodel.core.DevelopmentObjectProxy;
import com.sap.ide.metamodel.core.ForeignReference;
import com.sap.ide.metamodel.core.MainDevelopmentObjectState;
import com.sap.ide.metamodel.core.MetamodelAnnotationImpl;
import com.sap.ide.metamodel.core.Reference;
import com.sap.ide.metamodel.core.clipboard.ClipboardService;
import com.sap.ide.metamodel.core.compare.CompareContext;
import com.sap.ide.metamodel.core.refactoring.RefactoringService;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public abstract class DevelopmentObjectState
implements Cloneable {
    private static final Location sLocation = Location.getLocation((String)"com.sap.ide.metamodel.core.DevelopmentObjectState");
    protected static final Category sCategoryXML = Category.getCategory((String)"/MetamodelCore/XML");
    private String mName = null;
    private HashMap mUnrecognizedProperties = new HashMap();
    private HashMap mUnrecognizedRelations = new HashMap();
    private HashMap mMetamodelAnnotationsByKey = new HashMap();
    private ArrayList mMetamodelAnnotations = new ArrayList();
    protected ForeignReference mProxyRef = null;

    public Object clone() throws CloneNotSupportedException {
        DevelopmentObjectState lState = (DevelopmentObjectState)super.clone();
        lState.mMetamodelAnnotations = new ArrayList();
        lState.mMetamodelAnnotationsByKey = new HashMap();
        Iterator it = ((AbstractList)this.mMetamodelAnnotations).iterator();
        while (it.hasNext()) {
            MetamodelAnnotationImpl lAnnotation = (MetamodelAnnotationImpl)((MetamodelAnnotationImpl)it.next()).clone();
            lState.mMetamodelAnnotations.add(lAnnotation);
            lState.mMetamodelAnnotationsByKey.put(lAnnotation.getKey(), lAnnotation);
        }
        return super.clone();
    }

    public abstract void refactor(ClipboardService var1);

    public abstract void removeExternalReferences(ArrayList var1);

    public abstract void refactorInnerReferences(ArrayList var1, ClipboardService var2);

    public abstract boolean _hasReferencesToRefactor(Reference var1);

    public abstract void refactorReferences(RefactoringService var1);

    public boolean isEqualTo(DevelopmentObjectState object, boolean isRootObject) {
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        if (!isRootObject) {
            return this.mName.equals(object.mName);
        }
        return true;
    }

    public void compareTo(DevelopmentObjectProxy sourceObject, DevelopmentObjectState object, CompareContext compareContext, boolean isRootObject) {
        if (!isRootObject && !this.mName.equals(object.mName)) {
            compareContext.addPropertyDelta(sourceObject, "name", object.mName);
        }
    }

    public void setName(String name) {
        this.mName = name;
    }

    public String getName() {
        return this.mName;
    }

    public void refactor(String newName, String newPackage) {
        this.mName = newName;
        if (this instanceof MainDevelopmentObjectState) {
            ((MainDevelopmentObjectState)((Object)this)).setPackage(newPackage);
        }
    }

    public void setProxyReference(ForeignReference proxyRef) {
        this.mProxyRef = proxyRef;
    }

    public ForeignReference getProxyReference() {
        return this.mProxyRef;
    }

    public HashMap getUnrecognizedProperties() {
        return this.mUnrecognizedProperties;
    }

    public HashMap getUnrecognizedRelations() {
        return this.mUnrecognizedRelations;
    }

    public ArrayList getMetamodelAnnotations() {
        return this.mMetamodelAnnotations;
    }

    MetamodelAnnotationImpl getMetamodelAnnotation(String key) {
        return (MetamodelAnnotationImpl)this.mMetamodelAnnotationsByKey.get(key);
    }

    void addMetamodelAnnotation(MetamodelAnnotationImpl annotation) {
        if (this.mMetamodelAnnotationsByKey.containsKey(annotation.getKey())) {
            Iterator it = ((AbstractList)this.mMetamodelAnnotations).iterator();
            while (it.hasNext()) {
                if (!((MetamodelAnnotationImpl)it.next()).getKey().equals(annotation.getKey())) continue;
                it.remove();
                break;
            }
        }
        this.mMetamodelAnnotations.add(annotation);
        this.mMetamodelAnnotationsByKey.put(annotation.getKey(), annotation);
    }

    void removeMetamodelAnnotation(String key) {
        ((AbstractCollection)this.mMetamodelAnnotations).remove(this.mMetamodelAnnotationsByKey.get(key));
        this.mMetamodelAnnotationsByKey.remove(key);
    }

    public void setProperty(String propertyName, Object value) {
        String method = "setProperty()";
        if (!propertyName.startsWith("xmlns")) {
            this.mUnrecognizedProperties.put(propertyName, value);
            String lMessage = "unknown attribute \"" + propertyName + "\" added to state <" + this.toString() + "> as unrecognized property.";
            sCategoryXML.warningT(sLocation, "setProperty()", lMessage);
        }
    }

    public void addData(String roleName, Object data) {
        String method = "addData()";
        if (roleName.equals("Annotations")) {
            this.addMetamodelAnnotation((MetamodelAnnotationImpl)data);
        } else {
            sCategoryXML.warningT(sLocation, "addData()", "unknown relation \"" + roleName + "\" found.");
            this.addUnrecognizedData(roleName, data);
        }
    }

    protected void addUnrecognizedData(String roleName, Object data) {
        String method = "addUnrecognizedData()";
        ArrayList<Object> lRelationEntries = (ArrayList<Object>)this.mUnrecognizedRelations.get(roleName);
        if (lRelationEntries == null) {
            lRelationEntries = new ArrayList<Object>();
            this.mUnrecognizedRelations.put(roleName, lRelationEntries);
        }
        lRelationEntries.add(data);
        String lMessage = "sub-object <" + data.toString() + "> added to state <" + this.toString() + "> into list of unrecognized relation entries for relation \"" + roleName + "\").";
        sCategoryXML.warningT(sLocation, "addUnrecognizedData()", lMessage);
    }

    public String toString() {
        String className = this.getClass().getName();
        int pos = className.lastIndexOf(46);
        if (pos > 0) {
            className = className.substring(pos + 1);
        }
        return className + ":" + this.mName;
    }
}

