/*
 * Decompiled with CFR 0.152.
 */
package sqlj.runtime.profile;

import java.io.InvalidObjectException;
import java.io.ObjectInputValidation;
import java.io.Serializable;
import sqlj.runtime.profile.SetTransactionDescriptor;
import sqlj.runtime.profile.TypeInfo;

public abstract class EntryInfo
implements Serializable,
ObjectInputValidation {
    public static final int PREPARED_STATEMENT = 2;
    public static final int CALLABLE_STATEMENT = 4;
    public static final int EXECUTE_UPDATE = 8;
    public static final int EXECUTE_QUERY = 16;
    public static final int EXECUTE = 24;
    public static final int QUERY = 2;
    public static final int STATEMENT = 3;
    public static final int CALL = 4;
    public static final int VALUES = 5;
    public static final int POSITIONED = 6;
    public static final int QUERY_FOR_UPDATE = 7;
    public static final int SINGLE_ROW_QUERY = 8;
    public static final int BLOCK = 9;
    public static final int COMMIT = 11;
    public static final int ROLLBACK = 12;
    public static final int SET_TRANSACTION = 17;
    public static final int ITERATOR_CONVERSION = 18;
    public static final int UNTYPED_SELECT = 19;
    public static final int SCROLLABLE_RESULT = 256;
    public static final int HOLDABLE_RESULT = 512;
    public static final int OTHER = 1024;
    public static final int NO_RESULT = 128;
    public static final int NAMED_RESULT = 32;
    public static final int POSITIONED_RESULT = 64;
    static final long serialVersionUID = 241067723671289526L;

    public abstract String getSQLString();

    public abstract int getStatementType();

    public static boolean isValidStatementType(int statementType) {
        switch (statementType) {
            case 2: 
            case 4: {
                return true;
            }
        }
        return false;
    }

    public static String statementTypeToString(int type) {
        switch (type) {
            case 2: {
                return "PREPARED_STATEMENT";
            }
            case 4: {
                return "CALLABLE_STATEMENT";
            }
        }
        return type + "";
    }

    public abstract int getExecuteType();

    public static boolean isValidExecuteType(int execType) {
        switch (execType) {
            case 8: 
            case 16: 
            case 24: {
                return true;
            }
        }
        return false;
    }

    public static String executeTypeToString(int executeType) {
        switch (executeType) {
            case 8: {
                return "EXECUTE_UPDATE";
            }
            case 16: {
                return "EXECUTE_QUERY";
            }
            case 24: {
                return "EXECUTE";
            }
        }
        return executeType + "";
    }

    public abstract int getRole();

    public static boolean isDefinedRole(int role) {
        switch (role) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 17: 
            case 18: 
            case 19: 
            case 1024: {
                return true;
            }
        }
        return false;
    }

    public static boolean isValidRole(int role) {
        return EntryInfo.isDefinedRole(role) || role > 1024;
    }

    public static String roleToString(int role) {
        switch (role) {
            case 2: {
                return "QUERY";
            }
            case 3: {
                return "STATEMENT";
            }
            case 4: {
                return "CALL";
            }
            case 5: {
                return "VALUES";
            }
            case 6: {
                return "POSITIONED";
            }
            case 7: {
                return "QUERY_FOR_UPDATE";
            }
            case 8: {
                return "SINGLE_ROW_QUERY";
            }
            case 9: {
                return "BLOCK";
            }
            case 1024: {
                return "OTHER";
            }
            case 11: {
                return "COMMIT";
            }
            case 12: {
                return "ROLLBACK";
            }
            case 17: {
                return "SET_TRANSACTION";
            }
            case 18: {
                return "ITERATOR_CONVERSION";
            }
            case 19: {
                return "UNTYPED_SELECT";
            }
        }
        return role + "";
    }

    public abstract int getResultSetType();

    public static boolean isValidResultSetType(int resultSetType) {
        switch (resultSetType) {
            case 32: 
            case 64: 
            case 128: {
                return true;
            }
        }
        return false;
    }

    public static String resultSetTypeToString(int type) {
        switch (type) {
            case 128: {
                return "NO_RESULT";
            }
            case 32: {
                return "NAMED_RESULT";
            }
            case 64: {
                return "POSITIONED_RESULT";
            }
        }
        return type + "";
    }

    public abstract int getResultSetCount();

    public abstract TypeInfo getResultSetInfo(int var1);

    public abstract String getResultSetName();

    public abstract int getParamCount();

    public abstract TypeInfo getParamInfo(int var1);

    public abstract Object getDescriptor();

    public SetTransactionDescriptor getTransactionDescriptor() {
        switch (this.getRole()) {
            case 17: {
                return (SetTransactionDescriptor)this.getDescriptor();
            }
        }
        return null;
    }

    public static boolean isValidDescriptor(Object descriptor, int role) {
        switch (role) {
            case 6: {
                return descriptor instanceof Integer;
            }
            case 17: {
                return descriptor instanceof SetTransactionDescriptor;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 18: 
            case 19: {
                return descriptor == null;
            }
        }
        return role >= 1024 || descriptor == null;
    }

    public abstract int getLineNumber();

    public void validateObject() throws InvalidObjectException {
        int stmtType = this.getStatementType();
        if (!EntryInfo.isValidStatementType(stmtType)) {
            throw new InvalidObjectException("invalid statement type: " + stmtType);
        }
        int execType = this.getExecuteType();
        if (!EntryInfo.isValidExecuteType(execType)) {
            throw new InvalidObjectException("invalid execute type: " + execType);
        }
        int role = this.getRole();
        if (!EntryInfo.isValidRole(role)) {
            throw new InvalidObjectException("invalid role: " + role);
        }
        int resultSetType = this.getResultSetType();
        if (!EntryInfo.isValidResultSetType(resultSetType)) {
            throw new InvalidObjectException("invalid result set type: " + resultSetType);
        }
        Object desc = this.getDescriptor();
        if (!EntryInfo.isValidDescriptor(desc, role)) {
            throw new InvalidObjectException("invalid descriptor: " + desc);
        }
    }
}

