/*
 * Decompiled with CFR 0.152.
 */
package sqlj.runtime;

import java.sql.Connection;
import sqlj.runtime.profile.Loader;

public abstract class RuntimeContext {
    private static RuntimeContext m_runtime = null;
    public static final String PROPERTY_KEY = "sqlj.runtime";
    public static final String DEFAULT_RUNTIME = "sqlj.runtime.DefaultRuntime";
    public static final String DEFAULT_DATA_SOURCE = "jdbc/defaultDataSource";

    public static RuntimeContext getRuntime() {
        if (m_runtime == null) {
            String runtimeName = DEFAULT_RUNTIME;
            runtimeName = System.getProperty(PROPERTY_KEY, DEFAULT_RUNTIME);
            try {
                m_runtime = (RuntimeContext)Class.forName(runtimeName).newInstance();
            }
            catch (ClassNotFoundException e) {
                RuntimeContext.throwNoClassDefFoundError(runtimeName, e);
            }
            catch (IllegalAccessException e) {
                RuntimeContext.throwNoClassDefFoundError(runtimeName, e);
            }
            catch (IllegalArgumentException e) {
                RuntimeContext.throwNoClassDefFoundError(runtimeName, e);
            }
            catch (InstantiationException e) {
                RuntimeContext.throwNoClassDefFoundError(runtimeName, e);
            }
        }
        return m_runtime;
    }

    private static void throwNoClassDefFoundError(String runtimeName, Exception e) {
        throw new NoClassDefFoundError("Exception occured on looking up rutintime class \"" + runtimeName + "\": " + e.getMessage());
    }

    public abstract Loader getLoaderForClass(Class var1);

    public abstract Connection getDefaultConnection();
}

