/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.tree;

import com.sap.sql.tree.Query;
import com.sap.sql.tree.SQLVisitor;
import com.sap.sql.tree.SqlTextExpert;
import com.sap.sql.tree.TableReference;

public class NonJoinQuery
extends Query {
    public static final int UNION = 1;
    public static final int UNION_ALL = 2;
    public static final int INTERSECT = 3;
    public static final int INTERSECT_ALL = 4;
    public static final int EXCEPT = 5;
    public static final int EXCEPT_ALL = 6;
    private Query leftOperand;
    private Query rightOperand;
    private int setOperator;

    public NonJoinQuery(Query theLeftOperand, int aSetOperator, Query theRightOperand) {
        this.leftOperand = theLeftOperand;
        this.setOperator = aSetOperator;
        this.rightOperand = theRightOperand;
    }

    public void accept(SQLVisitor visitor) {
        visitor.visitNonJoinQueryBefore(this);
        if (this.leftOperand != null) {
            this.leftOperand.accept(visitor);
        }
        if (this.rightOperand != null) {
            this.rightOperand.accept(visitor);
        }
        visitor.visitNonJoinQuery(this);
    }

    public Query getLeftOperand() {
        return this.leftOperand;
    }

    public int getOperator() {
        return this.setOperator;
    }

    public Query getRightOperand() {
        return this.rightOperand;
    }

    public void toSqlTxt(SqlTextExpert expert, StringBuffer strBuf) {
        if (this.leftOperand instanceof TableReference) {
            strBuf.append("TABLE ");
        } else if (this.leftOperand instanceof NonJoinQuery) {
            strBuf.append("(");
        }
        this.leftOperand.toSqlTxt(expert, strBuf);
        if (this.leftOperand instanceof NonJoinQuery) {
            strBuf.append(")");
        }
        switch (this.setOperator) {
            case 1: {
                strBuf.append(" UNION ");
                break;
            }
            case 2: {
                strBuf.append(" UNION ALL ");
                break;
            }
            case 3: {
                strBuf.append(" INTERSECT ");
                break;
            }
            case 4: {
                strBuf.append(" INTERSECT ALL ");
                break;
            }
            case 5: {
                strBuf.append(" EXCEPT ");
                break;
            }
            case 6: {
                strBuf.append(" EXCEPT ALL ");
                break;
            }
        }
        if (this.rightOperand instanceof TableReference) {
            strBuf.append("TABLE ");
        } else if (this.rightOperand instanceof NonJoinQuery) {
            strBuf.append("(");
        }
        this.rightOperand.toSqlTxt(expert, strBuf);
        if (this.rightOperand instanceof NonJoinQuery) {
            strBuf.append(")");
        }
    }
}

